/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem;

import com.neutronio.astrax.util.TargetSettings;
import com.neutronio.astrax.util.collections.ProbabilitySet;
import java.util.ArrayList;
import java.util.List;

public class OrbitalRing {
    private ProbabilitySet<TargetSettings> allowedObjects = new ProbabilitySet();
    private float innerRadius;
    private float outerRadius;
    private boolean habitableZone;
    private float habitability;

    public static List<OrbitalRing> getOrbitalSections(float width, float height, int count, float maxExtent) {
        float startMin;
        int starStartSpacing = 100;
        int starSpacing = 120;
        ArrayList<OrbitalRing> sections = new ArrayList<OrbitalRing>();
        float orbitWidth = maxExtent / (float)count;
        float min = startMin = Math.max(width, height) + (float)starStartSpacing;
        float max = startMin + orbitWidth;
        for (int i2 = 0; i2 < count; ++i2) {
            OrbitalRing ring = new OrbitalRing();
            ring.setBounds(min, max);
            sections.add(ring);
            min = min + orbitWidth + (float)starSpacing;
            max = max + orbitWidth + (float)starSpacing;
        }
        return sections;
    }

    public ProbabilitySet<TargetSettings> getAllowedObjects() {
        return this.allowedObjects;
    }

    public void setAllowedObjects(ProbabilitySet<TargetSettings> allowedObjects) {
        this.allowedObjects = allowedObjects;
    }

    public void setBounds(float innerRadius, float outerRadius) {
        this.innerRadius = innerRadius;
        this.outerRadius = outerRadius;
    }

    public float getInnerRadius() {
        return this.innerRadius;
    }

    public void setInnerRadius(float innerRadius) {
        this.innerRadius = innerRadius;
    }

    public float getOuterRadius() {
        return this.outerRadius;
    }

    public void setOuterRadius(float outerRadius) {
        this.outerRadius = outerRadius;
    }
}

