/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem;

import com.badlogic.gdx.graphics.Color;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.GenerationSettings;
import com.neutronio.astrax.app.datapack.game.world.Discovery;
import com.neutronio.astrax.app.datapack.game.world.OrbitRingSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetClass;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetType;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.TextureCreationSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.PlanetFactory;
import com.neutronio.astrax.app.generator.ProducedBy;
import com.neutronio.astrax.app.repository.RepositoryEntity;
import com.neutronio.astrax.app.repository.Tagged;
import com.neutronio.astrax.io.binary.game.world.galaxy.SavedPlanetCreationSettings;
import com.neutronio.astrax.util.JSONUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@ProducedBy(value=PlanetFactory.class)
public class PlanetCreationSettings
extends RepositoryEntity
implements GenerationSettings,
Tagged {
    public String entityId;
    public String name;
    public String icon;
    public String description;
    public Discovery.Rarity rarity;
    public int discoveryPoints;
    public Float scale;
    public Float axisTilt;
    public PlanetClass planetClass;
    public PlanetType planetType;
    public List<String> traits = new ArrayList<String>();
    public List<TextureCreationSettings> textureSettings = new ArrayList<TextureCreationSettings>();
    public ArrayList<OrbitRingSettings> orbitRingSettings = new ArrayList();
    public boolean useShadowMask = false;
    public List<String> tags = new ArrayList<String>();

    public PlanetCreationSettings() {
    }

    public PlanetCreationSettings(SavedPlanetCreationSettings savedSettings) {
        if (!savedSettings.isGeneratedPlanet()) {
            throw new AstraXException(AstraXException.ErrorCode.E0004, "Cannot create planet: obtain PlanetCreationSettings from the repository instead!");
        }
        this.entityId = savedSettings.entityId;
        this.name = savedSettings.name;
        this.icon = savedSettings.icon;
        this.description = savedSettings.description;
        this.scale = savedSettings.scale;
        this.axisTilt = savedSettings.axisTilt;
        this.planetClass = JSONUtils.toEnum(PlanetClass.class, savedSettings.planetClass);
        this.planetType = JSONUtils.toEnum(PlanetType.class, savedSettings.planetType);
        this.traits = Collections.unmodifiableList(savedSettings.traits);
        this.textureSettings = Collections.unmodifiableList(savedSettings.textureSettings);
        this.useShadowMask = savedSettings.useShadowMask;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Float getScale() {
        return this.scale;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setScale(Float scale) {
        this.scale = scale;
    }

    public Float getAxisTilt() {
        return this.axisTilt;
    }

    public void setAxisTilt(Float axisTilt) {
        this.axisTilt = axisTilt;
    }

    public List<String> getTraits() {
        return this.traits;
    }

    public void setTraits(List<String> traits) {
        this.traits = traits;
    }

    public void addTextureSetting(float rotation, String textureRegion, Color tint) {
        TextureCreationSettings creationSettings = new TextureCreationSettings();
        creationSettings.rotation = rotation;
        creationSettings.texture = textureRegion;
        creationSettings.color = tint;
        this.textureSettings.add(creationSettings);
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }
}

