/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.EntityIDFactory;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.ResourceDeposit;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.ResourceDepositSettings;
import com.neutronio.astrax.app.datapack.game.world.CelestialTarget;
import com.neutronio.astrax.app.datapack.game.world.OrbitRingSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetCreationSettingsRepository;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetGenerationSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetTrait;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetTraitRepository;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.TextureGenerationSetting;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.Planet;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.PlanetCreationSettings;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.generator.ForNameSpace;
import com.neutronio.astrax.app.generator.Generator;
import com.neutronio.astrax.app.generator.GenericFactory;
import com.neutronio.astrax.app.generator.NameSpace;
import com.neutronio.astrax.app.generator.TargetFactory;
import com.neutronio.astrax.app.generator.TreeGenerator;
import com.neutronio.astrax.app.repository.ResourceRepository;
import com.neutronio.astrax.gfx.entities.PlanetGraphics;
import com.neutronio.astrax.gfx.factories.PlanetGraphicsFactory;
import com.neutronio.astrax.io.binary.Serializer;
import com.neutronio.astrax.io.binary.game.world.galaxy.SavedCelestialTarget;
import com.neutronio.astrax.util.Counter;
import com.neutronio.astrax.util.TechTree;
import com.neutronio.astrax.util.sequences.NumberGenerator;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@ForNameSpace(value="planet")
public class PlanetFactory
extends AbstractFactory
implements Generator<Planet, PlanetGenerationSettings>,
GenericFactory<Planet, PlanetCreationSettings>,
TargetFactory<CelestialTarget, CelestialSettings>,
Serializer<CelestialTarget, SavedCelestialTarget> {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private Counter<String> traitCounter = new Counter();
    private TreeGenerator treeGenerator = new TreeGenerator();
    protected PlanetGraphicsFactory planetGraphicsFactory;
    protected PlanetCreationSettingsRepository planetCreationSettingsRepository;
    protected PlanetTraitRepository traitRepository;
    protected ResourceRepository resourceRepository;

    public PlanetFactory() {
        this.planetGraphicsFactory = AstraXApp.astraX.getFactoryByClass(PlanetGraphicsFactory.class);
    }

    public PlanetFactory(DataContext dataContext) {
        super(dataContext);
        this.planetGraphicsFactory = this.dataContext.getFactory(PlanetGraphicsFactory.class);
        this.planetCreationSettingsRepository = this.dataContext.getRepository(PlanetCreationSettingsRepository.class);
        this.traitRepository = this.dataContext.getRepository(PlanetTraitRepository.class);
        this.resourceRepository = this.dataContext.getRepository(ResourceRepository.class);
    }

    @Override
    public SavedCelestialTarget serialize(CelestialTarget toSave) {
        return null;
    }

    @Override
    public CelestialTarget deserialize(SavedCelestialTarget savable) {
        PlanetCreationSettings planetCreationSettings = null;
        planetCreationSettings = savable.planetCreationSettings.isGeneratedPlanet() ? new PlanetCreationSettings(savable.planetCreationSettings) : (PlanetCreationSettings)this.planetCreationSettingsRepository.find(savable.planetCreationSettings.customPlanetID);
        Planet planet = this.create(planetCreationSettings);
        EntityID entityID = null;
        entityID = planetCreationSettings.entityId != null ? new EntityID(planetCreationSettings.entityId) : this.entityIDFactory.createID(this.numberGenerator);
        PlanetGraphics planetGraphics = this.planetGraphicsFactory.create(planetCreationSettings);
        return new CelestialTarget(entityID, null, planet, planetGraphics);
    }

    @Override
    public CelestialTarget createTarget(CelestialSettings settings) {
        this.logger.fine("Creating target with current seed " + this.numberGenerator.getSeed());
        PlanetCreationSettings planetCreationSettings = null;
        this.planetGraphicsFactory.setSeed(this.numberGenerator.getSeed());
        if (settings.planetCreationSettings != null) {
            planetCreationSettings = settings.planetCreationSettings;
        } else if (settings.planetGenerationSettings != null) {
            planetCreationSettings = this.convert(settings.planetGenerationSettings);
        } else {
            throw new AstraXException(AstraXException.ErrorCode.E0004, "Celestial Settings needs at least one valid field to be set");
        }
        Planet planet = this.create(planetCreationSettings);
        planet.setCustomPlanetSettings(planetCreationSettings);
        PlanetGraphics planetGraphics = this.planetGraphicsFactory.create(planetCreationSettings);
        EntityID entityID = null;
        entityID = planetCreationSettings.entityId != null ? new EntityID(planetCreationSettings.entityId) : this.entityIDFactory.createID(this.numberGenerator);
        this.logger.log(Level.FINEST, "...Planet Climate: " + planet.getClimate());
        this.logger.log(Level.FINEST, "...Planet Topography: " + planet.getTopography());
        return new CelestialTarget(entityID, new NameSpace("planet", "", ""), planet, planetGraphics);
    }

    @Override
    public Planet generate(PlanetGenerationSettings planetGenerationSettings) {
        this.logger.log(Level.INFO, "Creating Planet from generation settings {0}", planetGenerationSettings.id);
        Planet planet = new Planet();
        planet.setName(this.generateName());
        this.generateTraits(planet, planetGenerationSettings.traits);
        return planet;
    }

    @Override
    @Deprecated
    public CelestialTarget createShuffledTarget(NameSpace nameSpace) {
        return null;
    }

    @Override
    public Planet create(PlanetCreationSettings planetCreationSettings) {
        this.logger.log(Level.INFO, "Creating Custom Planet: {0}:{1}", new Object[]{planetCreationSettings.getId(), planetCreationSettings.getName()});
        Planet planet = new Planet();
        planet.setCustomPlanetSettings(planetCreationSettings);
        planet.setName(planetCreationSettings.getName());
        planet.setPlanetScale(planetCreationSettings.getScale().floatValue());
        this.createCustomTraits(planet, planetCreationSettings);
        this.logger.log(Level.FINEST, "...Planet Climate: " + planet.getClimate());
        this.logger.log(Level.FINEST, "...Planet Topography: " + planet.getTopography());
        if (planetCreationSettings.getId() != null) {
            this.dataPack.countSpecimen(planetCreationSettings.getId());
        } else {
            this.dataPack.countSpecimen(planetCreationSettings.planetType.name());
        }
        return planet;
    }

    public EntityIDFactory getEntityIDFactory() {
        return this.entityIDFactory;
    }

    public void setEntityIDFactory(EntityIDFactory entityIDFactory) {
        this.entityIDFactory = entityIDFactory;
    }

    public NumberGenerator getNumberGenerator() {
        return this.numberGenerator;
    }

    public void setNumberGenerator(NumberGenerator numberGenerator) {
        this.numberGenerator = numberGenerator;
    }

    public PlanetCreationSettings convert(PlanetGenerationSettings generationSettings) {
        PlanetCreationSettings creationSettings = new PlanetCreationSettings();
        creationSettings.id = null;
        creationSettings.name = this.generateName();
        creationSettings.icon = generationSettings.icon;
        creationSettings.rarity = generationSettings.rarity;
        creationSettings.discoveryPoints = generationSettings.discoveryPoints;
        creationSettings.planetClass = generationSettings.planetClass;
        creationSettings.planetType = generationSettings.planetType;
        creationSettings.scale = Float.valueOf(this.numberGenerator.getRandomFloat(generationSettings.maxScale, generationSettings.minScale));
        creationSettings.axisTilt = Float.valueOf(this.numberGenerator.getRandomFloat(generationSettings.maxAxisTilt, generationSettings.minAxisTilt));
        creationSettings.useShadowMask = generationSettings.useShadowMask;
        creationSettings.traits = this.treeGenerator.generate(this.numberGenerator, generationSettings.traits);
        creationSettings.tags = Collections.unmodifiableList(generationSettings.tags);
        for (String traitID : creationSettings.traits) {
            PlanetTrait trait = (PlanetTrait)this.traitRepository.find(traitID);
            if (trait == null) {
                throw new AstraXException(AstraXException.ErrorCode.E3000, "Trait of ID: " + traitID);
            }
            List<TextureGenerationSetting> textureSettings = trait.getTextureSettings();
            for (TextureGenerationSetting textureSetting : textureSettings) {
                creationSettings.textureSettings.add(this.planetGraphicsFactory.generate(textureSetting));
            }
            for (OrbitRingSettings orbitRingSettings : trait.getOrbitRingSettings()) {
                creationSettings.orbitRingSettings.add(orbitRingSettings);
            }
        }
        return creationSettings;
    }

    private void generateTraits(Planet planet, TechTree tree) {
        List<String> generatedTraits = this.treeGenerator.generate(this.numberGenerator, tree);
        this.createTraits(planet, generatedTraits);
    }

    private void createCustomTraits(Planet planet, PlanetCreationSettings planetCreationSettings) {
        this.createTraits(planet, planetCreationSettings.getTraits());
    }

    private void createTraits(Planet planet, List<String> traits) {
        for (String traitID : traits) {
            PlanetTrait trait = (PlanetTrait)this.traitRepository.find(traitID);
            if (trait == null) {
                throw new AstraXException(AstraXException.ErrorCode.E3000, "Trait of ID: " + traitID);
            }
            this.logger.log(Level.FINEST, "Added trait: {0}", trait.id);
            if (trait.resourceDepositSettings != null) {
                this.verifyResources(trait.resourceDepositSettings);
                ResourceDeposit resourceDeposit = this.createResourceDeposit(trait.resourceDepositSettings);
                resourceDeposit.setTraitID(traitID);
                planet.setResources(resourceDeposit);
                this.logger.log(Level.FINEST, "Added resource deposit of size {0}", planet.getResources().getDepositSize());
            }
            if (trait.getTopography() != null) {
                planet.getTopography().combine(trait.getTopography());
            }
            if (trait.getClimate() != null) {
                planet.getClimate().combine(trait.getClimate());
            }
            this.traitCounter.addOne(trait.id);
        }
    }

    public void verifyResources(ResourceDepositSettings resourceDepositSettings) {
        for (int i2 = 0; i2 < resourceDepositSettings.getResources().size(); ++i2) {
            String resourceID = resourceDepositSettings.getResources().getItemAt(i2);
            if (this.resourceRepository.contains(resourceID)) continue;
            throw new AstraXException(AstraXException.ErrorCode.E3000, "Resource '" + resourceID + "'");
        }
    }

    @Deprecated
    public ResourceDeposit createResourceDeposit(ResourceDepositSettings resourceDepositSettings) {
        ResourceDeposit resourceDeposit = new ResourceDeposit();
        resourceDeposit.setResourceSettings(resourceDepositSettings);
        int maxDepositSize = this.numberGenerator.getRandomInteger(resourceDepositSettings.getMaxDepositSize(), resourceDepositSettings.getMinDepositSize());
        resourceDeposit.setDepositSize(maxDepositSize);
        resourceDeposit.setMaxDepositSize(maxDepositSize);
        resourceDeposit.setMiningDifficulty(this.numberGenerator.getRandomFloat(resourceDepositSettings.getMaxMiningDifficulty(), resourceDepositSettings.getMinMiningDifficulty()));
        return resourceDeposit;
    }

    public String getGeneratedTraitsInfo() {
        return this.traitCounter.toString();
    }

    public void resetTraitsCounter() {
        this.traitCounter.reset();
    }

    public static class CelestialSettings {
        public PlanetGenerationSettings planetGenerationSettings;
        public PlanetCreationSettings planetCreationSettings;

        public CelestialSettings() {
        }

        public CelestialSettings(PlanetGenerationSettings planetGenerationSettings, PlanetCreationSettings planetCreationSettings) {
            this.planetGenerationSettings = planetGenerationSettings;
            this.planetCreationSettings = planetCreationSettings;
        }
    }
}

