/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.generator.GenericFactory;
import com.neutronio.astrax.gfx.bg.StarSystemBackgroundGraphics;
import com.neutronio.astrax.gfx.bg.StarSystemBackgroundSettings;
import com.neutronio.astrax.util.ColorBlend;

public class StarSystemBackgroundFactory
extends AbstractFactory
implements GenericFactory<StarSystemBackgroundGraphics, StarSystemBackgroundSettings> {
    private float maximumTextureDensity = 100.0f;

    public StarSystemBackgroundFactory() {
    }

    public StarSystemBackgroundFactory(DataContext dataContext) {
        super(dataContext);
    }

    @Override
    public StarSystemBackgroundGraphics create(StarSystemBackgroundSettings backgroundSettings) {
        return this.createBackground(10000.0f, backgroundSettings);
    }

    public StarSystemBackgroundGraphics createBackground(float extent, StarSystemBackgroundSettings settings) {
        if (settings == null) {
            throw new AstraXException(AstraXException.ErrorCode.E0001, "Settings object is null!");
        }
        StarSystemBackgroundGraphics backgroundGraphics = new StarSystemBackgroundGraphics(extent);
        Color mainColor = this.dataPack.getNumberGenerator().getRandomEntry(settings.colors);
        for (StarSystemBackgroundSettings.BackgroundScatterSetting backgroundScatterSetting : settings.scatterSettings) {
            this.addScatterTextures(backgroundGraphics, mainColor, backgroundScatterSetting);
        }
        return backgroundGraphics;
    }

    private void addScatterTextures(StarSystemBackgroundGraphics graphics, Color globalColor, StarSystemBackgroundSettings.BackgroundScatterSetting scatterSetting) {
        int textureCount = (int)Math.ceil(scatterSetting.density * this.maximumTextureDensity);
        for (int i2 = 0; i2 < textureCount; ++i2) {
            TextureAtlas.AtlasRegion backgroundRegion = this.dataPack.getRandomTexture(scatterSetting.textureRegions);
            Color color = this.dataPack.getNumberGenerator().getRandomEntry(scatterSetting.colors);
            Color mixedColor = ColorBlend.INTERPOLATE.mix(color, globalColor, 0.7f);
            Image backgroundImage = new Image(backgroundRegion);
            backgroundImage.setColor(mixedColor.r, mixedColor.g, mixedColor.b, this.dataPack.getNumberGenerator().getRandomFloat(scatterSetting.maxTransparency, scatterSetting.minTransparency));
            backgroundImage.setRotation(this.dataPack.getNumberGenerator().getRandomFloat(scatterSetting.maxRotation, scatterSetting.minRotation));
            backgroundImage.setScale(this.dataPack.getNumberGenerator().getRandomFloat(scatterSetting.maxScale, scatterSetting.minScale));
            backgroundImage.setPosition(this.dataPack.getNumberGenerator().getRandomFloat(2560.0f, -2560.0f), this.dataPack.getNumberGenerator().getRandomFloat(2560.0f, -2560.0f));
            backgroundImage.setAlign(1);
            graphics.addActor(backgroundImage);
        }
    }
}

