/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.datapack.DataPack;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.EntityIDFactory;
import com.neutronio.astrax.app.datapack.game.world.AstraXTargetFactory;
import com.neutronio.astrax.app.datapack.game.world.BeltTarget;
import com.neutronio.astrax.app.datapack.game.world.GalaxyMapContext;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyDistributionSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystemSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.EllipsoidOrbit;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.Orbit;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.OrbitSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.OrbitalBeltFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.StarSystemBackgroundFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.StaticOrbit;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.generator.Generator;
import com.neutronio.astrax.app.repository.Tagged;
import com.neutronio.astrax.gfx.StarSystemGraphics;
import com.neutronio.astrax.gfx.bg.StarSystemBackgroundGraphics;
import com.neutronio.astrax.gfx.bg.StarSystemBackgroundSettings;
import com.neutronio.astrax.util.Counter;
import com.neutronio.astrax.util.TargetSettings;
import com.neutronio.astrax.util.Tree;
import com.neutronio.astrax.util.sequences.NumberGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StarSystemFactory
extends AbstractFactory
implements Generator<StarSystem, StarSystemSettings> {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    public static float maxExtent = 35000.0f;
    private GalaxyDistributionSettings galaxyDistributionSettings;
    private GalaxyDistributionSettings regionDistributionSettings;
    private GalaxyMapContext galaxyMapContext;
    private float starSpacing = 100.0f;
    private float starStartSpacing = 500.0f;
    private AstraXTargetFactory targetFactory;
    private Counter<String> counter = new Counter();
    private Counter<String> globalCounter = new Counter();
    private NumberGenerator starSystemNumberGenerator;

    @Deprecated
    public StarSystemFactory() {
        this.targetFactory = AstraXApp.astraX.getFactoryByClass(AstraXTargetFactory.class);
    }

    public StarSystemFactory(DataContext dataContext) {
        super(dataContext);
        this.targetFactory = AstraXApp.astraX.getFactoryByClass(AstraXTargetFactory.class);
    }

    @Override
    public void setSeed(long seed) {
        super.setSeed(seed);
        this.targetFactory.setSeed(seed);
    }

    public void setGalaxyMapContext(GalaxyMapContext galaxyMapContext) {
        this.galaxyMapContext = galaxyMapContext;
    }

    @Override
    public void setDataPack(DataPack dataPack) {
        super.setDataPack(dataPack);
    }

    public void setGalaxyDistributionSettings(GalaxyDistributionSettings galaxyDistributionSettings) {
        this.galaxyDistributionSettings = galaxyDistributionSettings;
    }

    public void setRegionDistributionSettings(GalaxyDistributionSettings regionDistributionSettings) {
        this.regionDistributionSettings = regionDistributionSettings;
    }

    @Override
    public StarSystem generate(StarSystemSettings starSystemSettings) {
        return null;
    }

    public EntityIDFactory getEntityIDFactory() {
        return this.entityIDFactory;
    }

    public float getMaxExtent() {
        return maxExtent;
    }

    public void setMaxExtent(float maxExtent) {
        StarSystemFactory.maxExtent = maxExtent;
    }

    private StarSystem createBasicStarSystem(String id, Targetable star) {
        StarSystem starSystem = new StarSystem(star);
        StarSystemGraphics starSystemGraphics = new StarSystemGraphics();
        starSystemGraphics.addToGraphics((Actor)star.getGraphics());
        starSystemGraphics.setSize(maxExtent, maxExtent);
        starSystemGraphics.setOrigin(maxExtent / 2.0f, maxExtent / 2.0f);
        starSystem.setGraphics(starSystemGraphics);
        return starSystem;
    }

    private void createBackgroundGraphics(StarSystem starSystem, StarSystemBackgroundSettings backgroundSettings) {
        StarSystemBackgroundFactory backgroundFactory = AstraXApp.astraX.getFactoryByClass(StarSystemBackgroundFactory.class);
        StarSystemBackgroundGraphics backgroundGraphics = backgroundFactory.createBackground(maxExtent, backgroundSettings);
        starSystem.setBackgroundGraphics(backgroundGraphics);
        starSystem.setBackgroundGraphicsSettings(backgroundSettings);
    }

    private Orbit generateOrbitFromSettings(OrbitSettings orbitSettings, float orbitRadius) {
        switch (orbitSettings.orbitType) {
            case ELLIPSOID: {
                this.logger.log(Level.FINE, "Creating an Ellipsoid Orbit");
                EllipsoidOrbit ellipsoidOrbit = new EllipsoidOrbit();
                ellipsoidOrbit.setOffsetX(orbitSettings.offsetX);
                ellipsoidOrbit.setOffsetY(orbitSettings.offsetY);
                ellipsoidOrbit.setWidth(orbitRadius * orbitSettings.circleFactor);
                ellipsoidOrbit.setHeight(orbitRadius);
                ellipsoidOrbit.setVelocity(this.numberGenerator.getRandomFloat(orbitSettings.maxVelocity, orbitSettings.minVelocity));
                ellipsoidOrbit.setTimeOffset(this.numberGenerator.getRandomFloat(1.0f, 0.0f));
                return ellipsoidOrbit;
            }
            case STATIC: {
                this.logger.log(Level.FINE, "Creating a Static Orbit");
                StaticOrbit staticOrbit = new StaticOrbit();
                staticOrbit.setX(orbitSettings.staticPositionX);
                staticOrbit.setY(orbitSettings.staticPositionY);
                return staticOrbit;
            }
        }
        this.logger.log(Level.WARNING, "Orbit Type {0} not supported", (Object)orbitSettings.orbitType);
        return null;
    }

    public StarSystem generateStarSystem(StarSystemSettings settings, StarSystemBackgroundSettings backgroundSettings) {
        this.logger.log(Level.INFO, "Generating System '" + settings.getName() + "' with seed " + this.numberGenerator.getSeed());
        Tree<TargetSettings> systemMembers = settings.getSystemMembers();
        if (systemMembers.getRoot().getObject() == null) {
            StarSystem starSystem = new StarSystem(null);
            StarSystemGraphics graphics = new StarSystemGraphics();
            starSystem.setGraphics(graphics);
            return starSystem;
        }
        TargetSettings rootStar = systemMembers.getRoot().getObject();
        AstraXTargetFactory targetFactory = AstraXApp.astraX.getFactoryByClass(AstraXTargetFactory.class);
        Targetable star = targetFactory.generate(rootStar);
        star.setPositionController(new StaticOrbit());
        this.recordForDiagnostics(star);
        EntityID id = this.entityIDFactory.createID(this.numberGenerator);
        StarSystem starSystem = this.createBasicStarSystem(id.get(), star);
        starSystem.setSettings(settings);
        Tree<Targetable> targetableTree = this.buildSystemTree(starSystem, systemMembers);
        starSystem.setSystemStructure(targetableTree);
        this.registerByTree(starSystem, targetableTree);
        this.buildOrbits(starSystem, targetableTree);
        this.createBackgroundGraphics(starSystem, backgroundSettings);
        this.logger.log(Level.INFO, "Planets Generated this time:\n" + this.counter.toString());
        this.logger.log(Level.INFO, "Total Statistics:\n" + this.toString());
        this.counter.reset();
        return starSystem;
    }

    private Tree<Targetable> buildSystemTree(StarSystem starSystem, Tree<TargetSettings> settingsTree) {
        this.logger.info("Building System Structure Tree...");
        Tree<Targetable> systemTree = new Tree<Targetable>();
        systemTree.getRoot().setObject(starSystem.getSun());
        for (int i2 = 0; i2 < settingsTree.childrenCount(); ++i2) {
            Tree.Node<TargetSettings> childSettingsNode = settingsTree.getChildAt(i2);
            float distributionModifier = 1.0f;
            Object settingsObject = this.targetFactory.resolveSettingsObject(childSettingsNode.getObject());
            if (settingsObject instanceof Tagged) {
                Tagged tagged = (Tagged)settingsObject;
                if (tagged.getTags() != null && this.galaxyDistributionSettings != null) {
                    for (String tag : tagged.getTags()) {
                        distributionModifier += this.galaxyDistributionSettings.getValueForTag(tag) - 1.0f;
                        if (this.regionDistributionSettings == null) continue;
                        distributionModifier += this.regionDistributionSettings.getValueForTag(tag) - 1.0f;
                    }
                } else {
                    this.logger.warning("Object has no tags, or galaxy distribution is null!");
                }
            }
            Targetable child = this.targetFactory.generate(childSettingsNode.getObject());
            this.recordForDiagnostics(child);
            this.logger.finest("Distribution modifier for '" + child.getModel() + "': " + distributionModifier);
            Tree.Node<Targetable> childTargetableNode = new Tree.Node<Targetable>(child);
            systemTree.add(childTargetableNode);
            this.convertNodes(childSettingsNode, childTargetableNode);
        }
        return systemTree;
    }

    private void convertNodes(Tree.Node<TargetSettings> settingsNode, Tree.Node<Targetable> targetNode) {
        for (int i2 = 0; i2 < settingsNode.size(); ++i2) {
            Tree.Node<TargetSettings> childNode = settingsNode.getChild(i2);
            float distributionModifier = 1.0f;
            Object settingsObject = this.targetFactory.resolveSettingsObject(settingsNode.getChild(i2).getObject());
            if (settingsObject instanceof Tagged) {
                Tagged tagged = (Tagged)settingsObject;
                if (tagged.getTags() != null && this.galaxyDistributionSettings != null) {
                    for (String tag : tagged.getTags()) {
                        distributionModifier += this.galaxyDistributionSettings.getValueForTag(tag) - 1.0f;
                        if (this.regionDistributionSettings == null) continue;
                        distributionModifier += this.regionDistributionSettings.getValueForTag(tag) - 1.0f;
                    }
                } else {
                    this.logger.warning("Object has no tags, or galaxy distribution is null!");
                }
            }
            if (!this.numberGenerator.isTrue(settingsNode.getChild((int)i2).getObject().probability * distributionModifier)) continue;
            Targetable child = this.targetFactory.generate(childNode.getObject());
            this.recordForDiagnostics(child);
            this.logger.finest("Distribution modifier for '" + child.getModel() + "': " + distributionModifier);
            Tree.Node<Targetable> childTargetNode = new Tree.Node<Targetable>(child);
            targetNode.addChild(childTargetNode);
            this.convertNodes(childNode, targetNode);
        }
    }

    private void registerByTree(StarSystem starSystem, Tree<Targetable> targetableTree) {
        this.logger.info("Register targets...");
        starSystem.registerTarget(targetableTree.getRoot().getObject());
        this.registerRecursive(starSystem, targetableTree.getRoot());
    }

    private void registerRecursive(StarSystem starSystem, Tree.Node<Targetable> targetNode) {
        for (int i2 = 0; i2 < targetNode.size(); ++i2) {
            starSystem.registerTarget(targetNode.getChild(i2).getObject());
            this.registerRecursive(starSystem, targetNode.getChild(i2));
        }
    }

    private void buildOrbits(StarSystem starSystem, Tree<Targetable> targetableTree) {
        this.logger.info("Building Orbits...");
        Targetable rootTarget = targetableTree.getRoot().getObject();
        List<Vector2> orbitalSections = this.getOrbitalSections(((Actor)rootTarget.getGraphics()).getWidth(), ((Actor)rootTarget.getGraphics()).getHeight(), targetableTree.getRoot().size(), maxExtent);
        Tree.Node<Targetable> rootNode = targetableTree.getRoot();
        for (int i2 = 0; i2 < rootNode.size(); ++i2) {
            Group group = (Group)rootNode.getObject().getGraphics();
            group.addActor((Actor)rootNode.getChild(i2).getObject().getGraphics());
            this.buildOrbitsFromNode(starSystem, rootNode.getChild(i2), (int)orbitalSections.get((int)i2).x, (int)orbitalSections.get((int)i2).y);
        }
    }

    private void buildOrbitsFromNode(StarSystem starSystem, Tree.Node<Targetable> targetNode, int orbitMinRadius, int orbitMaxRadius) {
        TargetSettings settings = targetNode.getObject().getDiscoverableSettings();
        OrbitSettings orbitSettings = settings.orbitSettings;
        Targetable targetable = targetNode.getObject();
        if (orbitSettings != null) {
            float radius = this.numberGenerator.getRandomFloat(orbitMaxRadius, orbitMinRadius);
            Orbit orbit = this.generateOrbitFromSettings(orbitSettings, radius);
            targetable.setPositionController(orbit);
        }
        if (targetable instanceof BeltTarget) {
            OrbitalBeltFactory orbitalBeltFactory = AstraXApp.astraX.getFactoryByClass(OrbitalBeltFactory.class);
            List<Targetable> beltTargets = orbitalBeltFactory.populateBelt((BeltTarget)targetable, settings.orbitalBeltSettings, orbitMinRadius, orbitMaxRadius);
            for (Targetable beltTarget : beltTargets) {
                Group group = (Group)targetNode.getObject().getGraphics();
                group.addActor((Actor)beltTarget.getGraphics());
                starSystem.registerTarget(beltTarget);
                this.recordForDiagnostics(beltTarget);
            }
        }
        if (targetNode.size() == 0) {
            return;
        }
        List<Vector2> orbitalSections = this.getOrbitalSections(((Actor)targetNode.getObject().getGraphics()).getWidth(), ((Actor)targetNode.getObject().getGraphics()).getHeight(), targetNode.size(), (float)orbitMaxRadius / 5.0f);
        for (int i2 = 0; i2 < targetNode.size(); ++i2) {
            Group group = (Group)targetNode.getObject().getGraphics();
            group.addActor((Actor)targetNode.getChild(i2).getObject().getGraphics());
            this.buildOrbitsFromNode(starSystem, targetNode.getChild(i2), (int)orbitalSections.get((int)i2).x, (int)orbitalSections.get((int)i2).y);
        }
    }

    public List<Vector2> getOrbitalSections(float width, float height, int count, float maxExtent) {
        float startMin;
        ArrayList<Vector2> sections = new ArrayList<Vector2>();
        float orbitWidth = maxExtent / (float)count;
        float min = startMin = Math.max(width, height) + this.starStartSpacing;
        float max = startMin + orbitWidth;
        for (int i2 = 0; i2 < count; ++i2) {
            sections.add(new Vector2(min, max));
            min = min + orbitWidth + this.starSpacing;
            max = max + orbitWidth + this.starSpacing;
        }
        return sections;
    }

    private void recordForDiagnostics(Targetable targetable) {
        if (targetable.getSubType() != null) {
            this.counter.addOne(targetable.getSubType());
            this.globalCounter.addOne(targetable.getSubType());
        }
    }

    public String toString() {
        return "StarSystemFactory {\n== globalCounter ==" + this.globalCounter + '}';
    }
}

