/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.generator;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.Factory;
import com.neutronio.astrax.app.datapack.DataPack;
import com.neutronio.astrax.app.datapack.EntityIDFactory;
import com.neutronio.astrax.app.datapack.FactorySettings;
import com.neutronio.astrax.app.datapack.NameFactory;
import com.neutronio.astrax.app.generator.ProbabilitySetGenerator;
import com.neutronio.astrax.util.sequences.NumberGenerator;
import com.neutronio.astrax.util.sequences.StringGenerator;
import java.util.List;
import java.util.logging.Logger;

public abstract class AbstractFactory
implements Factory {
    protected Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    protected long seed;
    protected DataContext dataContext;
    protected FactorySettings.FactorySetting settings;
    protected String namespace;
    protected DataPack dataPack;
    protected EntityIDFactory entityIDFactory;
    protected NumberGenerator numberGenerator;
    protected StringGenerator stringGenerator;
    protected ProbabilitySetGenerator setGenerator;

    @Deprecated
    public AbstractFactory() {
        this.numberGenerator = new NumberGenerator(this.seed);
        this.stringGenerator = new StringGenerator();
        this.entityIDFactory = new EntityIDFactory(this.stringGenerator);
        this.setGenerator = new ProbabilitySetGenerator();
    }

    public AbstractFactory(DataContext dataContext) {
        this.dataContext = dataContext;
        this.numberGenerator = new NumberGenerator(this.seed);
        this.stringGenerator = new StringGenerator();
        this.entityIDFactory = new EntityIDFactory(this.stringGenerator);
        this.setGenerator = new ProbabilitySetGenerator();
    }

    public void setSeed(long seed) {
        this.seed = seed;
        this.numberGenerator.setSeed(seed);
    }

    public void setDataPack(DataPack dataPack) {
        this.dataPack = dataPack;
    }

    public String generateName() {
        return this.generateName(this.settings.nameSets);
    }

    public String generateName(List<String> nameGenPatterns) {
        NameFactory nameFactory = AstraXApp.astraX.getFactoryByClass(NameFactory.class);
        String randomNameSetPattern = this.numberGenerator.getRandomEntry(nameGenPatterns);
        return nameFactory.createName(this.numberGenerator, randomNameSetPattern);
    }

    public FactorySettings.FactorySetting getSettings() {
        return this.settings;
    }

    public void setSettings(FactorySettings.FactorySetting settings) {
        this.settings = settings;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNameSpace(String nameSpace) {
        this.namespace = nameSpace;
    }
}

