/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.generator;

import com.neutronio.astrax.AstraXException;
import java.util.regex.Pattern;

public class NameSpace {
    private String datapack;
    private String object;
    private String archetype;
    private String subtype;

    public NameSpace(String object, String archetype, String subtype) {
        this.object = object;
        this.archetype = archetype;
        this.subtype = subtype;
    }

    public NameSpace(String fullNamespace) {
        String[] split = fullNamespace.split(Pattern.quote(":"));
        if (split.length >= 1) {
            this.object = split[0];
        }
        if (split.length >= 2) {
            this.archetype = split[1];
        }
        if (split.length >= 3) {
            this.subtype = split[2];
        } else if (split.length > 3 || split.length <= 0) {
            throw new AstraXException(AstraXException.ErrorCode.E0004, "Could not parse namespace: " + fullNamespace);
        }
    }

    public String getObject() {
        return this.object;
    }

    public String getArchetype() {
        return this.archetype;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String toString() {
        return this.object + ":" + this.archetype + ":" + this.subtype;
    }
}

