/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.generator;

import com.neutronio.astrax.util.Tech;
import com.neutronio.astrax.util.TechTree;
import com.neutronio.astrax.util.collections.MultiLinkedList;
import com.neutronio.astrax.util.sequences.NumberGenerator;
import com.neutronio.astrax.util.sequences.SequenceGenerator;
import java.util.ArrayList;
import java.util.List;

public class TreeGenerator
implements SequenceGenerator {
    public List<String> generate(NumberGenerator numberGenerator, TechTree<String> tree) {
        ArrayList<String> store = new ArrayList<String>();
        boolean layerHasChildren = true;
        int currentDepth = 0;
        do {
            List childrenOfDepth;
            layerHasChildren = (childrenOfDepth = tree.getChildrenOfDepth(currentDepth)).size() > 0;
            int childrenCreated = 0;
            for (MultiLinkedList.Node techNode : childrenOfDepth) {
                int randomChance = numberGenerator.getRandomInteger(100, 0);
                boolean parents = true;
                int maxChildren = Integer.MAX_VALUE;
                for (int p = 0; p < techNode.getParentCount(); ++p) {
                    Tech parentTech = (Tech)techNode.getParentAt(p).getValue();
                    parents = parents && store.contains(parentTech.getUserObject());
                    maxChildren = Math.min(maxChildren, parentTech.getMaxChildren());
                }
                if (!parents || !((float)randomChance <= ((Tech)techNode.getValue()).getProbability()) || childrenCreated >= maxChildren) continue;
                store.add((String)((Tech)techNode.getValue()).getUserObject());
                ++childrenCreated;
            }
            ++currentDepth;
        } while (layerHasChildren);
        return store;
    }
}

