/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.repository;

import com.neutronio.astrax.app.repository.GenericRepository;
import com.neutronio.astrax.app.repository.RepositoryEntity;
import com.neutronio.astrax.io.json.JSONConverter;
import com.neutronio.astrax.io.json.game.DataManager;
import com.neutronio.astrax.io.json.game.RepositoryJSONConverter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.json.JSONObject;

public class GenericJSONRepositoryConverter<R extends GenericRepository, I extends RepositoryEntity>
extends RepositoryJSONConverter<R, String> {
    JSONConverter<I, Map> instanceConverter;
    Class<I> instanceClass;
    JSONConverter<R, Map> repositoryConverter;
    Class<R> repositoryClass;

    public GenericJSONRepositoryConverter(DataManager loader) {
        super(loader);
    }

    public void setInstanceConverter(JSONConverter<I, Map> instanceConverter) {
        this.instanceConverter = instanceConverter;
    }

    public void setRepositoryClass(Class<R> repositoryClass) {
        this.repositoryClass = repositoryClass;
    }

    @Override
    public R convert(String input) {
        GenericRepository repository = null;
        try {
            Constructor<R> constructor = this.repositoryClass.getConstructor(new Class[0]);
            repository = (GenericRepository)constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.convertAndStore((R)repository, input);
        return (R)repository;
    }

    @Override
    public void convertAndStore(R repositoryStore, String input) {
        Map<String, Object> instanceMap = new JSONObject(input).toMap();
        int loaded = 0;
        for (String key : instanceMap.keySet()) {
            Map instance = (Map)instanceMap.get(key);
            RepositoryEntity settings = (RepositoryEntity)this.instanceConverter.convert(instance);
            if (settings != null) {
                settings.id = key;
                ((GenericRepository)repositoryStore).add(key, (RepositoryEntity)settings);
                ++loaded;
                continue;
            }
            this.logger.log(Level.WARNING, "Could not load: " + key);
        }
        this.logger.log(Level.INFO, "Loaded {0} instances into {1}", new Object[]{loaded, this.repositoryClass.getSimpleName()});
    }

    @Override
    public JSONObject convertToJSON(R object) {
        JSONObject repositoryJSON = new JSONObject();
        List objectInstances = ((GenericRepository)object).all();
        for (RepositoryEntity instance : objectInstances) {
            JSONObject jsonObject = this.instanceConverter.convertToJSON(instance);
            repositoryJSON.put(instance.id, jsonObject);
        }
        return repositoryJSON;
    }
}

