/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.repository;

import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.repository.DataRepository;
import com.neutronio.astrax.util.UsageChecker;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenericRepository<DATA>
implements DataRepository<String, DATA> {
    protected transient Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    protected Map<String, DATA> storage = new LinkedHashMap<String, DATA>();
    protected UsageChecker usageChecker = new UsageChecker();

    @Override
    public List<DATA> all() {
        ArrayList<DATA> data = new ArrayList<DATA>();
        data.addAll(this.storage.values());
        return data;
    }

    @Override
    public DATA find(String id) {
        this.usageChecker.record(id);
        return this.storage.get(id);
    }

    @Override
    public void add(String id, DATA data) {
        if (data == null) {
            throw new AstraXException(AstraXException.ErrorCode.E0004, "Null cannot be registered to repository!");
        }
        if (!this.storage.containsKey(id)) {
            this.usageChecker.addId(id);
            this.storage.put(id, data);
        } else {
            this.logger.log(Level.WARNING, "Could not add data: data with name " + id + " already exists!");
        }
    }

    @Override
    public void remove(String id) {
        if (this.contains(id)) {
            this.storage.remove(id);
        } else {
            this.logger.log(Level.WARNING, "Could not remove data: data with id " + id + " does not exist!");
        }
    }

    @Override
    public boolean contains(String id) {
        return this.storage.containsKey(id);
    }

    @Override
    public int count() {
        return this.storage.size();
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    @Override
    public List<String> getUnusedObjectIDs() {
        return this.usageChecker.getUnusedStrings();
    }

    @Override
    public float getUsage() {
        return (float)this.usageChecker.getUnusedStrings().size() / (float)this.usageChecker.getTotalStringCount();
    }
}

