/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.gfx.ScrollStage;
import java.util.logging.Logger;

public abstract class AbstractScreen
implements Screen {
    protected Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    protected final AstraXApp app;
    protected ScrollStage backgroundStage;
    protected Stage parallaxStage;
    protected Stage hudStage;
    protected Stage uiStage;
    protected boolean loaded = false;
    protected boolean hidden = true;
    protected boolean paused = false;
    protected boolean created = false;

    protected AbstractScreen(AstraXApp game) {
        this.app = game;
        this.backgroundStage = new ScrollStage();
        this.parallaxStage = new Stage();
        this.hudStage = new Stage();
        this.uiStage = new Stage();
    }

    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    public void renderOverride(float delta) {
        if (Gdx.input.isKeyJustPressed(139)) {
            if (this.hudStage != null) {
                this.hudStage.setDebugAll(!this.hudStage.isDebugAll());
            }
            if (this.uiStage != null) {
                this.uiStage.setDebugAll(!this.uiStage.isDebugAll());
            }
        }
    }

    public void updateOverride(float delta) {
    }

    public abstract void create();

    @Override
    public void resize(int width, int height) {
        this.hudStage.getViewport().update(width, height, true);
        this.uiStage.getViewport().update(width, height, true);
        this.backgroundStage.getStage().getViewport().update(width, height, true);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    protected void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    @Override
    public void show() {
        this.hidden = false;
    }

    @Override
    public void hide() {
        this.hidden = true;
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void resume() {
        this.paused = false;
    }

    public boolean isCreated() {
        return this.created;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public AstraXApp getApp() {
        return this.app;
    }

    public ScrollStage getBackgroundStage() {
        return this.backgroundStage;
    }

    public void setBackgroundStage(ScrollStage backgroundStage) {
        this.backgroundStage = backgroundStage;
    }

    public Stage getHudStage() {
        return this.hudStage;
    }

    public Stage getUiStage() {
        return this.uiStage;
    }

    public Stage getParallaxStage() {
        return this.parallaxStage;
    }

    public void setParallaxStage(Stage parallaxStage) {
        this.parallaxStage = parallaxStage;
    }

    public void onScreenFinishedLoading() {
    }
}

