/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.screen.AbstractScreen;
import com.neutronio.astrax.app.screen.MainMenuScreen;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.util.animation.Tweening;

public class CreditsScreen
extends AbstractScreen {
    private int index = 0;
    private int oldIndex = -1;
    private CreditsDisplay[] credits = new CreditsDisplay[]{new CreditsDisplay("Game Design", "Bettina Schuller", 3.0f), new CreditsDisplay("Programming", "Bettina Schuller", 3.0f), new CreditsDisplay("Art & Graphics", "Bettina Schuller", 3.0f), new CreditsDisplay("SFX Design", "Bettina Schuller", 3.0f), new CreditsDisplay("Music", "Bettina Schuller", 3.0f), new CreditsDisplay("Marketing &\nCorporate Design", "Bettina Schuller", 3.0f), new CreditsDisplay("Testing & QA", "Bettina Schuller\nFelix Wunderlich", 3.0f), new CreditsDisplay("Big thanks to\nearly Playtesters", "Yoi, Hedgeknight, Lelu, Jeffro, Jil, Chappu,\ntararntula, Rina, OtterMakeGames", 20.0f)};
    private AstraXTextButton backButton;
    private Table creditTable;
    private AstraXLabel headerLabel;
    private AstraXLabel titleLabel;
    private AstraXLabel nameLabel;

    public CreditsScreen(AstraXApp game) {
        super(game);
    }

    @Override
    public void create() {
        ComponentFactory factory = this.app.getAppFactoryByClass(ComponentFactory.class);
        this.headerLabel = new AstraXLabel(factory, "Credits", "header", null);
        this.headerLabel.setPosition((float)Gdx.graphics.getWidth() / 2.0f - this.headerLabel.getWidth() / 2.0f, Gdx.graphics.getHeight() + 100);
        this.titleLabel = new AstraXLabel(factory, "", "default", null);
        this.nameLabel = new AstraXLabel(factory, "", "default", null);
        this.creditTable = new Table();
        this.creditTable.add(this.titleLabel).minWidth(200.0f).padRight(50.0f);
        this.creditTable.add(this.nameLabel).center();
        this.creditTable.pack();
        this.backButton = new AstraXTextButton(factory, "primary");
        this.backButton.setText(factory.translate("form_back"));
        this.backButton.setCanCheck(false);
        this.backButton.setSize(this.backButton.getWidth() + 10.0f, 50.0f);
        this.backButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                CreditsScreen.this.app.setScreen(MainMenuScreen.class);
            }
        });
        this.hudStage.addActor(this.creditTable);
        this.hudStage.addActor(this.headerLabel);
        this.hudStage.addActor(this.backButton);
        this.created = true;
    }

    @Override
    public void render(float delta) {
        this.app.getMusicPlayer().update(delta);
        if (!this.paused) {
            this.hudStage.act();
            this.updateOverride(delta);
        }
        if (!this.hidden) {
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            Gdx.gl.glClear(16384);
            this.hudStage.draw();
            this.renderOverride(delta);
        }
    }

    public CustomAction getCreditUpdateAction() {
        return CustomAction.get(new Runnable(){

            @Override
            public void run() {
                CreditsScreen.this.titleLabel.setText(((CreditsScreen)CreditsScreen.this).credits[((CreditsScreen)CreditsScreen.this).index].title);
                CreditsScreen.this.nameLabel.setText(((CreditsScreen)CreditsScreen.this).credits[((CreditsScreen)CreditsScreen.this).index].name);
            }
        });
    }

    public CustomAction getForwardCreditsAction() {
        return CustomAction.get(new Runnable(){

            @Override
            public void run() {
                CreditsScreen.this.oldIndex = CreditsScreen.this.index;
                CreditsScreen.this.index++;
            }
        });
    }

    @Override
    public void show() {
        super.show();
        this.headerLabel.addAction(Tweening.getSlideFadeIn(0.4f, (float)Gdx.graphics.getWidth() / 2.0f - this.headerLabel.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f + 100.0f));
    }

    @Override
    public void renderOverride(float delta) {
        super.renderOverride(delta);
        if (this.oldIndex != this.index && this.index < this.credits.length && !this.creditTable.hasActions()) {
            this.creditTable.addAction(Actions.sequence(this.getCreditUpdateAction(), Tweening.getCenteredFadeIn(), Actions.delay(this.credits[this.index].displayTime), Tweening.getCenteredFadeOut(), Actions.delay(0.8f), this.getForwardCreditsAction()));
        }
    }

    @Override
    public void hide() {
        super.hide();
        this.index = 0;
        this.headerLabel.setPosition((float)Gdx.graphics.getWidth() / 2.0f - this.headerLabel.getWidth() / 2.0f, Gdx.graphics.getHeight() + 100);
    }

    @Override
    public void dispose() {
    }

    private class CreditsDisplay {
        String title;
        String name;
        float displayTime;

        public CreditsDisplay(String title, String name, float displayTime) {
            this.title = title;
            this.name = name;
            this.displayTime = displayTime;
        }
    }
}

