/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.screen.AbstractScreen;
import com.neutronio.astrax.app.screen.MainMenuScreen;
import com.neutronio.astrax.app.screen.ScreenFactory;
import com.neutronio.astrax.app.screen.SpaceScreen;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.ProgressBar;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.util.animation.Tweening;
import java.util.List;

public class LoadScreen
extends AbstractScreen {
    private ComponentFactory componentFactory;
    private float interval = 0.2f;
    private float timer;
    private int actionCount;
    private AstraXLabel label;
    private AstraXTextButton backToMenu;
    private ProgressBar progressBar;
    private List<ScreenFactory.ScreenLoadAction> loadActions;
    private AbstractScreen screenToLoad;

    public LoadScreen(AstraXApp game) {
        super(game);
    }

    public void setLoadActions(AbstractScreen screenToLoad, List<ScreenFactory.ScreenLoadAction> loadActions) {
        this.loadActions = loadActions;
        this.actionCount = loadActions.size();
        this.timer = 0.0f;
        this.screenToLoad = screenToLoad;
        this.label.setText("");
    }

    @Override
    public void create() {
        this.componentFactory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
        this.backToMenu = new AstraXTextButton(this.componentFactory, null, "primary");
        this.backToMenu.setText(this.componentFactory.translate("load_screen_back_to_main"));
        this.backToMenu.setCanCheck(false);
        this.backToMenu.setVisible(false);
        this.backToMenu.setTouchable(Touchable.disabled);
        this.backToMenu.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                MainMenuScreen screen = AstraXApp.astraX.getScreen(MainMenuScreen.class);
                if (!screen.isCreated()) {
                    screen.create();
                }
                LoadScreen.this.backToMenu.setVisible(false);
                LoadScreen.this.backToMenu.setTouchable(Touchable.disabled);
                AstraXApp.astraX.setScreen(MainMenuScreen.class);
                screen.getMainMenuFlowController().returnToMain();
                screen.resume();
            }
        }));
        this.label = new AstraXLabel(this.componentFactory, "", "default", null);
        this.progressBar = new ProgressBar(this.componentFactory){

            @Override
            public float getPrefWidth() {
                return ComponentFactory.PRIMARY_TAB_WIDTH;
            }
        };
        this.progressBar.setSize(ComponentFactory.PRIMARY_TAB_WIDTH, 32.0f);
        this.label.setPosition((float)(Gdx.graphics.getWidth() / 2) - this.progressBar.getPrefWidth() / 2.0f, Gdx.graphics.getHeight() / 2);
        this.progressBar.setPosition((float)(Gdx.graphics.getWidth() / 2) - this.progressBar.getPrefWidth() / 2.0f, Gdx.graphics.getHeight() / 2 - 50);
        this.backToMenu.setPosition((float)(Gdx.graphics.getWidth() / 2) - this.backToMenu.getWidth() / 2.0f, Gdx.graphics.getHeight() / 2 - 150);
        this.hudStage.addActor(this.progressBar);
        this.hudStage.addActor(this.label);
        this.hudStage.addActor(this.backToMenu);
        this.created = true;
    }

    @Override
    public void render(float delta) {
        this.app.getMusicPlayer().update(delta);
        if (this.hidden || this.paused) {
            return;
        }
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.hudStage.act();
        this.uiStage.act();
        this.hudStage.draw();
        this.uiStage.draw();
        if (this.loadActions == null) {
            return;
        }
        if (this.loadActions.isEmpty()) {
            this.screenToLoad.create();
            this.screenToLoad.setLoaded(true);
            this.screenToLoad.onScreenFinishedLoading();
            this.resetState();
            this.app.setScreen(this.screenToLoad.getClass());
            this.screenToLoad = null;
        }
        this.timer += delta;
        if (this.timer > this.interval) {
            ScreenFactory.ScreenLoadAction loadAction = this.loadActions.get(0);
            this.label.setText(loadAction.logMessage);
            try {
                loadAction.execute();
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.label.setText(this.componentFactory.translate("load_screen_error"));
                this.backToMenu.addAction(Tweening.getDropDownFadeIn(1.0f));
                SpaceScreen screen = AstraXApp.astraX.getScreen(SpaceScreen.class);
                screen.dispose();
                SpaceScreen newScreen = new SpaceScreen(AstraXApp.astraX);
                AstraXApp.astraX.addScreen(newScreen);
                this.resetState();
                this.screenToLoad.dispose();
                this.screenToLoad = null;
                return;
            }
            this.loadActions.remove(0);
            float value = 1.0f - (float)this.loadActions.size() / (float)this.actionCount;
            this.progressBar.setValue(value);
            this.timer = 0.0f;
        }
    }

    private void resetState() {
        this.timer = 0.0f;
        this.loadActions = null;
        this.actionCount = 0;
        this.progressBar.setValue(0.0f);
    }

    @Override
    public void dispose() {
    }
}

