/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.UserProfile;
import com.neutronio.astrax.app.UserProfileFactory;
import com.neutronio.astrax.app.datapack.game.GameSettings;
import com.neutronio.astrax.app.generator.ProbabilitySetGenerator;
import com.neutronio.astrax.app.main.SavedGame;
import com.neutronio.astrax.app.repository.UserProfileRepository;
import com.neutronio.astrax.app.screen.AbstractScreen;
import com.neutronio.astrax.app.screen.CreditsScreen;
import com.neutronio.astrax.app.screen.LoadScreen;
import com.neutronio.astrax.app.screen.ScreenFactory;
import com.neutronio.astrax.app.screen.SpaceScreen;
import com.neutronio.astrax.app.screen.SpacecraftEditorScreen;
import com.neutronio.astrax.app.screen.test.DevScreenMenu;
import com.neutronio.astrax.gfx.Parallax;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.commons.widgets.Modal;
import com.neutronio.astrax.ui.commons.widgets.SocialButtons;
import com.neutronio.astrax.ui.main.UserProfilePanel;
import com.neutronio.astrax.ui.main.newgame.MainMenuFlowController;
import com.neutronio.astrax.util.animation.Tweening;
import com.neutronio.astrax.util.collections.ProbabilitySet;
import com.neutronio.astrax.util.sequences.NumberGenerator;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;

public class MainMenuScreen
extends AbstractScreen {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private Calendar today = Calendar.getInstance();
    private String[] songs = new String[]{"main", "main", "main", "song5", "song5", "song4"};
    private Parallax parallax;
    private Image logo;
    private Image companyLogo;
    private Table logoGroup;
    private UserProfilePanel userProfilePanel;
    private AstraXLabel header;
    private ProbabilitySet<String> taglines;
    private ProbabilitySetGenerator taglineGenerator;
    private NumberGenerator numberGenerator;
    private SocialButtons socialsPanel;
    private SocialButtons feedbackPanel;
    private Label subTitleLabel;
    private DevScreenMenu screenTestMenu;
    private MainMenuFlowController mainMenuFlowController;
    private SimplePanel infoPanel;
    private Modal<SimplePanel> infoPanelModal;

    public MainMenuScreen(AstraXApp astraxApp) {
        super(astraxApp);
        ComponentFactory factory = this.app.getAppFactoryByClass(ComponentFactory.class);
        Skin skin = factory.getSkin();
        this.header = new AstraXLabel(factory, "", "header-no-bg", null);
        this.header.setVisible(false);
        this.header.setFontScale(2.0f);
        this.header.setTouchable(Touchable.disabled);
        this.header.setPosition(Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight() - this.header.getPrefHeight() / 2.0f - 20.0f);
        this.numberGenerator = new NumberGenerator(System.currentTimeMillis());
        this.taglineGenerator = new ProbabilitySetGenerator();
        this.taglines = new ProbabilitySet();
        this.taglines.addProbability("It's YuuuuuUUUUUGE", 3.0f);
        this.taglines.addProbability("Seek fuel intake", 3.0f);
        this.taglines.addProbability(factory.translate("menu_tagline_cosmic_horrors"), 5.0f);
        this.taglines.addProbability(factory.translate("menu_tagline_stardust"), 5.0f);
        this.taglines.addProbability(factory.translate("menu_tagline_honk"), 10.0f);
        this.taglines.addProbability(factory.translate("menu_tagline_hot_jupiters"), 10.0f);
        this.taglines.addProbability(factory.translate("menu_tagline_default"), 100.0f);
        this.userProfilePanel = new UserProfilePanel(factory);
        this.userProfilePanel.setCanCheck(false);
        this.userProfilePanel.setPosition(0.0f, 0.0f);
        this.userProfilePanel.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                MainMenuScreen.this.mainMenuFlowController.showUserPickerModal();
            }
        }));
        this.userProfilePanel.update(null);
        Array<TextureAtlas.AtlasRegion> starRegions = astraxApp.getCoreDataPack().getTextureAtlas().findRegions("env/particle_star_large");
        this.parallax = new Parallax(10, starRegions.toArray(), new NumberGenerator(33L));
        this.parallax.setDirection(0.0f, 1.0f);
        this.parallax.setSpeed(0.1f);
        this.parallax.setSize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.parallax.setPosition((float)(-Gdx.graphics.getWidth()) / 2.0f, (float)(-Gdx.graphics.getHeight()) / 2.0f);
        this.parallax.toBack();
        this.companyLogo = new Image(factory.getSkin(), "neutronio-logo");
        this.companyLogo.setPosition((float)(Gdx.graphics.getWidth() / 2) - this.companyLogo.getWidth() / 2.0f, 50.0f);
        this.mainMenuFlowController = new MainMenuFlowController(this.app, factory, this, factory.getSkin());
        this.logo = new Image(factory.getSkin(), "astrax-logo");
        this.logo.setSize(this.logo.getWidth() * 2.0f, this.logo.getHeight() * 2.0f);
        this.logo.setPosition((float)Gdx.graphics.getWidth() / 2.0f - this.logo.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() - this.logo.getHeight() - 40.0f);
        this.logo.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                CreditsScreen creditsScreen = AstraXApp.astraX.getScreen(CreditsScreen.class);
                if (!creditsScreen.created) {
                    creditsScreen.create();
                }
                AstraXApp.astraX.setScreen(CreditsScreen.class);
            }

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                super.enter(event, x, y, pointer, fromActor);
                MainMenuScreen.this.logo.setColor(Color.YELLOW);
            }

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                super.exit(event, x, y, pointer, toActor);
                MainMenuScreen.this.logo.setColor(Color.WHITE);
            }
        });
        this.subTitleLabel = new Label("", skin, "default-no-bg");
        this.subTitleLabel.setPosition((float)Gdx.graphics.getWidth() / 2.0f - this.subTitleLabel.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() - this.logo.getHeight() - this.subTitleLabel.getHeight() - 60.0f);
        this.logoGroup = new Table();
        this.logoGroup.add(this.logo).minSize(342.0f, 82.0f).padBottom(30.0f);
        this.logoGroup.row();
        this.logoGroup.add(this.subTitleLabel);
        this.logoGroup.pack();
        this.logoGroup.setPosition((float)Gdx.graphics.getWidth() / 2.0f - this.logoGroup.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() - this.logoGroup.getHeight() - 40.0f);
        this.logoGroup.setVisible(false);
        this.infoPanel = new SimplePanel(factory, "infoPanel", "window-body");
        this.infoPanel.pad(15.0f);
        this.infoPanel.addLabel("Ahoy, Pilots!");
        this.infoPanel.row();
        this.infoPanel.addLabel("This game is a solo project still in early development. Features are subject to\nchange and there will be bugs as I battle this massive piece of a game.");
        this.infoPanel.row();
        this.infoPanel.addLabel("I hope you enjoy playing as much as I enjoy making it. Creating the ultimate\nspace simulation game has been a dream of mine for a very long time and I am\nworking hard to make it a reality.");
        this.infoPanel.row();
        this.infoPanel.addHeader("Contact", 1);
        this.infoPanel.row();
        this.infoPanel.addLabel("Found a bug? Got feedback or suggestions? Perhaps feature requests?\nThere are plenty of ways too get in touch, such as social media, the forum on\nitch.io, or the feedback buttons to the right. Everything is linked in the\nmain menu!\n\nOh and don't forget to subscribe to the newsletter to stay updated.");
        this.infoPanel.row();
        this.infoPanel.addLabel("            - Betty @ Neutronio Games");
        this.infoPanel.row();
        AstraXTextButton button = new AstraXTextButton(factory, "primary");
        button.setText(factory.translate("dialog_ok"));
        button.setCanCheck(false);
        button.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                MainMenuScreen.this.infoPanelModal.hide();
            }
        }));
        this.infoPanel.add(button).center();
        this.infoPanel.pack();
        this.infoPanelModal = new Modal<SimplePanel>(factory, this.infoPanel);
        this.infoPanelModal.setHeaderText("Welcome to AstraX Early Access");
        this.infoPanelModal.setHeaderIcon("icon_inline_heart");
        this.hudStage.addActor(this.infoPanelModal);
        this.screenTestMenu = new DevScreenMenu(astraxApp, factory);
        this.screenTestMenu.construct();
        this.screenTestMenu.setPosition(20.0f, (float)Gdx.graphics.getHeight() / 2.0f - this.screenTestMenu.getHeight() / 2.0f);
        this.screenTestMenu.setVisible(false);
        this.socialsPanel = new SocialButtons(factory);
        this.socialsPanel.addButton("Official Website", "https://astrax-game.com/?referrer=ingame", new AstraXButton(factory, "icon_inline_target_solid", "socials"));
        this.socialsPanel.addButton("Newsletter", "https://astrax-game.com/newsletter/?referrer=ingame", new AstraXButton(factory, "icon_inline_message", "socials"));
        this.socialsPanel.addButton("YouTube", "https://www.youtube.com/channel/UCbooODhJ4jSAvLYrQ_XIg6A", new AstraXButton(factory, "icon_inline_youtube", "socials"));
        this.socialsPanel.addButton("itch.io", "https://neutroniogames.itch.io/astrax", new AstraXButton(factory, "icon_inline_itchio", "socials"));
        this.socialsPanel.addButton("bluesky", "https://bsky.app/profile/neutronio.games", new AstraXButton(factory, "icon_inline_bluesky", "socials"));
        this.socialsPanel.pack();
        this.socialsPanel.setPosition((float)(Gdx.graphics.getWidth() / 2) - this.socialsPanel.getWidth() / 2.0f, 200.0f);
        CustomAction toggleDevMenuAction = CustomAction.get(new Runnable(){

            @Override
            public void run() {
                if (MainMenuScreen.this.screenTestMenu.isVisible()) {
                    MainMenuScreen.this.screenTestMenu.addAction(Tweening.getDefaultFadeOut(0.8f));
                } else {
                    MainMenuScreen.this.screenTestMenu.addAction(Tweening.getDefaultFadeIn(0.5f));
                }
            }
        });
        this.feedbackPanel = new SocialButtons(factory);
        this.feedbackPanel.setVertical(true);
        AstraXButton devButton = new AstraXButton(factory, "icon_inline_plug", "socials");
        this.feedbackPanel.addButton("Report a Bug", "https://forms.gle/bqz6H1fueJLpX3wm7", new AstraXButton(factory, "icon_inline_bug", "socials"));
        this.feedbackPanel.addButton("Share Feedback", "https://forms.gle/bqz6H1fueJLpX3wm7", new AstraXButton(factory, "icon_inline_bulb", "socials"));
        this.feedbackPanel.addButton("Dev tools", toggleDevMenuAction, devButton);
        devButton.setCanCheck(true);
        this.feedbackPanel.pack();
        this.hudStage.addActor(this.parallax);
        this.hudStage.addActor(this.userProfilePanel);
        this.hudStage.addActor(this.companyLogo);
        this.hudStage.addActor(this.socialsPanel);
        this.hudStage.addActor(this.feedbackPanel);
        this.hudStage.addActor(this.mainMenuFlowController.getStack());
        this.hudStage.addActor(this.logoGroup);
        this.hudStage.addActor(this.header);
        this.hudStage.addActor(this.screenTestMenu);
    }

    public MainMenuFlowController getMainMenuFlowController() {
        return this.mainMenuFlowController;
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    public UserProfilePanel getUserProfilePanel() {
        return this.userProfilePanel;
    }

    public void resetScreenState() {
        this.mainMenuFlowController.returnToMain();
        this.mainMenuFlowController.reset();
    }

    public void showHeader(String headerText) {
        this.header.setText(headerText);
        this.header.addAction(Tweening.getSlideFadeIn(0.4f, (float)(Gdx.graphics.getWidth() / 2) - this.header.getPrefWidth() / 2.0f, (float)Gdx.graphics.getHeight() - this.header.getPrefHeight() / 2.0f - 20.0f));
    }

    public void hideHeader() {
        this.header.addAction(Tweening.getSlideFadeOut(0.4f, Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight() - this.header.getPrefHeight() / 2.0f - 20.0f));
    }

    public boolean isLogoShown() {
        return this.logoGroup.isVisible();
    }

    public void showLogoAndHints() {
        this.logger.finest("Fade in logo");
        this.companyLogo.addAction(Tweening.getSlideFadeIn(0.4f, this.companyLogo.getX(), 20.0f));
        this.logoGroup.addAction(Tweening.getSlideFadeIn(0.4f, this.logoGroup.getX(), (float)Gdx.graphics.getHeight() - this.logoGroup.getHeight() - 40.0f));
        this.userProfilePanel.addAction(Tweening.getSlideFadeIn(0.4f, 0.0f, 0.0f));
        this.feedbackPanel.addAction(Tweening.getSlideFadeIn(0.4f, (float)Gdx.graphics.getWidth() - this.feedbackPanel.getWidth(), (float)(Gdx.graphics.getHeight() / 2) - this.feedbackPanel.getHeight() / 2.0f));
        this.socialsPanel.addAction(Tweening.getSlideFadeIn(0.4f, (float)(Gdx.graphics.getWidth() / 2) - this.socialsPanel.getWidth() / 2.0f, 200.0f));
    }

    public void hideLogoAndHints(CustomAction customAction) {
        this.logger.finest("Fade out logo");
        this.companyLogo.addAction(Tweening.getSlideFadeIn(0.4f, this.companyLogo.getX(), -50.0f));
        this.logoGroup.addAction(Tweening.getSlideFadeOutWithAction(0.4f, this.logoGroup.getX(), Gdx.graphics.getHeight() + 200, customAction));
        this.userProfilePanel.addAction(Tweening.getSlideFadeOut(0.4f, -300.0f, 0.0f));
        this.feedbackPanel.addAction(Tweening.getSlideFadeOut(0.4f, (float)Gdx.graphics.getWidth() + this.feedbackPanel.getWidth(), (float)(Gdx.graphics.getHeight() / 2) - this.feedbackPanel.getHeight() / 2.0f));
        this.socialsPanel.addAction(Tweening.getSlideFadeOut(0.4f, (float)(Gdx.graphics.getWidth() / 2) - this.socialsPanel.getWidth() / 2.0f, -this.socialsPanel.getHeight()));
    }

    public void enterSpaceScreen(GameSettings gameSettings) {
        SpaceScreen screen = this.app.getScreen(SpaceScreen.class);
        LoadScreen loadScreen = this.app.getScreen(LoadScreen.class);
        if (!loadScreen.isCreated()) {
            loadScreen.create();
        }
        ScreenFactory screenFactory = AstraXApp.astraX.getAppFactoryByClass(ScreenFactory.class);
        List<ScreenFactory.ScreenLoadAction> newSpaceGame = screenFactory.createNewSpaceGame(screen, gameSettings);
        loadScreen.setLoadActions(screen, newSpaceGame);
        this.app.setScreen(loadScreen.getClass());
    }

    public void loadGame(SavedGame savedGame) {
        SpaceScreen screen = this.app.getScreen(SpaceScreen.class);
        LoadScreen loadScreen = this.app.getScreen(LoadScreen.class);
        if (!loadScreen.isCreated()) {
            loadScreen.create();
        }
        ScreenFactory screenFactory = AstraXApp.astraX.getAppFactoryByClass(ScreenFactory.class);
        List<ScreenFactory.ScreenLoadAction> loadSpaceGame = screenFactory.loadSpaceGame(screen, AstraXApp.astraX.getActiveUserProfile(), savedGame);
        loadScreen.setLoadActions(screen, loadSpaceGame);
        this.app.setScreen(loadScreen.getClass());
    }

    public void enterEditor() {
        SpacecraftEditorScreen screen = this.app.getScreen(SpacecraftEditorScreen.class);
        if (!screen.isCreated()) {
            screen.create();
        }
        this.app.setScreen(SpacecraftEditorScreen.class);
        screen.resume();
    }

    @Override
    public void create() {
    }

    @Override
    public void show() {
        super.show();
        this.app.getMusicPlayer().playNextSong(this.numberGenerator.getRandomEntry(this.songs));
        if (this.today.get(2) == 2 && this.today.get(5) == 11) {
            this.subTitleLabel.setText("Happy Birthday to me!");
        } else {
            this.subTitleLabel.setText(this.taglineGenerator.generate(this.numberGenerator, this.taglines));
        }
        this.resetScreenState();
        UserProfileRepository userProfileRepository = AstraXApp.astraX.getRepository(UserProfileRepository.class);
        UserProfileFactory userProfileFactory = AstraXApp.astraX.getAppFactoryByClass(UserProfileFactory.class);
        if (userProfileRepository.count() == 0) {
            UserProfile randomUserProfile = userProfileFactory.createRandomUserProfile();
            userProfileFactory.addUserProfileToRepository(randomUserProfile);
            this.mainMenuFlowController.getUserOverview().addNewUserProfile(randomUserProfile);
            this.mainMenuFlowController.getUserOverview().getProfilePalette().setSelected(randomUserProfile);
            this.mainMenuFlowController.onEditFromUserOverview(randomUserProfile);
        } else if (AstraXApp.astraX.getActiveUserProfile() == null) {
            this.mainMenuFlowController.showUserPickerModal();
        } else {
            this.infoPanelModal.toFront();
            this.infoPanelModal.show();
        }
    }

    @Override
    public void render(float delta) {
        this.app.getMusicPlayer().update(delta);
        if (this.hidden) {
            return;
        }
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.hudStage.act();
        this.renderOverride(delta);
        this.backgroundStage.render(0.0f, 0.0f);
        this.hudStage.draw();
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        this.mainMenuFlowController.getStack().pack();
        this.mainMenuFlowController.getStack().setPosition((float)width / 2.0f - this.mainMenuFlowController.getStack().getWidth() / 2.0f, (float)height / 2.0f - this.mainMenuFlowController.getStack().getHeight() / 2.0f);
    }

    @Override
    public void dispose() {
    }
}

