/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.AbstractApplicationFactory;
import com.neutronio.astrax.app.CameraFocusManager;
import com.neutronio.astrax.app.UserProfile;
import com.neutronio.astrax.app.datapack.DataPack;
import com.neutronio.astrax.app.datapack.GameSessionFactory;
import com.neutronio.astrax.app.datapack.game.GameFactory;
import com.neutronio.astrax.app.datapack.game.GameSettings;
import com.neutronio.astrax.app.datapack.game.world.Player;
import com.neutronio.astrax.app.datapack.game.world.World;
import com.neutronio.astrax.app.datapack.game.world.galaxy.SectorStream;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.CargoSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoveryDatabank;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoverySystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.StarSystemFactory;
import com.neutronio.astrax.app.main.SavedGame;
import com.neutronio.astrax.app.screen.AbstractScreen;
import com.neutronio.astrax.app.screen.SpaceScreen;
import com.neutronio.astrax.gfx.AsteroidGraphicsFactory;
import com.neutronio.astrax.gfx.AstraXRenderContext;
import com.neutronio.astrax.gfx.PanningCamera;
import com.neutronio.astrax.gfx.Parallax;
import com.neutronio.astrax.gfx.factories.PlanetGraphicsFactory;
import com.neutronio.astrax.gfx.factories.SatelliteGraphicsFactory;
import com.neutronio.astrax.input.InputProcessor;
import com.neutronio.astrax.input.SpaceScreenActions;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.game.DiscoveryPanel;
import com.neutronio.astrax.ui.game.GameOverOverlay;
import com.neutronio.astrax.ui.game.menu.StarMap;
import com.neutronio.astrax.ui.game.menu.StationTab;
import com.neutronio.astrax.ui.game.menu.TabbedGameMenu;
import com.neutronio.astrax.ui.game.menu.map.bookmarks.ManageBookmarksPanel;
import com.neutronio.astrax.ui.hud.HUD;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.junit.jupiter.api.function.Executable;

public class ScreenFactory
extends AbstractApplicationFactory {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private AstraXApp gameContainer;
    private GameFactory gameFactory;
    private GameSessionFactory gameSessionFactory;

    public ScreenFactory(AstraXApp gameContainer, GameFactory gameFactory) {
        super(gameContainer);
        this.gameContainer = gameContainer;
        this.gameFactory = gameFactory;
    }

    public List<ScreenLoadAction> createNewSpaceGame(SpaceScreen spaceScreen, GameSettings gameSettings) {
        this.gameSessionFactory = this.gameContainer.getFactoryByClass(GameSessionFactory.class);
        ArrayList<ScreenLoadAction> loadActions = new ArrayList<ScreenLoadAction>();
        loadActions.add(this.initNewGame(spaceScreen, AstraXApp.astraX.getActiveUserProfile(), gameSettings));
        loadActions.add(this.initRenderContexts(spaceScreen));
        loadActions.add(this.initSectorStreaming(spaceScreen));
        loadActions.add(this.savePlayerSpacecraft(spaceScreen));
        loadActions.add(this.initParallax(spaceScreen));
        loadActions.add(this.initHUD(spaceScreen));
        loadActions.add(this.initInput(spaceScreen));
        loadActions.add(this.initUI(spaceScreen));
        return loadActions;
    }

    public List<ScreenLoadAction> loadSpaceGame(SpaceScreen spaceScreen, UserProfile userProfile, SavedGame savedGame) {
        this.gameSessionFactory = this.gameContainer.getFactoryByClass(GameSessionFactory.class);
        ArrayList<ScreenLoadAction> loadActions = new ArrayList<ScreenLoadAction>();
        loadActions.add(this.loadGame(spaceScreen, userProfile, savedGame));
        loadActions.add(this.initRenderContexts(spaceScreen));
        loadActions.add(this.initSectorStreaming(spaceScreen));
        loadActions.add(this.initParallax(spaceScreen));
        loadActions.add(this.initHUD(spaceScreen));
        loadActions.add(this.initInput(spaceScreen));
        loadActions.add(this.initUI(spaceScreen));
        return loadActions;
    }

    public ScreenLoadAction<SpaceScreen> loadGame(final SpaceScreen spaceScreen, final UserProfile profile, final SavedGame savedGame) {
        return new ScreenLoadAction<SpaceScreen>(spaceScreen, "Loading Game..."){

            @Override
            public void execute() throws Throwable {
                ScreenFactory.this.gameSessionFactory.loadGame(spaceScreen, profile, savedGame);
            }
        };
    }

    public ScreenLoadAction<SpaceScreen> initNewGame(final SpaceScreen spaceScreen, final UserProfile profile, final GameSettings gameSettings) {
        return new ScreenLoadAction<SpaceScreen>(spaceScreen, "Init Game..."){

            @Override
            public void execute() throws Throwable {
                ScreenFactory.this.gameSessionFactory.newGame(spaceScreen, profile, gameSettings);
            }
        };
    }

    public ScreenLoadAction<SpaceScreen> initRenderContexts(SpaceScreen spaceScreen) {
        return new ScreenLoadAction<SpaceScreen>(spaceScreen, "Init render contexts..."){

            @Override
            public void execute() throws Throwable {
                ComponentFactory factory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
                PlanetGraphicsFactory planetGraphicsFactory = AstraXApp.astraX.getFactoryByClass(PlanetGraphicsFactory.class);
                AsteroidGraphicsFactory asteroidGraphicsFactory = AstraXApp.astraX.getFactoryByClass(AsteroidGraphicsFactory.class);
                SatelliteGraphicsFactory satelliteGraphicsFactory = AstraXApp.astraX.getFactoryByClass(SatelliteGraphicsFactory.class);
                AstraXRenderContext worldStageRenderContext = new AstraXRenderContext(factory, ((SpaceScreen)this.screen).getWorldStage(), factory.getSkin().getRegion("star_1"));
                planetGraphicsFactory.setWorldRenderContext(worldStageRenderContext);
                satelliteGraphicsFactory.setWorldRenderContext(worldStageRenderContext);
                asteroidGraphicsFactory.setWorldRenderContext(worldStageRenderContext);
                AstraXRenderContext hudStageRenderContext = new AstraXRenderContext(factory, ((SpaceScreen)this.screen).hudStage, factory.getSkin().getRegion("star_1"));
                factory.setHudRenderContext(hudStageRenderContext);
                AstraXRenderContext uiStageRenderContext = new AstraXRenderContext(factory, ((SpaceScreen)this.screen).uiStage, factory.getSkin().getRegion("star_1"));
                factory.setUiRenderContext(uiStageRenderContext);
            }
        };
    }

    public ScreenLoadAction<SpaceScreen> initSectorStreaming(SpaceScreen spaceScreen) {
        return new ScreenLoadAction<SpaceScreen>(spaceScreen, "Init sector streaming from database..."){

            @Override
            public void execute() throws Throwable {
                SectorStream sectorStream = new SectorStream();
                sectorStream.setSpaceScreen((SpaceScreen)this.screen);
                sectorStream.setGalaxyMapContext(((SpaceScreen)this.screen).getAstraxGame().getWorld().getGalaxyMapContext());
                sectorStream.setGameSessionFactory(AstraXApp.astraX.getFactoryByClass(GameSessionFactory.class));
                ((SpaceScreen)this.screen).getAstraxGame().getWorld().setSectorStream(sectorStream);
                ((SpaceScreen)this.screen).getAstraxGame().getWorld().getSectorTracker().addListener(sectorStream);
                ((SpaceScreen)this.screen).getAstraxGame().getWorld().getSectorTracker().setSectorBoundsX((int)(StarSystemFactory.maxExtent * 2.5f));
                ((SpaceScreen)this.screen).getAstraxGame().getWorld().getSectorTracker().setSectorBoundsY((int)(StarSystemFactory.maxExtent * 2.5f));
            }
        };
    }

    public ScreenLoadAction<SpaceScreen> initParallax(SpaceScreen spaceScreen) {
        return new ScreenLoadAction<SpaceScreen>(spaceScreen, "Init parallax..."){

            @Override
            public void execute() throws Throwable {
                DataPack defaultDataPack = ((SpaceScreen)this.screen).astraxGame.findDataPack(AstraXApp.DEFAULT_DATAPACK);
                Array<TextureAtlas.AtlasRegion> starRegions = defaultDataPack.getTextureAtlas().findRegions("env/particle_star_large");
                Parallax parallax = new Parallax(5, starRegions.toArray(), defaultDataPack.getNumberGenerator());
                parallax.setPosition(0.0f, 0.0f);
                parallax.setSize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
                ((SpaceScreen)this.screen).setParallax(parallax);
                ((SpaceScreen)this.screen).getParallaxStage().addActor(parallax);
            }
        };
    }

    public ScreenLoadAction<SpaceScreen> initHUD(SpaceScreen spaceScreen) {
        return new ScreenLoadAction<SpaceScreen>(spaceScreen, "Init HUD..."){

            @Override
            public void execute() throws Throwable {
                ComponentFactory factory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
                HUD hud = new HUD(factory, ScreenFactory.this.gameContainer.getUiSoundManager());
                DiscoveryDatabank databank = ((Satellite)((SpaceScreen)this.screen).astraxGame.getLocalPlayer().getPlayerTarget().getModel()).getSystem(DiscoverySystem.class).getDatabank();
                hud.getObjectHUD().setDiscoveryDatabank(databank);
                ((SpaceScreen)this.screen).setHudComponent(hud);
                ((SpaceScreen)this.screen).getHudStage().addActor(hud);
                PanningCamera camera = new PanningCamera((OrthographicCamera)((SpaceScreen)this.screen).getWorldStage().getCamera(), (OrthographicCamera)((SpaceScreen)this.screen).getBackgroundStage().getCamera());
                camera.setFocusedActor(((SpaceScreen)this.screen).astraxGame.getLocalPlayer().getPlayerTarget());
                ((SpaceScreen)this.screen).setPanningCamera(camera);
            }
        };
    }

    public ScreenLoadAction<SpaceScreen> initInput(SpaceScreen spaceScreen) {
        return new ScreenLoadAction<SpaceScreen>(spaceScreen, "Init Input..."){

            @Override
            public void execute() throws Throwable {
                InputProcessor<AbstractScreen> inputProcessor = new InputProcessor<AbstractScreen>(this.screen);
                inputProcessor.addAction("astrax:pause", SpaceScreenActions.getPause());
                inputProcessor.addAction("astrax:cameraZoomIn", SpaceScreenActions.getZoomIn());
                inputProcessor.addAction("astrax:cameraZoomReset", SpaceScreenActions.getZoomReset());
                inputProcessor.addAction("astrax:cameraZoomOut", SpaceScreenActions.getZoomOut());
                inputProcessor.addAction("astrax:toggleDrill", SpaceScreenActions.getToggleDrill());
                inputProcessor.addAction("astrax:exitTabMenu", SpaceScreenActions.getExitMenu());
                inputProcessor.addAction("astrax:changeTarget", SpaceScreenActions.getChangeTarget());
                inputProcessor.addAction("astrax:contextAction", SpaceScreenActions.getGameContextAction());
                inputProcessor.addAction("astrax:showGalaxyTab", SpaceScreenActions.getShowGalaxyTab());
                inputProcessor.addAction("astrax:showMapTab", SpaceScreenActions.getShowMapTab());
                inputProcessor.addAction("astrax:showInventoryTab", SpaceScreenActions.getShowInventoryTab());
                inputProcessor.addAction("astrax:showHelpTab", SpaceScreenActions.getShowHelpTab());
                inputProcessor.addAction("astrax:showDebug", SpaceScreenActions.getShowDebugDraw());
                ((SpaceScreen)this.screen).setInputProcessor(inputProcessor);
                AstraXApp.astraX.applyKeyMappingsToScreen((SpaceScreen)this.screen);
            }
        };
    }

    public ScreenLoadAction<SpaceScreen> initUI(SpaceScreen spaceScreen) {
        return new ScreenLoadAction<SpaceScreen>(spaceScreen, "Init UI..."){

            @Override
            public void execute() throws Throwable {
                ComponentFactory factory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
                Table uiLayout = new Table();
                uiLayout.setPosition(0.0f, 0.0f);
                uiLayout.setSize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
                ((SpaceScreen)this.screen).setUiLayout(uiLayout);
                ((SpaceScreen)this.screen).getUiStage().addActor(uiLayout);
                Player localPlayer = ((SpaceScreen)this.screen).astraxGame.getLocalPlayer();
                TabbedGameMenu tabMenu = new TabbedGameMenu(factory, ((SpaceScreen)this.screen).getAstraxGame().getWorld().getGalaxyMapContext().getDatabase());
                ((SpaceScreen)this.screen).setTabMenu(tabMenu);
                tabMenu.construct();
                tabMenu.setVisible(false);
                tabMenu.getStationTab().setListener((StationTab.StationTabListener)((Object)this.screen));
                tabMenu.getMapTab().setGalaxy(((SpaceScreen)this.screen).getGalaxy());
                tabMenu.getMapTab().getStarMap().setListener((StarMap.StarMapListener)((Object)this.screen));
                tabMenu.getMapTab().getStarMap().getDiscoveryPanel().setListener((DiscoveryPanel.DiscoveryPanelListener)((Object)this.screen));
                tabMenu.getMapTab().setDiscoverySystem(((Satellite)localPlayer.getPlayerTarget().getModel()).getSystem(DiscoverySystem.class));
                tabMenu.getMapTab().setSelf(localPlayer.getDiscoveryTarget());
                tabMenu.getMapTab().getBookmarkTab().getManageBookmarksPanel().setListener((ManageBookmarksPanel.ManageBookmarksListener)((Object)this.screen));
                tabMenu.getSettingsTab().applyStarterValues(ScreenFactory.this.gameContainer.getApplicationSettings());
                ((SpaceScreen)this.screen).getUiStage().addActor(tabMenu);
                tabMenu.updateCargo(((Satellite)((SpaceScreen)this.screen).astraxGame.getLocalPlayer().getPlayerTarget().getModel()).getSystem(CargoSystem.class));
                GameOverOverlay gameOverOverlay = new GameOverOverlay(factory.getSkin());
                ((SpaceScreen)this.screen).setGameOverOverlay(gameOverOverlay);
                CameraFocusManager cameraFocusManager = new CameraFocusManager((SpaceScreen)this.screen);
                cameraFocusManager.setControlledSatellite(((SpaceScreen)this.screen).getAstraxGame().getLocalPlayer().getPlayerTarget());
                cameraFocusManager.setCamera(((SpaceScreen)this.screen).panningCamera);
                ((SpaceScreen)this.screen).setCameraFocusManager(cameraFocusManager);
                ((SpaceScreen)this.screen).gainFocusPlayer();
            }
        };
    }

    public ScreenLoadAction<SpaceScreen> savePlayerSpacecraft(SpaceScreen spaceScreen) {
        return new ScreenLoadAction<SpaceScreen>(spaceScreen, "Save Player Spacecraft..."){

            @Override
            public void execute() throws Throwable {
                World world = ((SpaceScreen)this.screen).getAstraxGame().getWorld();
                ScreenFactory.this.gameSessionFactory.savePlayer(world.getLocalPlayer(), ((SpaceScreen)this.screen).astraxGame.getGameDirectory());
            }
        };
    }

    public static abstract class ScreenLoadAction<S extends AbstractScreen>
    implements Executable {
        public S screen;
        public String logMessage;
        final /* synthetic */ ScreenFactory this$0;

        public ScreenLoadAction(S screen, String logMessage) {
            this.this$0 = this$0;
            this.screen = screen;
            this.logMessage = logMessage;
        }
    }
}

