/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.CameraFocusManager;
import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.UsageStatistics;
import com.neutronio.astrax.app.datapack.game.AbstractGameEventListener;
import com.neutronio.astrax.app.datapack.game.BookmarkManager;
import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.app.datapack.game.Game;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.ResourceCollectionManager;
import com.neutronio.astrax.app.datapack.game.world.AsteroidTarget;
import com.neutronio.astrax.app.datapack.game.world.CelestialTarget;
import com.neutronio.astrax.app.datapack.game.world.Discovery;
import com.neutronio.astrax.app.datapack.game.world.NavTarget;
import com.neutronio.astrax.app.datapack.game.world.Player;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Galaxy;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Mineable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Sector;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.Asteroid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetTrait;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.FunctionalSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.Module;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ResourceFlowSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.CargoSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Cargobay;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Item;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.Docking;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.DockingSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.mining.MiningSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.PropulsionSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.Metric;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.MonitoringSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.SensorSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.TargetSorter;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.tanks.TankSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoverySystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.NavigationBookmark;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.trade.TradeSystem;
import com.neutronio.astrax.app.repository.ResourceRepository;
import com.neutronio.astrax.app.screen.AbstractScreen;
import com.neutronio.astrax.app.screen.SpaceGame;
import com.neutronio.astrax.gfx.AsteroidGraphics;
import com.neutronio.astrax.gfx.PanningCamera;
import com.neutronio.astrax.gfx.Parallax;
import com.neutronio.astrax.gfx.SatelliteGraphics;
import com.neutronio.astrax.gfx.entities.PlanetGraphics;
import com.neutronio.astrax.input.InputProcessor;
import com.neutronio.astrax.input.KeyInput;
import com.neutronio.astrax.io.sql.DiscoveryDAO;
import com.neutronio.astrax.ui.AstraXSkin;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.game.GameOverOverlay;
import com.neutronio.astrax.ui.game.PauseOverlay;
import com.neutronio.astrax.ui.game.menu.MapTab;
import com.neutronio.astrax.ui.game.menu.StarMap;
import com.neutronio.astrax.ui.game.menu.StationTab;
import com.neutronio.astrax.ui.game.menu.TabbedGameMenu;
import com.neutronio.astrax.ui.hud.HUD;
import com.neutronio.astrax.util.AstraXUtil;
import com.neutronio.astrax.util.StandardFormats;
import com.neutronio.astrax.util.animation.Tweening;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SpaceScreen
extends AbstractScreen
implements AbstractGameEventListener,
SpaceGame {
    public static final String game_over_reason = "game_over_reason";
    public static final String game_welcome_message = "game_welcome_message";
    public static final String game_hint_camera_focus = "game_hint_camera_focus";
    public static final String game_hint_target_control = "game_hint_target_control";
    public static final String game_hint_hide_alerts = "game_hint_hide_alerts";
    public static final String game_message_docked = "game_message_docked";
    public static final String game_message_undocked = "game_message_undocked";
    public static final String game_message_resources_depleted = "game_message_resources_depleted";
    public static final String game_message_start_miningDrill = "game_message_start_miningDrill";
    public static final String game_message_stop_miningDrill = "game_message_stop_miningDrill";
    public static final String game_message_orbit_scanned = "game_message_orbit_scanned";
    public static final String game_message_object_discovered = "game_message_object_discovered";
    public static final String game_message_trait_discovered = "game_message_trait_discovered";
    public static final String game_message_nothing_to_scan = "game_message_nothing_to_scan";
    public static final String game_message_target_acquired = "game_message_target_acquired";
    public static final String game_context_hint_undock = "game_context_hint_undock";
    public static final String game_context_hint_actions = "game_context_hint_actions";
    public static final String game_context_hint_need_miningDrill = "game_context_hint_need_miningDrill";
    public static final String game_context_hint_action_toggle_miningDrill = "game_context_hint_action_toggle_miningDrill";
    public static final String game_context_hint_action_dock = "game_context_hint_action_dock";
    public static final String game_context_hint_action_scan = "game_context_hint_action_scan";
    public static final String game_over_reason_no_fuel = "game_over_reason_no_fuel";
    public static final String game_over_reason_suffocation = "game_over_message_suffocation";
    private long ambientId;
    protected Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    protected ComponentFactory componentFactory;
    protected boolean showDebugInfo = false;
    protected boolean loaded = false;
    protected boolean gamePaused = false;
    protected InputProcessor<SpaceScreen> inputProcessor;
    protected HUD hudComponent;
    protected Table uiLayout;
    protected Game astraxGame;
    protected CameraFocusManager cameraFocusManager;
    protected PanningCamera panningCamera;
    protected StarSystem system;
    protected TabbedGameMenu tabMenu;
    protected PauseOverlay pauseOverlay;
    protected Parallax parallax;
    protected GameOverOverlay gameOverOverlay;
    protected SpaceScreenDiscoverySystemListener discoverySystemListener;

    public SpaceScreen(AstraXApp game) {
        super(game);
        this.hudStage = new Stage();
        this.uiStage = new Stage();
        this.discoverySystemListener = new SpaceScreenDiscoverySystemListener();
    }

    public void initSound() {
        this.ambientId = this.app.getSfxSoundManager().playSoundAsLoop("space2");
    }

    @Override
    public void resize(int width, int height) {
        this.hudStage.getViewport().update(width, height, true);
        this.uiStage.getViewport().update(width, height, true);
        this.getAstraxGame().getWorld().getStage().getViewport().update(width, height, true);
        this.backgroundStage.getStage().getViewport().update(width, height, true);
    }

    public Stage getWorldStage() {
        return this.astraxGame.getWorld().getStage();
    }

    @Override
    public void initHUD() {
    }

    @Override
    public void initUI() {
    }

    @Override
    public void initGameActors() {
    }

    public InputProcessor<SpaceScreen> getInputProcessor() {
        return this.inputProcessor;
    }

    public void setInputProcessor(InputProcessor<SpaceScreen> inputProcessor) {
        this.inputProcessor = inputProcessor;
        this.getAstraxGame().getWorld().getStage().addListener(this.inputProcessor);
        this.uiStage.addListener(this.inputProcessor);
    }

    public PanningCamera getPanningCamera() {
        return this.panningCamera;
    }

    public void setPanningCamera(PanningCamera panningCamera) {
        this.panningCamera = panningCamera;
    }

    public GameOverOverlay getGameOverOverlay() {
        return this.gameOverOverlay;
    }

    public void setGameOverOverlay(GameOverOverlay gameOverOverlay) {
        this.gameOverOverlay = gameOverOverlay;
    }

    public Table getUiLayout() {
        return this.uiLayout;
    }

    public void setUiLayout(Table uiLayout) {
        this.uiLayout = uiLayout;
    }

    public Game getAstraxGame() {
        return this.astraxGame;
    }

    public void setAstraxGame(Game astraxGame) {
        this.astraxGame = astraxGame;
    }

    public StarSystem getSystem() {
        return this.system;
    }

    public void setSystem(StarSystem system) {
        this.system = system;
    }

    public TabbedGameMenu getTabMenu() {
        return this.tabMenu;
    }

    public void setTabMenu(TabbedGameMenu tabMenu) {
        this.tabMenu = tabMenu;
    }

    public MapTab getMapTab() {
        return this.tabMenu.getMapTab();
    }

    public Parallax getParallax() {
        return this.parallax;
    }

    public void setParallax(Parallax parallax) {
        this.parallax = parallax;
    }

    public HUD getHudComponent() {
        return this.hudComponent;
    }

    public boolean isShowDebugInfo() {
        return this.showDebugInfo;
    }

    public void setShowDebugInfo(boolean showDebugInfo) {
        this.showDebugInfo = showDebugInfo;
    }

    public void setHudComponent(HUD hudComponent) {
        this.hudComponent = hudComponent;
        this.hudComponent.setListener(this);
        this.hudComponent.getHudActionPanel().setListener(this);
    }

    public void setCameraFocusManager(CameraFocusManager cameraFocusManager) {
        this.cameraFocusManager = cameraFocusManager;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    protected void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    private ComponentFactory getComponentFactory() {
        return this.componentFactory;
    }

    public CameraFocusManager getCameraFocusManager() {
        return this.cameraFocusManager;
    }

    public void onControlledSpacecraftChanged(DiscoveryTarget satellite) {
        this.logger.info("Switching to Spacecraft: " + satellite.target.getID());
        Satellite playerSpaceCraft = (Satellite)((SatelliteTarget)satellite.target).getModel();
        playerSpaceCraft.getSystem(MonitoringSystem.class).addListener(this);
        playerSpaceCraft.getSystem(DockingSystem.class).addListener(this);
        if (playerSpaceCraft.hasSystem(MiningSystem.class)) {
            playerSpaceCraft.getSystem(MiningSystem.class).setMiningListener(this);
        }
        if (playerSpaceCraft.hasSystem(CargoSystem.class)) {
            CargoSystem cargoSystem = playerSpaceCraft.getSystem(CargoSystem.class);
            this.getHudComponent().updateEncumbrance(cargoSystem.getCurrentWeight() / cargoSystem.getMaxWeight());
        }
        DiscoverySystem discoverySystem = playerSpaceCraft.getSystem(DiscoverySystem.class);
        discoverySystem.setListener(this.discoverySystemListener);
        discoverySystem.scanSelf(satellite);
        this.tabMenu.getMapTab().setDiscoverySystem(((Satellite)this.getAstraxGame().getWorld().getLocalPlayer().getPlayerTarget().getModel()).getSystem(DiscoverySystem.class));
        this.tabMenu.getMapTab().setSelf(discoverySystem.getSelf());
        this.tabMenu.getSpacecraftTab().initialize(playerSpaceCraft.getTankSystem().getTankManager());
        Map<String, NavigationBookmark> allBookmarks = null;
        BookmarkManager bookmarkManager = this.getAstraxGame().getWorld().getBookmarkManager();
        try {
            allBookmarks = this.getAstraxGame().getWorld().getGalaxyMapContext().getNavigationBookmarkDAO().getAll();
            discoverySystem.initBookmarks(allBookmarks);
            bookmarkManager.init(discoverySystem.getTargetComputer());
            this.getMapTab().getBookmarkTab().getManageBookmarksPanel().setBookmarks(allBookmarks);
            for (NavigationBookmark bookmark : allBookmarks.values()) {
                if (!bookmark.isTracked) continue;
                discoverySystem.getTargetComputer().getBookmarkSensor().addTarget(new DiscoveryTarget<NavTarget>(null, bookmarkManager.getNavTarget(bookmark.entityId), bookmark));
            }
            bookmarkManager.updateBookmarkState(this.getAstraxGame().getWorld().getSectorStream().getCurrentSector());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.getHudComponent().updateBookmarks(playerSpaceCraft);
        this.updateStarMap();
    }

    @Override
    public void gainFocusPlayer() {
        this.getApp().getInputMultiplexer().clear();
        this.getApp().getInputMultiplexer().addProcessor(this.getApp().getGameStage());
        this.getApp().getInputMultiplexer().addProcessor(this.getAstraxGame().getWorld().getStage());
        this.getApp().getInputMultiplexer().addProcessor(this.hudStage);
        this.getAstraxGame().getWorld().getStage().setKeyboardFocus((Actor)this.astraxGame.getLocalPlayer().getPlayerTarget().getGraphics());
    }

    @Override
    public void gainFocusMenu() {
        this.getApp().getInputMultiplexer().clear();
        this.getApp().getInputMultiplexer().addProcessor(this.getApp().getGameStage());
        this.getApp().getInputMultiplexer().addProcessor(this.uiStage);
        this.uiStage.setKeyboardFocus(this.tabMenu);
    }

    public boolean isGamePaused() {
        return this.gamePaused;
    }

    public void pauseGame() {
        this.gamePaused = true;
        this.hudStage.addActor(this.pauseOverlay);
        this.getApp().getSfxSoundManager().pauseSpatialSounds();
    }

    public void resumeGame() {
        this.gamePaused = false;
        this.pauseOverlay.remove();
        this.getApp().getSfxSoundManager().resumeSpatialSounds();
    }

    @Override
    public void pause() {
        super.pause();
        this.getApp().getSfxSoundManager().pauseSpatialSounds();
    }

    @Override
    public void resume() {
        super.resume();
        this.getApp().getSfxSoundManager().resumeSpatialSounds();
    }

    @Override
    public void create() {
        this.initGameActors();
        this.initSound();
        this.initHUD();
        this.initUI();
        this.pauseOverlay = new PauseOverlay(this.app.getAppFactoryByClass(ComponentFactory.class));
        this.loaded = true;
    }

    @Override
    @Deprecated
    public void regenerate() {
    }

    @Override
    public void show() {
        super.show();
        this.componentFactory = this.getApp().getAppFactoryByClass(ComponentFactory.class);
        this.app.getMusicPlayer().playNextSong("song2");
        this.getHudComponent().updatePlayerInfo(this.getAstraxGame().getLocalPlayer());
        ((SatelliteGraphics)this.getAstraxGame().getLocalPlayer().getPlayerTarget().getGraphics()).addAction(Actions.sequence((Action)CustomAction.get(new Runnable(){

            @Override
            public void run() {
                SpaceScreen.this.getApp().showSuccessAlert(SpaceScreen.this.componentFactory.translate(SpaceScreen.game_welcome_message, SpaceScreen.this.getAstraxGame().getLocalPlayer().getName()));
            }
        }), (Action)Actions.repeat(2, Actions.sequence(Actions.delay(10.0f), CustomAction.get(new Runnable(){

            @Override
            public void run() {
                KeyInput contextInput = (KeyInput)SpaceScreen.this.getInputProcessor().getMappedInput("astrax:contextAction");
                String contextActionKey = Input.Keys.toString(contextInput.getKeyCode());
                KeyInput changeTargetInput = (KeyInput)SpaceScreen.this.getInputProcessor().getMappedInput("astrax:changeTarget");
                String changeTargetActionKey = Input.Keys.toString(changeTargetInput.getKeyCode());
                SpaceScreen.this.getApp().showInfoAlert(SpaceScreen.this.componentFactory.translate(SpaceScreen.game_hint_target_control, changeTargetActionKey, contextActionKey));
            }
        }), Actions.delay(120.0f), CustomAction.get(new Runnable(){

            @Override
            public void run() {
                SpaceScreen.this.getApp().showInfoAlert(SpaceScreen.this.componentFactory.translate(SpaceScreen.game_hint_camera_focus));
            }
        }), Actions.delay(120.0f), CustomAction.get(new Runnable(){

            @Override
            public void run() {
                SpaceScreen.this.getApp().showInfoAlert(SpaceScreen.this.componentFactory.translate(SpaceScreen.game_hint_hide_alerts));
            }
        }), Actions.delay(120.0f)))));
        this.getApp().showMessageBox("Your explorer vessel sets out on a journey into the unknown.\nYour mission: discover new habitable lands and find traces of life.\n\nThe galaxy is vast. Good luck.", null);
        ((Satellite)this.getAstraxGame().getLocalPlayer().getPlayerTarget().getModel()).getSystem(PropulsionSystem.class).start();
    }

    public Galaxy getGalaxy() {
        return this.astraxGame.getWorld().getGalaxy();
    }

    public void updateGodmode(boolean godmode) {
        if (this.getHudComponent() == null) {
            return;
        }
        this.getHudComponent().setGodmode(godmode);
    }

    @Override
    public void render(float delta) {
        if (Gdx.input.isButtonJustPressed(0)) {
            // empty if block
        }
        if (Gdx.input.isKeyJustPressed(141)) {
            this.logger.fine("Show System coords");
            Vector2 memberPos = new Vector2();
            Collection<Targetable> systemMembers = this.system.getSystemMembers();
            for (Targetable member : systemMembers) {
                this.system.getLocalCoordinatesOfMember(member.getID(), memberPos);
                this.logger.fine(member.getID() + "/" + member.getName() + ": " + memberPos.x + " " + memberPos.y);
            }
        }
        this.app.getMusicPlayer().update(delta);
        if (!this.isLoaded()) {
            return;
        }
        if (!this.paused && !this.gamePaused) {
            this.getPanningCamera().update();
            this.astraxGame.getWorld().pollSector();
            if (this.system != null) {
                this.system.update(delta);
            }
            PropulsionSystem propulsionSystem = ((Satellite)this.astraxGame.getLocalPlayer().getPlayerTarget().getModel()).getSystem(PropulsionSystem.class);
            SensorSystem sensorSystem = ((Satellite)this.astraxGame.getLocalPlayer().getPlayerTarget().getModel()).getSystem(SensorSystem.class);
            this.getHudComponent().updateCenterHUD(this.panningCamera.getCurrentZoom(), propulsionSystem.getThrusterController("FLAT").getThrust(), ((SatelliteGraphics)this.astraxGame.getLocalPlayer().getPlayerTarget().getGraphics()).getRotation());
            this.parallax.setDirection(sensorSystem.getMeasuredDeltaVelocity().x, sensorSystem.getMeasuredDeltaVelocity().y);
            this.hudComponent.updateGauges((Satellite)this.astraxGame.getLocalPlayer().getPlayerTarget().getModel());
            this.hudComponent.updateTargets((Satellite)this.astraxGame.getLocalPlayer().getPlayerTarget().getModel());
            this.parallaxStage.act();
            this.getAstraxGame().getWorld().getStage().act();
        }
        this.hudStage.act();
        this.uiStage.act();
        if (!this.hidden) {
            Gdx.gl.glClearColor(0.05f, 0.05f, 0.05f, 1.0f);
            Gdx.gl.glClear(16384);
            this.backgroundStage.render(this.panningCamera.getFocusedActor().getWorldPositionX(), this.panningCamera.getFocusedActor().getWorldPositionY());
            this.parallaxStage.draw();
            this.getAstraxGame().getWorld().getStage().draw();
            this.hudStage.draw();
            this.uiStage.draw();
        }
    }

    public void updateContextHint(Targetable targetable) {
        this.getApp().getUiSoundManager().playSoundOnce("retract");
        KeyInput contextInput = (KeyInput)this.getInputProcessor().getMappedInput("astrax:contextAction");
        String shortcutName = Input.Keys.toString(contextInput.getKeyCode());
        if (targetable instanceof AsteroidTarget) {
            if (!((Satellite)this.getAstraxGame().getLocalPlayer().getPlayerTarget().getModel()).hasSystem(MiningSystem.class)) {
                this.getHudComponent().showContextHint(this.componentFactory.translate(game_context_hint_need_miningDrill));
            } else {
                KeyInput miningInput = (KeyInput)this.getInputProcessor().getMappedInput("astrax:toggleDrill");
                String miningActionName = Input.Keys.toString(miningInput.getKeyCode());
                String translated = this.componentFactory.translate(game_context_hint_action_toggle_miningDrill);
                this.getHudComponent().showContextHintWithShortcut(miningActionName, translated);
            }
        } else if (targetable instanceof CelestialTarget) {
            this.getHudComponent().showContextHintWithShortcut(shortcutName, "scan");
        } else if (targetable instanceof SatelliteTarget) {
            if (AstraXUtil.canDock((SatelliteTarget)targetable, this.getAstraxGame().getLocalPlayer().getPlayerTarget())) {
                String translated = this.componentFactory.translate(game_context_hint_action_dock);
                this.getHudComponent().showContextHintWithShortcut(shortcutName, translated);
            } else {
                String translated = this.componentFactory.translate(game_context_hint_action_scan);
                this.getHudComponent().showContextHintWithShortcut(shortcutName, translated);
            }
        }
    }

    public void showTabMenuWith(Class tabClass) {
        if (!this.tabMenu.hasActions()) {
            this.tabMenu.showTab(tabClass);
            this.tabMenu.addAction(Tweening.getDefaultFadeIn(0.5f));
        } else {
            this.tabMenu.setVisible(true);
        }
    }

    public void showTabMenu() {
        if (!this.tabMenu.hasActions()) {
            this.tabMenu.addAction(new SequenceAction(Actions.visible(true), Actions.fadeIn(0.1f, Interpolation.pow2)));
        } else {
            this.tabMenu.setVisible(true);
        }
    }

    public void hideTabMenu() {
        if (!this.tabMenu.hasActions()) {
            this.tabMenu.addAction(Tweening.getDefaultFadeOut(1.0f));
        } else {
            this.tabMenu.setVisible(false);
        }
    }

    @Override
    public void switchStarSystemTo(Sector<StarSystem> enteredSystem) {
        if (this.getSystem() != null) {
            this.logger.log(Level.FINE, "Removing background from stage...");
            for (Targetable targetable : this.getSystem().getSystemMembers()) {
                if (Objects.equals(targetable.getID(), this.getAstraxGame().getLocalPlayer().getPlayerTarget().getID())) continue;
                ((Actor)targetable.getGraphics()).clearListeners();
            }
            this.cameraFocusManager.resetFocus();
            this.getSystem().getGraphics().addAction(Tweening.getSystemDetachAnimation());
            this.getSystem().getBackgroundGraphics().addAction(Tweening.getSystemDetachAnimation());
        }
        this.setSystem(enteredSystem.getChunk());
        if (enteredSystem.getChunk().getRegion() != null) {
            this.getApp().showSuccessAlert("Entering Galaxy Region: " + enteredSystem.getChunk().getRegion().getRegionName());
        }
        this.system.registerTarget(this.astraxGame.getLocalPlayer().getPlayerTarget());
        this.getSystem().getGraphics().setVisible(false);
        this.getSystem().getGraphics().addAction(Tweening.getSystemAttachAnimation());
        this.getSystem().getBackgroundGraphics().setVisible(false);
        this.getSystem().getBackgroundGraphics().addAction(Tweening.getSystemAttachAnimation());
        this.getAstraxGame().getWorld().getStage().addActor(this.getSystem().getGraphics());
        this.backgroundStage.addToStageWithTransform(this.getSystem().getBackgroundGraphics());
        DiscoverySystem discoverySystem = ((Satellite)this.astraxGame.getLocalPlayer().getPlayerTarget().getModel()).getSystem(DiscoverySystem.class);
        discoverySystem.getTargetComputer().setCurrentTarget(null, SpaceScreen.class);
        this.cameraFocusManager.registerTargets(this.getSystem());
    }

    public void updateStarMap() {
        DiscoverySystem discoverySystem = ((Satellite)this.astraxGame.getLocalPlayer().getPlayerTarget().getModel()).getSystem(DiscoverySystem.class);
        this.getMapTab().onStarSystemChanged(this.getAstraxGame().getWorld().getSectorStream().getCurrentSector());
        this.getHudComponent().updateSensorDisplay((Satellite)this.astraxGame.getLocalPlayer().getPlayerTarget().getModel(), null);
        this.getHudComponent().updateDiscoveredPercentage(discoverySystem.getDiscoveredFactor());
        this.getAstraxGame().getWorld().getBookmarkManager().updateBookmarkState(this.getAstraxGame().getWorld().getSectorStream().getCurrentSector());
        this.app.getUiSoundManager().playSoundOnce("beep3");
        ((SatelliteGraphics)this.astraxGame.getLocalPlayer().getPlayerTarget().getGraphics()).toFront();
    }

    public void enterGameOverState(String reason) {
        this.getGameOverOverlay().setReason(reason);
        this.getGameOverOverlay().setPosition((float)Gdx.graphics.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f, 1);
        this.hudStage.addActor(this.getGameOverOverlay());
        this.paused = true;
    }

    @Override
    public void onScreenFinishedLoading() {
        Vector2 worldPosition = this.getAstraxGame().getWorld().getLocalPlayer().getPlayerTarget().getWorldPosition();
        this.getAstraxGame().getWorld().pollSector();
        this.onControlledSpacecraftChanged(this.getAstraxGame().getWorld().getLocalPlayer().getDiscoveryTarget());
    }

    @Override
    public void onResourceMined(Module drillModule, float damage) {
        Player player = this.getAstraxGame().getLocalPlayer();
        if (player.getCurrentTarget() == null) {
            return;
        }
        if (player.getCurrentTarget().target instanceof AsteroidTarget) {
            AsteroidTarget asteroidTarget = (AsteroidTarget)player.getCurrentTarget().target;
            if (((Asteroid)asteroidTarget.getModel()).hasResources()) {
                ResourceCollectionManager resourceCollection = this.getAstraxGame().getWorld().getGameLogic(ResourceCollectionManager.class);
                List<Item<Resource>> items = resourceCollection.mineItemsFrom((Mineable)asteroidTarget.getModel(), (Satellite)player.getPlayerTarget().getModel());
                for (Item<Resource> resourceItem : items) {
                    this.getHudComponent().showQuickMessage("+ " + resourceItem.getAmount() + "x " + resourceItem.getName() + " gathered!", "reward");
                }
                if (player.getCurrentTarget().discovery != null) {
                    DiscoverySystem discoverySystem = ((Satellite)player.getPlayerTarget().getModel()).getSystem(DiscoverySystem.class);
                    for (Item<Resource> resourceItem : items) {
                        discoverySystem.getDatabank().addChildDiscovery(asteroidTarget.getID(), resourceItem.getObject().id);
                        Resource resource = resourceItem.getObject();
                        discoverySystem.getDatabank().addChildDiscovery(player.getCurrentTarget().target.getID(), resource.id);
                        DiscoveryDAO discoveryDAO = this.getAstraxGame().getWorld().getGalaxyMapContext().getDiscoveryDAO();
                        try {
                            if (discoveryDAO.childDiscoveryExists(player.getCurrentTarget().discovery.id, resource.getId())) continue;
                            this.getAstraxGame().getWorld().getGalaxyMapContext().getDiscoveryDAO().addChildDiscoveryTo(player.getCurrentTarget().discovery.id, resource.getId());
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    this.getHudComponent().getObjectHUD().updateWith(player.getCurrentTarget());
                }
                ((AsteroidGraphics)asteroidTarget.getGraphics()).onResourceMined();
                this.getHudComponent().updateEncumbrance(player.getEncumbrance());
                this.logger.info("Resource gathered: " + items);
                this.logger.info("Left in deposit: " + ((Asteroid)asteroidTarget.getModel()).getResources().getDepositSize());
            } else {
                this.getHudComponent().showQuickError(this.componentFactory.translate(game_message_resources_depleted));
                this.logger.info("No resources left in deposit!");
            }
        }
    }

    @Override
    public void onDrillStart(Module drillModule) {
        this.panningCamera.rumble(2.0f);
        this.panningCamera.startRumble(0.3f);
        if (this.getAstraxGame().getLocalPlayer().getCurrentTarget() != null) {
            Object targetable = this.getAstraxGame().getLocalPlayer().getCurrentTarget().target;
            if (targetable instanceof AsteroidTarget) {
                AsteroidTarget asteroidTarget = (AsteroidTarget)targetable;
                ((AsteroidGraphics)asteroidTarget.getGraphics()).onStartMining();
            }
            ((SatelliteGraphics)this.getAstraxGame().getLocalPlayer().getPlayerTarget().getGraphics()).startMiningDrills();
            this.getHudComponent().showQuickMessage(this.componentFactory.translate(game_message_start_miningDrill), "switch:on");
        }
    }

    @Override
    public void onDrillStop(Module drillModule) {
        this.panningCamera.rumble(0.7f);
        this.panningCamera.endRumble();
        if (this.getAstraxGame().getLocalPlayer().getCurrentTarget() != null) {
            Object targetable = this.getAstraxGame().getLocalPlayer().getCurrentTarget().target;
            if (targetable instanceof AsteroidTarget) {
                AsteroidTarget asteroidTarget = (AsteroidTarget)targetable;
                ((AsteroidGraphics)asteroidTarget.getGraphics()).onStopMining();
            }
            ((SatelliteGraphics)this.getAstraxGame().getLocalPlayer().getPlayerTarget().getGraphics()).stopMiningDrills();
            this.getHudComponent().showQuickMessage(this.componentFactory.translate(game_message_stop_miningDrill), "switch:off");
        }
    }

    @Override
    public void onEmpty(ResourceFlowSystem resourceFlowSystem) {
        String reason;
        if (Objects.equals("resource_oxygen", resourceFlowSystem.getSystemPerformance().fuelType)) {
            reason = this.componentFactory.translate(game_over_reason_suffocation);
            this.enterGameOverState(this.componentFactory.translate(game_over_reason, reason));
        }
        if (Objects.equals("resource_rocketFuel", resourceFlowSystem.getSystemPerformance().fuelType)) {
            reason = this.componentFactory.translate(game_over_reason_no_fuel);
            this.enterGameOverState(this.componentFactory.translate(game_over_reason, reason));
        }
    }

    @Override
    public void onMetricDetected(String resourceName, float percentage, Metric.MetricState state) {
        ResourceRepository repository = this.getApp().getRepository(ResourceRepository.class);
        Resource resource = (Resource)repository.find(resourceName);
        if (state == Metric.MetricState.NOMINAL) {
            this.getApp().showInfoAlert(state.name() + ": " + resource.name + " levels restored!");
        } else {
            this.getApp().showMessageAlert(new Message(Metric.MetricState.toMessageType(state), state.name() + ": " + resource.name + " levels low"));
        }
    }

    @Override
    public void onSystemHealthChanged(FunctionalSystem system, FunctionalSystem.SystemHealth oldState, FunctionalSystem.SystemHealth newState) {
        this.getApp().showWarningAlert("System Health: " + system.getName() + " changed to " + newState.name());
    }

    @Override
    public void onDocked(Satellite child, Satellite parent) {
        this.panningCamera.rumble(0.5f);
        this.getMapTab().getGalaxyMap().disableJumpDriveButton();
        this.getHudComponent().showContextHint(this.componentFactory.translate(game_context_hint_undock));
        this.getHudComponent().showQuickWarning(this.componentFactory.translate(game_message_docked));
        this.getHudComponent().getHudActionPanel().getUndockButton().setDisabled(false);
        this.getHudComponent().getHudActionPanel().getUndockButton().doSquish(1.0f, false);
        Satellite playerSpaceCraft = (Satellite)this.getAstraxGame().getLocalPlayer().getPlayerTarget().getModel();
        playerSpaceCraft.getSystem(TankSystem.class).deactivate();
        PropulsionSystem propulsionSystem = playerSpaceCraft.getSystem(PropulsionSystem.class);
        propulsionSystem.stop();
        if (parent.hasSystem(TradeSystem.class)) {
            TradeSystem tradeSystemParent = parent.getSystem(TradeSystem.class);
            TradeSystem tradeSystemChild = child.getSystem(TradeSystem.class);
            this.getTabMenu().getStationButton().setDisabled(false);
            this.showTabMenuWith(StationTab.class);
            this.getTabMenu().getStationTab().setTradingParties(tradeSystemParent, tradeSystemChild);
            this.getTabMenu().getStationTab().update();
        }
        this.gainFocusMenu();
    }

    @Override
    public void onUndocked(Satellite child, Satellite parent) {
        this.getMapTab().getGalaxyMap().enableJumpDriveButton();
        Satellite playerSpaceCraft = (Satellite)this.getAstraxGame().getLocalPlayer().getPlayerTarget().getModel();
        playerSpaceCraft.getSystem(TankSystem.class).activate();
        PropulsionSystem propulsionSystem = playerSpaceCraft.getSystem(PropulsionSystem.class);
        propulsionSystem.start();
        this.panningCamera.rumble(0.4f);
        String message = this.componentFactory.translate(game_message_undocked, parent.getName());
        this.getApp().showSuccessAlert(message);
        this.gainFocusPlayer();
    }

    @Override
    public void onAddToTotalTargets(Targetable target) {
    }

    @Override
    public void onRemoveFromTotalTargets(Targetable target) {
    }

    @Override
    public void onBuyTransactionInitiated(TradeSystem merchant, TradeSystem player, Cargobay<Resource> itemsBoughtFromMerchant) {
        this.logger.fine("Perform transaction for buying items...");
        this.logger.fine("Player money before: " + player.getTrader().getMoney());
        this.logger.fine("Merchant money before:" + merchant.getTrader().getMoney());
        player.buyFrom(merchant, itemsBoughtFromMerchant);
        this.getTabMenu().getCargoBayPanel().update(player.getCargoSystem());
        this.getHudComponent().updatePlayerInfo(this.getAstraxGame().getLocalPlayer());
        this.getTabMenu().getStationTab().updateHard();
        this.logger.fine("Player money after: " + player.getTrader().getMoney());
        this.logger.fine("Merchant money after:" + merchant.getTrader().getMoney());
        this.getHudComponent().updateEncumbrance(player.getCargoSystem().getCurrentWeight() / player.getCargoSystem().getMaxWeight());
    }

    @Override
    public void onSellTransactionInitiated(TradeSystem merchant, TradeSystem player, Cargobay<Resource> itemsSoldToMerchant) {
        this.logger.fine("Perform transaction for selling items...");
        this.logger.fine("Player money before: " + player.getTrader().getMoney());
        this.logger.fine("Merchant money before:" + merchant.getTrader().getMoney());
        player.sellTo(merchant, itemsSoldToMerchant);
        this.getTabMenu().getCargoBayPanel().update(player.getCargoSystem());
        this.getHudComponent().updatePlayerInfo(this.getAstraxGame().getLocalPlayer());
        this.getTabMenu().getStationTab().updateHard();
        this.logger.fine("Player money after: " + player.getTrader().getMoney());
        this.logger.fine("Merchant money after:" + merchant.getTrader().getMoney());
        this.getHudComponent().updateEncumbrance(player.getCargoSystem().getCurrentWeight() / player.getCargoSystem().getMaxWeight());
    }

    @Override
    public void dispose() {
        ComponentFactory componentFactory = this.getApp().getAppFactoryByClass(ComponentFactory.class);
        AstraXSkin skin = (AstraXSkin)componentFactory.getSkin();
        UsageStatistics statistics = AstraXApp.astraX.getStatistics();
        this.logger.warning("Datapack Average Repo usage: " + StandardFormats.PERCENT.format(Float.valueOf(statistics.usedIDsObjectsFactor * 100.0f)) + " %");
        this.logger.warning("Unused Resources in all loaded datapacks: " + statistics.unusedIDs.size());
        this.logger.warning(statistics.unusedIDs.toString());
        this.logger.warning("Unused styles in UI: " + skin.getUsageChecker().getUnusedStrings().size() + "/" + skin.getUsageChecker().getTotalStringCount());
        this.logger.warning(skin.getUsageChecker().getUnusedStrings() + "");
        this.app.getSfxSoundManager().stopSoundLoop(this.ambientId);
        this.hudStage = null;
        this.uiStage = null;
        this.loaded = false;
    }

    @Override
    public void onBookmarkButtonClicked() {
        DiscoveryTarget currentTarget = this.getAstraxGame().getWorld().getLocalPlayer().getCurrentTarget();
        NavigationBookmark bookmark = new NavigationBookmark(currentTarget);
        this.onBookmarkAdded(bookmark);
    }

    @Override
    public void onCameraResetButtonClicked() {
        this.cameraFocusManager.resetFocus();
    }

    @Override
    public void onUndockButtonClicked() {
        SatelliteTarget playerSpacecraft = this.getAstraxGame().getWorld().getLocalPlayer().getPlayerTarget();
        Docking dockingLogic = this.getAstraxGame().getWorld().getGameLogic(Docking.class);
        SatelliteTarget stationTarget = ((Satellite)playerSpacecraft.getModel()).getSystem(DockingSystem.class).getDockedStationTarget();
        Message message = dockingLogic.undock(this.getWorldStage(), stationTarget, playerSpacecraft);
        this.hideTabMenu();
        this.getTabMenu().getStationButton().setDisabled(true);
        this.logger.fine("Hiding context hint");
        this.getHudComponent().hideContextHint();
        this.getHudComponent().showQuickMessage(message);
        this.getHudComponent().getHudActionPanel().getUndockButton().setDisabled(true);
    }

    @Override
    public void onBookmarkRemoved(NavigationBookmark bookmark) {
        SatelliteTarget playerSpacecraft = this.getAstraxGame().getWorld().getLocalPlayer().getPlayerTarget();
        DiscoverySystem discoverySystem = ((Satellite)playerSpacecraft.getModel()).getSystem(DiscoverySystem.class);
        discoverySystem.removeBookmark(bookmark);
        this.getTabMenu().getMapTab().getBookmarkTab().removeBookmark(bookmark);
        this.getTabMenu().getMapTab().getStarMap().getStarMapCanvas().refreshTargetIcon(new EntityID(bookmark.entityId));
        if (this.getHudComponent().isSelectedBookmark(new EntityID("bookmark_" + bookmark.entityId))) {
            this.getHudComponent().getCenterHUD().deselectBookmark();
        }
        try {
            this.getAstraxGame().getWorld().getGalaxyMapContext().getNavigationBookmarkDAO().remove(bookmark.entityId);
            this.getAstraxGame().getWorld().getBookmarkManager().removeBookmarkForTracking(bookmark);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onBookmarkAdded(NavigationBookmark bookmark) {
        bookmark.sectorId = this.getAstraxGame().getWorld().getSectorStream().getCurrentSector().getTileID();
        SatelliteTarget playerSpacecraft = this.getAstraxGame().getWorld().getLocalPlayer().getPlayerTarget();
        DiscoverySystem discoverySystem = ((Satellite)playerSpacecraft.getModel()).getSystem(DiscoverySystem.class);
        discoverySystem.addBookmark(bookmark);
        this.getTabMenu().getMapTab().getBookmarkTab().addBookmark(bookmark);
        this.getMapTab().getStarMap().getStarMapCanvas().refreshTargetIcon(new EntityID(bookmark.entityId));
        try {
            this.getAstraxGame().getWorld().getSectorStream().addNavigationBookmarkToDatabase(bookmark);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onBookmarkModified(NavigationBookmark bookmark) {
        try {
            this.getAstraxGame().getWorld().getGalaxyMapContext().getNavigationBookmarkDAO().update(bookmark);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.getMapTab().getStarMap().getStarMapCanvas().refreshTargetIcon(new EntityID(bookmark.entityId));
        this.getTabMenu().getMapTab().getBookmarkTab().getManageBookmarksPanel().updateToContent();
        if (bookmark.isTracked) {
            SatelliteTarget playerSpacecraft = this.getAstraxGame().getWorld().getLocalPlayer().getPlayerTarget();
            this.getHudComponent().updateBookmarks((Satellite)playerSpacecraft.getModel());
        }
    }

    @Override
    public void onBookmarkTracked(NavigationBookmark bookmark) {
        SatelliteTarget playerSpacecraft = this.getAstraxGame().getWorld().getLocalPlayer().getPlayerTarget();
        DiscoverySystem discoverySystem = ((Satellite)playerSpacecraft.getModel()).getSystem(DiscoverySystem.class);
        bookmark.isTracked = !bookmark.isTracked;
        String message = null;
        if (bookmark.isTracked) {
            message = this.componentFactory.translate("game_map_bookmarks_tracking", bookmark.name);
            Targetable member = this.system.findMember(new EntityID(bookmark.entityId));
            NavTarget navTarget = this.getAstraxGame().getWorld().getBookmarkManager().addBookmarkForTracking(bookmark);
            navTarget.setFollowedTarget(member);
            navTarget.setFollowMode(NavTarget.FOLLOW_MODE_TARGET);
            discoverySystem.getTargetComputer().getBookmarkSensor().addTarget(new DiscoveryTarget<NavTarget>(null, navTarget, bookmark));
            this.getHudComponent().updateBookmarks((Satellite)playerSpacecraft.getModel());
        } else {
            message = "Unpinned Bookmark: " + bookmark.name;
            this.getAstraxGame().getWorld().getBookmarkManager().removeBookmarkForTracking(bookmark);
            discoverySystem.getTargetComputer().getBookmarkSensor().removeTarget(new EntityID("bookmark_" + bookmark.entityId));
            if (this.getHudComponent().isSelectedBookmark(new EntityID("bookmark_" + bookmark.entityId))) {
                this.getHudComponent().getCenterHUD().deselectBookmark();
            }
            this.getHudComponent().updateBookmarks((Satellite)playerSpacecraft.getModel());
        }
        this.getApp().showSuccessAlert(message);
        try {
            this.getAstraxGame().getWorld().getGalaxyMapContext().getNavigationBookmarkDAO().updateTrackedFlag(bookmark.entityId, bookmark.isTracked);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onTargetClicked(DiscoveryTarget targetable, boolean isBookmark) {
        if (targetable == null) {
            return;
        }
        if (isBookmark) {
            if (this.getHudComponent().isSelectedBookmark(new EntityID("bookmark_" + targetable.bookmark.entityId))) {
                this.getHudComponent().getCenterHUD().deselectBookmark();
            } else {
                this.getHudComponent().setSelectedBookmark(targetable.target.getID());
            }
        } else {
            SatelliteTarget playerSpacecraft = this.getAstraxGame().getWorld().getLocalPlayer().getPlayerTarget();
            DiscoverySystem discoverySystem = ((Satellite)playerSpacecraft.getModel()).getSystem(DiscoverySystem.class);
            discoverySystem.getTargetComputer().setCurrentTarget(targetable, SpaceScreen.class);
        }
    }

    @Override
    public void onTargetBookmarked(DiscoveryTarget targetable) {
        if (targetable == null) {
            return;
        }
        NavigationBookmark bookmark = new NavigationBookmark(targetable);
        this.onBookmarkAdded(bookmark);
        this.onBookmarkTracked(bookmark);
        this.getHudComponent().setSelectedBookmark(targetable.target.getID());
        this.getApp().showInfoAlert("Bookmark added & pinned to HUD");
    }

    private class SpaceScreenDiscoverySystemListener
    extends DiscoverySystem.DefaultDiscoverySystemListener {
        private SpaceScreenDiscoverySystemListener() {
        }

        @Override
        public void onTargetDetected(TargetSorter.Target target) {
            SpaceScreen.this.getPanningCamera().rumble(0.5f);
            SpaceScreen.this.getHudComponent().getCenterHUD().flare();
            SpaceScreen.this.getHudComponent().updateTargets((Satellite)SpaceScreen.this.getAstraxGame().getLocalPlayer().getPlayerTarget().getModel());
            Satellite playerSatellite = (Satellite)SpaceScreen.this.getAstraxGame().getLocalPlayer().getPlayerTarget().getModel();
            if (playerSatellite.isTargetSelected(target.getTargetable())) {
                SpaceScreen.this.updateContextHint(target.getTargetable());
            }
            SpaceScreen.this.logger.log(Level.FINE, "Sonar Target detected: " + target.getTargetable().getID());
        }

        @Override
        public void onTargetLost(TargetSorter.Target target) {
            Satellite playerSatellite = (Satellite)SpaceScreen.this.getAstraxGame().getLocalPlayer().getPlayerTarget().getModel();
            SpaceScreen.this.getHudComponent().updateTargets(playerSatellite);
            if (playerSatellite.isTargetSelected(target.getTargetable())) {
                SpaceScreen.this.logger.fine("Hiding context hint");
                SpaceScreen.this.getHudComponent().hideContextHint();
            }
            if (Objects.equals(SpaceScreen.this.getPanningCamera().getFocusedActor().getID(), target.getTargetable().getID())) {
                SpaceScreen.this.getCameraFocusManager().resetFocus();
            }
            SpaceScreen.this.logger.log(Level.FINE, "Sonar Target lost: " + target.getTargetable().getID());
        }

        @Override
        public void onDiscoveryAdded(DiscoveryTarget discovery) {
            Satellite playerSatellite = (Satellite)SpaceScreen.this.getAstraxGame().getLocalPlayer().getPlayerTarget().getModel();
            int pointsIssued = (int)((float)discovery.discovery.discoveryPoints * discovery.discovery.rarity.getMultiplier());
            SpaceScreen.this.getMapTab().discoverTarget(discovery);
            SpaceScreen.this.getAstraxGame().getLocalPlayer().addDiscoveryPoints(pointsIssued);
            SpaceScreen.this.getHudComponent().showQuickMessage(AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class).translate(SpaceScreen.game_message_object_discovered));
            if (playerSatellite.hasSystem(DiscoverySystem.class)) {
                DiscoverySystem discoverySystem = playerSatellite.getSystem(DiscoverySystem.class);
                SpaceScreen.this.getHudComponent().updateDiscoveredPercentage(discoverySystem.getDiscoveredFactor());
            }
            SpaceScreen.this.getHudComponent().updateSelectedTarget(discovery);
            SpaceScreen.this.getHudComponent().updatePlayerInfo(SpaceScreen.this.getAstraxGame().getLocalPlayer());
        }

        @Override
        public void onSubDiscoveryAdded(DiscoveryTarget parentDiscovery, Object discoveredObject, Discovery discovery) {
            CelestialTarget celestialTarget = (CelestialTarget)parentDiscovery.target;
            if (discoveredObject instanceof PlanetTrait) {
                SpaceScreen.this.getHudComponent().refreshTargetListIcon(parentDiscovery.target.getID());
                SpaceScreen.this.getTabMenu().getMapTab().getStarMap().getStarMapCanvas().refreshTargetIcon(parentDiscovery.target.getID());
            }
            if (discovery != null) {
                String messageFormat = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class).translate(SpaceScreen.game_message_trait_discovered);
                int pointsIssued = (int)((float)discovery.discoveryPoints * discovery.rarity.getMultiplier());
                SpaceScreen.this.getAstraxGame().getLocalPlayer().addDiscoveryPoints(pointsIssued);
                String message = String.format(messageFormat, pointsIssued, discovery.name);
                SpaceScreen.this.getHudComponent().showQuickMessage(message);
                SpaceScreen.this.getHudComponent().updateSelectedTarget(parentDiscovery);
                SpaceScreen.this.getHudComponent().updatePlayerInfo(SpaceScreen.this.getAstraxGame().getLocalPlayer());
                ((PlanetGraphics)celestialTarget.getGraphics()).setDiscoveredFactor(parentDiscovery.discovery.discoveredFactor);
            } else if (celestialTarget != null) {
                SpaceScreen.this.logger.fine("Hiding context hint");
                SpaceScreen.this.getHudComponent().hideContextHint();
                SpaceScreen.this.getHudComponent().showQuickError(AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class).translate(SpaceScreen.game_message_nothing_to_scan));
            }
        }

        @Override
        public void onTargetChanged(DiscoveryTarget oldTarget, DiscoveryTarget newTarget, Class source) {
            SpaceScreen.this.logger.log(Level.WARNING, "Target changed: " + oldTarget + " - " + newTarget);
            boolean fromStarMap = source.equals(StarMap.class);
            Satellite playerSatellite = (Satellite)SpaceScreen.this.getAstraxGame().getLocalPlayer().getPlayerTarget().getModel();
            if (newTarget != null) {
                SpaceScreen.this.getMapTab().updateSelectedInfo(newTarget);
                SpaceScreen.this.getHudComponent().updateSelectedTarget(newTarget);
                if (playerSatellite.isInSensorRange((Targetable)newTarget.target)) {
                    SpaceScreen.this.updateContextHint((Targetable)newTarget.target);
                } else {
                    SpaceScreen.this.logger.fine("Hiding context hint");
                    SpaceScreen.this.getHudComponent().hideContextHint();
                }
                if (!fromStarMap) {
                    if (newTarget.target instanceof CelestialTarget) {
                        CelestialTarget celestialTarget = (CelestialTarget)newTarget.target;
                        ((PlanetGraphics)celestialTarget.getGraphics()).setDiscoveredFactor(newTarget.discovery != null ? newTarget.discovery.discoveredFactor : 0.0f);
                        String message = SpaceScreen.this.getComponentFactory().translate(SpaceScreen.game_message_target_acquired, newTarget.getName());
                        SpaceScreen.this.getHudComponent().showQuickMessage(new Message(Message.MessageType.INFO, message));
                    } else if (newTarget.target instanceof SatelliteTarget && !AstraXUtil.canDock((SatelliteTarget)newTarget.target, SpaceScreen.this.getAstraxGame().getLocalPlayer().getPlayerTarget())) {
                        String message = SpaceScreen.this.getComponentFactory().translate(SpaceScreen.game_message_target_acquired, newTarget.getName());
                        SpaceScreen.this.getHudComponent().showQuickMessage(new Message(Message.MessageType.INFO, message));
                    }
                }
            } else {
                SpaceScreen.this.logger.fine("Hiding context hint");
                SpaceScreen.this.getHudComponent().hideContextHint();
                SpaceScreen.this.getMapTab().updateSelectedInfo(null);
                SpaceScreen.this.getHudComponent().updateSelectedTarget(null);
                SpaceScreen.this.getHudComponent().showQuickMessage("Target unset");
            }
        }
    }
}

