/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.KeyMappingSettings;
import com.neutronio.astrax.app.screen.AbstractScreen;
import com.neutronio.astrax.editor.Editor;
import com.neutronio.astrax.gfx.AstraXRenderContext;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.editor.EditorComponent;

public class SpacecraftEditorScreen
extends AbstractScreen {
    private Editor editor;
    private EditorComponent editorComponent;

    public SpacecraftEditorScreen(AstraXApp game) {
        super(game);
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void create() {
        ComponentFactory componentFactory = this.app.getAppFactoryByClass(ComponentFactory.class);
        componentFactory.setHudRenderContext(new AstraXRenderContext(componentFactory, this.hudStage, componentFactory.getSkin().getRegion("star_1")));
        this.editor = new Editor();
        this.editorComponent = new EditorComponent(this.editor, componentFactory);
        this.hudStage.addActor(this.editorComponent);
        KeyMappingSettings editorControls = AstraXApp.astraX.getCoreDataPack().getDataPackSettings().getKeyMapping("editorControls");
        this.editorComponent.getInputProcessor().initializeMappings(editorControls);
        this.hudStage.addListener(this.editorComponent.getInputProcessor());
        this.created = true;
    }

    @Override
    public void show() {
        super.show();
        this.hudStage.setScrollFocus(this.editorComponent.getEditorGrid());
        this.editorComponent.showEditorLandingPage();
    }

    @Override
    public void render(float delta) {
        this.app.getMusicPlayer().update(delta);
        if (!this.paused) {
            this.hudStage.act();
            this.updateOverride(delta);
        }
        if (!this.hidden) {
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            Gdx.gl.glClear(16384);
            this.hudStage.draw();
            this.renderOverride(delta);
        }
    }

    @Override
    public void dispose() {
    }
}

