/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.AsteroidFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.AsteroidGeneratorSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.AsteroidGeneratorSettingsRepository;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.AsteroidSettings;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.gfx.AsteroidGraphics;
import com.neutronio.astrax.gfx.AsteroidGraphicsFactory;
import com.neutronio.astrax.ui.ComponentFactory;

public class AsteroidGraphicsTest
extends DevScreenBase {
    ComponentFactory componentFactory;
    AsteroidGraphics graphics;
    AsteroidGraphics graphics2;

    public AsteroidGraphicsTest(AstraXApp game) {
        super(game);
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void updateOverride(float delta) {
        super.updateOverride(delta);
        if (Gdx.input.isKeyJustPressed(29)) {
            this.graphics.crackOpen();
        }
        if (Gdx.input.isKeyJustPressed(47)) {
            this.graphics.rumble();
        }
        if (Gdx.input.isKeyJustPressed(62)) {
            this.createAsteroid();
        }
    }

    private void createAsteroid() {
        AsteroidGeneratorSettingsRepository repository = AstraXApp.astraX.getRepository(AsteroidGeneratorSettingsRepository.class);
        AsteroidFactory asteroidFactory = AstraXApp.astraX.getFactoryByClass(AsteroidFactory.class);
        AsteroidGraphicsFactory asteroidGraphicsFactory = AstraXApp.astraX.getFactoryByClass(AsteroidGraphicsFactory.class);
        AsteroidGeneratorSettings randomGeneratedAsteroid = (AsteroidGeneratorSettings)AstraXApp.astraX.getCoreDataPack().getNumberGenerator().getRandomEntry(repository.all());
        AsteroidSettings asteroidSettings = asteroidFactory.generate(randomGeneratedAsteroid);
        if (this.graphics != null) {
            this.graphics.remove();
        }
        this.graphics = asteroidGraphicsFactory.create(asteroidSettings);
        this.graphics.setPosition(200.0f, 200.0f);
        this.graphics.setSize(64.0f, 64.0f);
        this.hudStage.addActor(this.graphics);
        this.logger.fine("Created asteroid: " + randomGeneratedAsteroid.id);
    }

    @Override
    public void renderOverride(float delta) {
        super.renderOverride(delta);
    }

    @Override
    public void create() {
        super.create();
        this.componentFactory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
        this.createAsteroid();
    }
}

