/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.ui.ComponentFactory;

public class BackgroundPanelTest
extends DevScreenBase {
    String[] skinColors = new String[]{"primary", "primary-bright", "primary-dark", "secondary", "secondary-bright", "secondary-dark", "affirmative", "affirmative-bright", "affirmative-dark", "cancel", "cancel-bright", "cancel-dark", "disabled"};
    int currentColor = 0;
    Image image;
    ComponentFactory componentFactory;

    public BackgroundPanelTest(AstraXApp game) {
        super(game);
    }

    @Override
    public void updateOverride(float delta) {
        super.updateOverride(delta);
        if (Gdx.input.isKeyJustPressed(29)) {
            this.currentColor = MathUtils.clamp(this.currentColor - 1, 0, this.skinColors.length - 1);
            this.image.setColor(this.componentFactory.getSkin().getColor(this.skinColors[this.currentColor]));
        }
        if (Gdx.input.isKeyJustPressed(32)) {
            this.currentColor = MathUtils.clamp(this.currentColor + 1, 0, this.skinColors.length - 1);
            this.image.setColor(this.componentFactory.getSkin().getColor(this.skinColors[this.currentColor]));
        }
    }

    @Override
    public void renderOverride(float delta) {
        super.renderOverride(delta);
    }

    @Override
    public void create() {
        super.create();
        this.componentFactory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
        this.image = new Image(this.componentFactory.getSkin().getPatch("panel_inset"));
        this.image.setSize(300.0f, 300.0f);
        this.image.setOrigin(1);
        this.image.setColor(this.componentFactory.getSkin().getColor("secondary"));
        this.image.setPosition((float)Gdx.graphics.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f);
        this.hudStage.addActor(this.image);
    }
}

