/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.TargetSorter;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.gfx.AstraXRenderContext;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.game.menu.TabbedGameMenu;
import com.neutronio.astrax.ui.hud.CenterHUD;

public class CentralHUDTest
extends DevScreenBase {
    float time = 0.0f;
    TabbedGameMenu tabbedGameMenu;
    CenterHUD hud;
    TargetSorter.Target followTarget;
    Stack planetStack;
    AstraXRenderContext astraXRenderContext;

    public CentralHUDTest(AstraXApp game) {
        super(game);
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void updateOverride(float delta) {
        super.updateOverride(delta);
        this.time += delta;
        this.hud.setSelfAngle(this.time * 100.0f);
        this.followTarget.setAngle((float)Math.cos(this.time) * 90.0f);
        this.followTarget.setDistance((float)Math.sin(3.0) * this.time);
        if (Gdx.input.isKeyJustPressed(29)) {
            this.hud.flare();
        }
    }

    @Override
    public void renderOverride(float delta) {
        super.renderOverride(delta);
        this.hudStage.getBatch().begin();
        this.hud.render(this.astraXRenderContext.getShapeDrawer(), delta);
        this.hud.draw(this.hudStage.getBatch());
        this.hudStage.getBatch().end();
    }

    @Override
    public void create() {
        super.create();
        this.planetStack = new Stack();
        this.planetStack.add(new Image());
        ComponentFactory factory = this.app.getAppFactoryByClass(ComponentFactory.class);
        this.hud = new CenterHUD(factory.getSkin());
        this.astraXRenderContext = new AstraXRenderContext(factory, this.getHudStage(), factory.getSkin().getRegion("star_1"));
        this.tabbedGameMenu = new TabbedGameMenu(factory, null);
        this.tabbedGameMenu.construct();
        this.followTarget = TargetSorter.newTarget(10.0f, 0.0f);
        TargetSorter.Target farTarget = TargetSorter.newTarget(1500.0f, 180.0f);
        this.hud.addTarget(this.followTarget);
        this.hud.addTarget(TargetSorter.newTarget(500.0f, 90.0f));
        this.hud.addTarget(farTarget);
        this.hud.setSelectedTarget(this.followTarget);
        this.hudStage.addActor(this.tabbedGameMenu);
    }
}

