/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.screen.AbstractScreen;
import com.neutronio.astrax.app.screen.MainMenuScreen;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.widgets.Header;

public class DevScreenBase
extends AbstractScreen {
    protected BitmapFont font;
    protected Header header;
    protected AstraXTextButton backButton;
    protected Stage worldStage = new Stage();

    protected DevScreenBase(AstraXApp game) {
        super(game);
    }

    @Override
    public void create() {
        ComponentFactory factory = this.app.getAppFactoryByClass(ComponentFactory.class);
        this.font = factory.getSkin().getFont("default");
        this.header = factory.getHeader(this.getClass().getSimpleName());
        this.header.setPosition(0.0f, (float)Gdx.graphics.getHeight() - this.header.getHeight());
        this.backButton = new AstraXTextButton(factory, "primary");
        this.backButton.setText("Back");
        this.backButton.setSize(this.backButton.getWidth() + 10.0f, 50.0f);
        this.backButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                DevScreenBase.this.app.setScreen(MainMenuScreen.class);
            }
        });
        this.hudStage.addActor(this.header);
        this.hudStage.addActor(this.backButton);
    }

    @Override
    public void render(float delta) {
        this.app.getMusicPlayer().update(delta);
        if (Gdx.input.isKeyJustPressed(141)) {
            this.hudStage.setDebugAll(!this.hudStage.isDebugAll());
        }
        if (!this.paused) {
            this.hudStage.act();
            this.worldStage.act();
            this.updateOverride(delta);
        }
        if (!this.hidden) {
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            Gdx.gl.glClear(16384);
            this.worldStage.draw();
            this.hudStage.draw();
            this.renderOverride(delta);
        }
    }

    @Override
    public void dispose() {
    }
}

