/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.screen.AbstractScreen;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.AstraXComponent;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.menu.Menu;
import java.util.logging.Logger;

public class DevScreenMenu
extends AstraXComponent {
    private static Logger logger = Logger.getLogger(DevScreenMenu.class.getCanonicalName());
    private Menu<AbstractScreen> screenTestMenu;
    private AstraXApp astraxApp;

    public DevScreenMenu(AstraXApp astraxApp, ComponentFactory componentFactory) {
        super(componentFactory);
        this.astraxApp = astraxApp;
        this.screenTestMenu = new Menu(componentFactory, "dev");
        int i2 = 1;
        for (DevScreenBase screen : astraxApp.getDevScreens()) {
            CustomAction switchScreen = CustomAction.get(new ScreenSwitch(screen, this.astraxApp));
            this.screenTestMenu.addButtonForChoice(switchScreen, screen.getClass().getSimpleName(), this.screenTestMenu.getStyle().buttonStyleName);
            if (i2 % 3 == 0) {
                this.screenTestMenu.row();
            }
            ++i2;
        }
        this.screenTestMenu.pack();
    }

    @Override
    public void construct() {
        this.clear();
        super.construct();
        this.add("Developer Menu").fill();
        this.row();
        this.add("Note these tests can crash. Will turn this onto a proper mod/developer tool one day.").fill();
        this.row();
        this.add("Click the plug button on the right again to hide this menu.").fill();
        this.row();
        this.add(this.screenTestMenu);
        this.pack();
    }

    private AstraXApp getAstraXGame() {
        return this.astraxApp;
    }

    static class ScreenSwitch
    implements Runnable {
        AbstractScreen screen = null;
        AstraXApp astraxApp = null;

        public ScreenSwitch(AbstractScreen screen, AstraXApp astraxApp) {
            this.screen = screen;
            this.astraxApp = astraxApp;
        }

        @Override
        public void run() {
            logger.fine("Switching menus...");
            this.screen.create();
            this.astraxApp.setScreen(this.screen.getClass());
        }
    }
}

