/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.Docking;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.gfx.SatelliteGraphics;
import com.neutronio.astrax.io.AstraXFiles;
import com.neutronio.astrax.io.BlueprintLoader;
import com.neutronio.astrax.io.FileHandler;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.widgets.Modal;
import com.neutronio.astrax.ui.files.FileDialog;
import com.neutronio.astrax.ui.files.FileDialogForm;
import java.io.IOException;

public class DockingTest
extends DevScreenBase {
    private FileDialogForm fileDialog;
    private Modal<FileDialogForm> fileDialogModal;
    private AstraXTextButton loadStationButton;
    private AstraXTextButton dockButton;
    private BlueprintLoader blueprintLoader = new BlueprintLoader();
    private SatelliteFactory satelliteFactory;
    private Docking docking;
    private SatelliteTarget stationTarget;
    private AstraXFiles.AstraXFile stationFile;
    private SatelliteGrid stationGrid;
    private SatelliteTarget playerTarget;

    public DockingTest(AstraXApp game) {
        super(game);
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void create() {
        super.create();
        this.satelliteFactory = this.getApp().getFactoryByClass(SatelliteFactory.class);
        SatelliteSettings craftSettings = new SatelliteSettings();
        craftSettings.name = "Player Spacecraft";
        craftSettings.fileLocation = new AstraXFiles.AstraXFile(null, "userdata/spacecraft/Driller.json", FileHandler.FileLocation.LOCAL);
        this.playerTarget = this.satelliteFactory.createTarget(craftSettings);
        ((SatelliteGraphics)this.playerTarget.getGraphics()).setPosition(200.0f, 200.0f);
        ComponentFactory componentFactory = this.getApp().getAppFactoryByClass(ComponentFactory.class);
        this.fileDialog = new FileDialogForm(componentFactory, "window-body");
        this.fileDialog.setMode(1);
        this.fileDialog.setOriginFolder("userdata/spacecraft");
        this.fileDialogModal = new Modal<FileDialogForm>(componentFactory, this.fileDialog);
        this.fileDialogModal.setHeaderText(componentFactory.translate("menu_newgame_spacecraft_load"));
        this.fileDialog.setListener(new FileDialog.FileDialogListener(){

            @Override
            public void onFileLoad(AstraXFiles.AstraXFile file) {
                if (file == null) {
                    return;
                }
                DockingTest.this.logger.fine("Loading spacecraft... ");
                try {
                    DockingTest.this.stationFile = file;
                    DockingTest.this.stationGrid = DockingTest.this.blueprintLoader.load(file);
                    DockingTest.this.stationTarget = DockingTest.this.satelliteFactory.createTarget("DockingTest", DockingTest.this.stationFile, DockingTest.this.stationGrid);
                    ((SatelliteGraphics)DockingTest.this.stationTarget.getGraphics()).setPosition((float)(Gdx.graphics.getWidth() / 2) - ((SatelliteGraphics)DockingTest.this.stationTarget.getGraphics()).getWidth() / 2.0f, (float)(Gdx.graphics.getHeight() / 2) - ((SatelliteGraphics)DockingTest.this.stationTarget.getGraphics()).getHeight() / 2.0f);
                    DockingTest.this.getHudStage().addActor((Actor)DockingTest.this.stationTarget.getGraphics());
                    DockingTest.this.fileDialogModal.hide();
                    DockingTest.this.dockButton.setDisabled(false);
                }
                catch (IOException e) {
                    DockingTest.this.logger.severe("Could not read Spacecraft");
                    e.printStackTrace();
                }
            }

            @Override
            public void onFileSaved(String basePath, String filename) {
                throw new UnsupportedOperationException("Not supposed to be called here!");
            }

            @Override
            public void onFileDelete(AstraXFiles.AstraXFile file) {
            }

            @Override
            public void onBack() {
                DockingTest.this.fileDialogModal.hide();
            }
        });
        this.docking = new Docking(null);
        this.getHudStage().addActor((Actor)this.playerTarget.getGraphics());
        VerticalGroup controlGroup = new VerticalGroup();
        controlGroup.space(10.0f);
        this.loadStationButton = new AstraXTextButton(componentFactory, "primary");
        this.loadStationButton.setText("Load Station");
        this.loadStationButton.setCanCheck(false);
        this.loadStationButton.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                DockingTest.this.fileDialogModal.show();
            }
        }));
        this.dockButton = new AstraXTextButton(componentFactory, "primary");
        this.dockButton.setText("Start Docking");
        this.dockButton.setDisabled(true);
        this.dockButton.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                DockingTest.this.docking.dock(DockingTest.this.stationTarget, DockingTest.this.playerTarget);
            }
        }));
        controlGroup.addActor(this.loadStationButton);
        controlGroup.addActor(this.dockButton);
        controlGroup.setPosition(10.0f, 70.0f);
        controlGroup.pack();
        this.hudStage.addActor(controlGroup);
        this.hudStage.addActor(this.fileDialogModal);
    }
}

