/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.io.AstraXFiles;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.forms.FormController;
import com.neutronio.astrax.ui.files.FileDialog;
import com.neutronio.astrax.ui.files.FileDialogForm;

public class FormContainerTest
extends DevScreenBase {
    ComponentFactory componentFactory;
    FormController<FileDialog> formController;
    private FormContainerTest formContainerTest;

    public FormContainerTest(AstraXApp game) {
        super(game);
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void updateOverride(float delta) {
        super.updateOverride(delta);
        if (Gdx.input.isKeyJustPressed(42)) {
            // empty if block
        }
        if (Gdx.input.isKeyJustPressed(41)) {
            // empty if block
        }
    }

    @Override
    public void renderOverride(float delta) {
        super.renderOverride(delta);
    }

    @Override
    public void create() {
        super.create();
        this.componentFactory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
        FileDialogForm form = new FileDialogForm(this.componentFactory, "window-body");
        form.setOriginFolder("userdata/spacecraft");
        form.setListener(new FileDialog.FileDialogListener(){

            @Override
            public void onFileLoad(AstraXFiles.AstraXFile file) {
                FormContainerTest.this.componentFactory.playUISound("chime");
            }

            @Override
            public void onFileSaved(String basePath, String filename) {
                FormContainerTest.this.componentFactory.playUISound("chime");
            }

            @Override
            public void onFileDelete(AstraXFiles.AstraXFile file) {
                FormContainerTest.this.componentFactory.playUISound("reward");
            }

            @Override
            public void onBack() {
                FormContainerTest.this.componentFactory.playUISound("dice1");
            }
        });
        form.setPosition((float)Gdx.graphics.getWidth() / 2.0f - form.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f - form.getHeight() / 2.0f);
        this.hudStage.addActor(form);
    }
}

