/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyTypeRepository;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyTypeSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.StarSystemBackgroundFactory;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.gfx.bg.StarSystemBackgroundGraphics;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.util.collections.DefaultSelector;

public class GalaxyBackgroundTest
extends DevScreenBase {
    Label typeValue;
    StarSystemBackgroundFactory starSystemBackgroundFactory;
    StarSystemBackgroundGraphics backgroundGraphics;
    DefaultSelector<GalaxyTypeSettings> galaxySelector;

    public GalaxyBackgroundTest(AstraXApp game) {
        super(game);
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void updateOverride(float delta) {
        super.updateOverride(delta);
        if (Gdx.input.isKeyJustPressed(133)) {
            this.worldStage.setDebugAll(!this.worldStage.isDebugAll());
        }
        if (Gdx.input.isKeyJustPressed(62)) {
            this.recreateBackground();
        }
        if (Gdx.input.isKeyJustPressed(29)) {
            this.galaxySelector.previousElement();
            this.typeValue.setText(this.galaxySelector.getSelected().galaxyClass.getDisplayName());
            this.recreateBackground();
        }
        if (Gdx.input.isKeyJustPressed(32)) {
            this.galaxySelector.nextElement();
            this.typeValue.setText(this.galaxySelector.getSelected().galaxyClass.getDisplayName());
            this.recreateBackground();
        }
    }

    private void recreateBackground() {
        if (this.backgroundGraphics != null) {
            this.backgroundGraphics.remove();
        }
        this.backgroundGraphics = this.starSystemBackgroundFactory.createBackground(1000.0f, this.galaxySelector.getSelected().defaultBackgroundSettings);
        this.backgroundGraphics.toBack();
        this.backgroundGraphics.setScale(0.5f);
        this.backgroundGraphics.setPosition((float)Gdx.graphics.getWidth() / 2.0f - this.backgroundGraphics.getWidth() * this.backgroundGraphics.getScaleX(), (float)Gdx.graphics.getHeight() / 2.0f - this.backgroundGraphics.getHeight() * this.backgroundGraphics.getScaleY());
        this.worldStage.addActor(this.backgroundGraphics);
    }

    @Override
    public void create() {
        super.create();
        ComponentFactory componentFactory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
        this.typeValue = new Label((CharSequence)"-", componentFactory.getSkin());
        this.typeValue.setPosition(50.0f, 20.0f);
        this.hudStage.addActor(this.typeValue);
        this.starSystemBackgroundFactory = AstraXApp.astraX.getFactoryByClass(StarSystemBackgroundFactory.class);
        this.galaxySelector = new DefaultSelector();
        this.galaxySelector.setElements(AstraXApp.astraX.getRepository(GalaxyTypeRepository.class).all());
        this.galaxySelector.select(0);
    }
}

