/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.DataPack;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyRegionRepository;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyRegionSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.StarSystemBackgroundFactory;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.gfx.bg.StarSystemBackgroundGraphics;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import java.util.List;

public class GalaxyRegionTest
extends DevScreenBase {
    GalaxyRegionSettings currentRegion;
    StarSystemBackgroundGraphics backgroundGraphics;
    StarSystemBackgroundFactory starSystemBackgroundFactory;

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    private void recreateBackground() {
        if (this.backgroundGraphics != null) {
            this.backgroundGraphics.remove();
        }
        this.backgroundGraphics = this.starSystemBackgroundFactory.createBackground(1000.0f, this.currentRegion.backgroundSettings);
        this.backgroundGraphics.toBack();
        this.backgroundGraphics.setScale(0.5f);
        this.backgroundGraphics.setPosition((float)Gdx.graphics.getWidth() / 2.0f - this.backgroundGraphics.getWidth() * this.backgroundGraphics.getScaleX(), (float)Gdx.graphics.getHeight() / 2.0f - this.backgroundGraphics.getHeight() * this.backgroundGraphics.getScaleY());
        this.worldStage.addActor(this.backgroundGraphics);
    }

    public GalaxyRegionTest(AstraXApp game) {
        super(game);
        ComponentFactory componentFactory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
        DataPack coreDataPack = AstraXApp.astraX.getCoreDataPack();
        this.starSystemBackgroundFactory = AstraXApp.astraX.getFactoryByClass(StarSystemBackgroundFactory.class);
        GalaxyRegionRepository repository = AstraXApp.astraX.getRepository(GalaxyRegionRepository.class);
        List regions = repository.all();
        Table buttons = new Table();
        for (final GalaxyRegionSettings region : regions) {
            AstraXTextButton textButton = new AstraXTextButton(componentFactory, "primary");
            textButton.setText(region.typeName);
            textButton.setCanCheck(false);
            textButton.setButtonAction(CustomAction.get(new Runnable(){

                @Override
                public void run() {
                    GalaxyRegionTest.this.currentRegion = region;
                    GalaxyRegionTest.this.recreateBackground();
                }
            }));
            buttons.add(textButton);
            buttons.row();
        }
        buttons.pack();
        this.hudStage.addActor(buttons);
    }
}

