/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Color;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.gfx.AstraXRenderContext;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.hud.Gauge;

public class GaugeTest
extends DevScreenBase {
    Gauge gauge;
    Gauge oxygen;
    AstraXRenderContext astraXRenderContext;

    public GaugeTest(AstraXApp game) {
        super(game);
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void updateOverride(float delta) {
        super.updateOverride(delta);
        if (Gdx.input.isKeyJustPressed(8)) {
            this.gauge.setNeedleValue("default", (float)Math.random());
            this.gauge.setNeedleValue("consumption", (float)Math.random());
            this.oxygen.setNeedleValue("stored", (float)Math.random());
        }
    }

    @Override
    public void renderOverride(float delta) {
        super.renderOverride(delta);
        this.hudStage.getBatch().end();
    }

    @Override
    public void create() {
        super.create();
        ComponentFactory componentFactory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
        this.astraXRenderContext = new AstraXRenderContext(componentFactory, this.getHudStage(), componentFactory.getSkin().getRegion("star_1"));
        this.gauge = new Gauge(componentFactory, "icon_resource_water", 70.0f);
        this.gauge.setShapeDrawer(this.astraXRenderContext.getShapeDrawer());
        this.gauge.setColor(Color.TEAL);
        this.gauge.addNeedle("default", 16.0f, 65.0f, Color.GREEN, Color.YELLOW);
        this.gauge.addNeedle("consumption", 16.0f, 45.0f, Color.CYAN, Color.MAGENTA);
        this.gauge.getNeedle("default").setBaseValue(3000.0f);
        this.gauge.getNeedle("default").setBlinkSound("alert1");
        this.gauge.getNeedle("default").setBlinkInterval(1.5f);
        this.gauge.getNeedle("default").setBlinkingEnabled(true);
        this.gauge.getNeedle("consumption").setDrawValue(false);
        this.gauge.getNeedle("consumption").setBaseValue(100.0f);
        this.gauge.getNeedle("consumption").setBlinkingEnabled(false);
        this.gauge.customizeMarkers("", "", "3000");
        this.gauge.setPosition(300.0f, 250.0f);
        this.gauge.setDisplayedNeedle("default");
        this.hudStage.addActor(this.gauge);
        this.oxygen = new Gauge(componentFactory, "icon_resource_oxygen", 60.0f);
        this.oxygen.setShapeDrawer(this.astraXRenderContext.getShapeDrawer());
        this.oxygen.setColor(componentFactory.getSkin().getColor("secondary-bright"));
        this.oxygen.addNeedle("stored", 16.0f, 60.0f, componentFactory.getSkin().getColor("info-bright"), componentFactory.getSkin().getColor("tertiary"));
        this.oxygen.setDisplayedNeedle("stored");
        this.oxygen.getNeedle("stored").setBaseValue(3000.0f);
        this.oxygen.setPosition(460.0f, 250.0f);
        this.hudStage.addActor(this.oxygen);
    }
}

