/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.gfx.entities.GraphicsContainer;
import com.neutronio.astrax.gfx.entities.PlanetGraphics;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.text.TextSelector;
import com.neutronio.astrax.ui.game.menu.StarMap;

public class GraphicsContainerTest
extends DevScreenBase {
    private int count = 0;
    private SpriteBatch planetBatch;
    private TextureRegionDrawable drawable;
    private PlanetGraphics planetGraphics;
    private PlanetGraphics planetGraphicsCopy;
    private GraphicsContainer<PlanetGraphics> gfxContainer;
    private TextSelector selector;
    private StarMap starMap;

    public GraphicsContainerTest(AstraXApp game) {
        super(game);
    }

    @Override
    public void create() {
        super.create();
        ComponentFactory factory = this.app.getAppFactoryByClass(ComponentFactory.class);
        Skin skin = factory.getSkin();
        this.hudStage.setDebugAll(true);
        this.selector = new TextSelector(factory);
        this.selector.setPosition(120.0f, 300.0f);
        this.starMap = new StarMap(factory);
        this.starMap.setPosition((float)Gdx.graphics.getWidth() / 2.0f - this.starMap.getWidth() / 2.0f, 50.0f);
        this.planetBatch = new SpriteBatch(30);
        this.planetGraphics = new PlanetGraphics();
        this.planetGraphics.addStaticImage(skin.getAtlas().findRegion("targetType_satellite_up"), new Color(1.0f, 1.0f, 1.0f, 0.5f), 0.0f, 0);
        this.planetGraphics.addStaticImage(skin.getAtlas().findRegion("targetType_asteroid_up"), new Color(1.0f, 1.0f, 1.0f, 0.5f), 24.0f, 1);
        this.planetGraphicsCopy = this.planetGraphics;
        this.gfxContainer = new GraphicsContainer();
        this.gfxContainer.setGraphics(this.planetGraphics);
        this.gfxContainer.setPosition(300.0f, 100.0f);
        this.gfxContainer.setSize(150.0f, 150.0f);
        this.gfxContainer.setRotation(45.0f);
        this.drawable = new TextureRegionDrawable();
        this.drawable.setRegion(skin.getAtlas().findRegion("icon_info"));
        this.hudStage.addActor(this.gfxContainer);
        this.hudStage.addActor(this.starMap);
        this.hudStage.addActor(this.selector);
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void updateOverride(float delta) {
        ++this.count;
    }

    @Override
    public void renderOverride(float delta) {
        super.renderOverride(delta);
        this.planetBatch.begin();
        this.drawable.draw(this.planetBatch, 100.0f, 100.0f, 0.0f, 0.0f, 24.0f, 24.0f, 1.0f, 1.0f, this.count);
        this.drawable.draw(this.planetBatch, 150.0f, 100.0f, 12.0f, 12.0f, 24.0f, 24.0f, 2.0f, 2.0f, this.count);
        this.planetBatch.end();
    }

    @Override
    public void dispose() {
    }
}

