/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Galaxy;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxySettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyTypeRepository;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyTypeSettings;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.gfx.AstraXRenderContext;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.game.menu.map.galaxy.GalaxyMap;

public class InteractiveGalaxyMapTest
extends DevScreenBase {
    private ComponentFactory componentFactory;
    private Galaxy galaxy;
    private GalaxyMap galaxyMap;

    public InteractiveGalaxyMapTest(AstraXApp game) {
        super(game);
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void render(float delta) {
        super.render(delta);
    }

    @Override
    public void create() {
        this.componentFactory = this.getApp().getAppFactoryByClass(ComponentFactory.class);
        AstraXRenderContext renderContext = new AstraXRenderContext(this.componentFactory, this.hudStage, this.componentFactory.getSkin().getRegion("star_1"));
        this.componentFactory.setUiRenderContext(renderContext);
        GalaxyFactory galaxyFactory = this.getApp().getFactoryByClass(GalaxyFactory.class);
        GalaxyTypeRepository repository = this.getApp().getRepository(GalaxyTypeRepository.class);
        GalaxySettings settings = new GalaxySettings((GalaxyTypeSettings)repository.find("galaxy_spiral_barred"));
        settings.galaxyName = "Test";
        settings.starterRegion = "galaxyRegion_home";
        settings.starterSystem = "solarsystem_sol";
        settings.xSectorStartPos = 0;
        settings.ySectorStartPos = 0;
        this.galaxy = galaxyFactory.create(settings);
        this.galaxyMap = new GalaxyMap(this.componentFactory, null);
        this.galaxyMap.setGalaxy(this.galaxy);
        for (int x = 0; x < 25; ++x) {
            for (int y = 0; y < 10; ++y) {
                this.galaxyMap.getGalaxyMapCanvas().markSystemAsVisited(x + 59, y + 60);
            }
        }
        this.galaxyMap.setPosition(200.0f, 200.0f);
        this.hudStage.addActor(this.galaxyMap);
        Gdx.input.setInputProcessor(this.hudStage);
        this.hudStage.setKeyboardFocus(this.galaxyMap.getGalaxyMapCanvas());
    }
}

