/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.CargoSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Item;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.MultiStackInventory;
import com.neutronio.astrax.app.repository.ResourceRepository;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.game.inventory.InventoryPanel;

public class InventoryPanelTest
extends DevScreenBase {
    ComponentFactory componentFactory;
    InventoryPanel inventoryPanel;

    public InventoryPanelTest(AstraXApp game) {
        super(game);
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void updateOverride(float delta) {
        super.updateOverride(delta);
    }

    @Override
    public void renderOverride(float delta) {
        super.renderOverride(delta);
    }

    @Override
    public void create() {
        super.create();
        CargoSettings cargoSettings = new CargoSettings();
        cargoSettings.maxWeight = 100.0f;
        Resource oxygen = (Resource)AstraXApp.astraX.getRepository(ResourceRepository.class).find("resource_oxygen");
        Resource fuel = (Resource)AstraXApp.astraX.getRepository(ResourceRepository.class).find("resource_rocketFuel");
        MultiStackInventory<Resource> inventory = new MultiStackInventory<Resource>(100.0f);
        inventory.add(new Item().withIcon("icon_goat").withName("Oxygen").withBasePrice(5.0f).withAmount(20.0f).withWeight(oxygen.getWeight()).withObject(oxygen));
        inventory.add(new Item().withIcon("icon_goat").withName("Oxygen").withBasePrice(5.0f).withAmount(34.0f).withWeight(oxygen.getWeight()).withObject(oxygen));
        inventory.add(new Item().withIcon("icon_resource_ingot_large").withName("Fuel").withBasePrice(3.0f).withAmount(25.0f).withWeight(fuel.getWeight()).withObject(fuel));
        this.componentFactory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
        this.inventoryPanel = new InventoryPanel(this.componentFactory);
        this.inventoryPanel.updateWith(inventory);
        this.inventoryPanel.setPosition((float)Gdx.graphics.getWidth() / 2.0f - this.inventoryPanel.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f - this.inventoryPanel.getHeight() / 2.0f);
        this.hudStage.addActor(this.inventoryPanel);
    }
}

