/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.app.datapack.game.Trader;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.ItemGenerationSettings;
import com.neutronio.astrax.app.datapack.game.world.NPCFactory;
import com.neutronio.astrax.app.datapack.game.world.NPCTrader;
import com.neutronio.astrax.app.datapack.game.world.galaxy.MerchantCreationSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.MerchantGenerationSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.InventoryUtils;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.MultiStackInventory;
import com.neutronio.astrax.app.repository.ResourceRepository;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.io.json.game.JSONToMerchantGenerationSettings;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.buttons.Button;
import com.neutronio.astrax.ui.commons.forms.GenericFormContainer;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.tab.FlexTab;
import com.neutronio.astrax.ui.commons.widgets.MessageLog;
import com.neutronio.astrax.ui.commons.widgets.StackController;
import com.neutronio.astrax.ui.game.trade.BuyForm;
import com.neutronio.astrax.ui.game.trade.SellForm;
import com.neutronio.astrax.util.animation.Tweening;
import com.neutronio.astrax.util.collections.ProbabilitySet;
import com.neutronio.astrax.util.dummy.DummyTrader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.json.JSONObject;

public class MerchantTest
extends DevScreenBase {
    static String JSON = "{\n    \"nameGenPattern\": [\n      \"size-large trader-names\",\n      \"size-small trader-names\",\n      \"trader-prefix spacecraft-names\",\n      \"trader-prefix trader-names\",\n      \"metal trader-names\"\n    ],\n    \"minStarterMoney\": 2000,\n    \"maxStarterMoney\": 3500,\n    \"minSellPriceModifier\": 0.95,\n    \"maxSellPriceModifier\": 1.3,\n    \"minBuyPriceModifier\": 0.8,\n    \"maxBuyPriceModifier\": 1.1,\n    \"sellItems\": {\n      \"entries\": [\n        { \"weight\": 100, \"object\": { \"resourceID\": \"resource_oxygen\", \"maxAmount\": 1500, \"minAmount\": 500 } },\n        { \"weight\": 100, \"object\": { \"resourceID\": \"resource_rocketFuel\", \"maxAmount\": 1500, \"minAmount\": 500 } },\n        { \"weight\": 30, \"object\": { \"resourceID\": \"scrapMetal\", \"maxAmount\": 200, \"minAmount\": 50 } },\n        { \"weight\": 10, \"object\": { \"resourceID\": \"magnetite\", \"maxAmount\": 100, \"minAmount\": 10 } },\n        { \"weight\": 10, \"object\": { \"resourceID\": \"hematite\", \"maxAmount\": 100, \"minAmount\": 10 } },\n        { \"weight\": 10, \"object\": { \"resourceID\": \"tetrahedrite\", \"maxAmount\": 100, \"minAmount\": 10 } },\n        { \"weight\": 10, \"object\": { \"resourceID\": \"chalcopyrite\", \"maxAmount\": 100, \"minAmount\": 10 } },\n        { \"weight\": 6, \"object\": { \"resourceID\": \"silver\", \"maxAmount\": 100, \"minAmount\": 10 } }\n      ]\n    },\n    \"buyItems\": {\n      \"entries\": [\n        { \"weight\": 100, \"id\": \"resource_oxygen\" },\n        { \"weight\": 100, \"id\": \"resource_rocketFuel\" },\n        { \"weight\": 80, \"id\": \"magnetite\" },\n        { \"weight\": 80, \"id\": \"hematite\" },\n        { \"weight\": 50, \"id\": \"scrapMetal\" },\n        { \"weight\": 15, \"id\": \"tetrahedrite\" },\n        { \"weight\": 15, \"id\": \"chalcopyrite\" },\n        { \"weight\": 10, \"id\": \"gold\" },\n        { \"weight\": 10, \"id\": \"silver\" },\n        { \"weight\": 5, \"id\": \"basalt\" },\n        { \"weight\": 5, \"id\": \"granite\" }\n      ]\n    }\n  }";
    ComponentFactory componentFactory;
    FlexTab mainTab;
    MessageLog messageLog;
    MerchantGenerationSettings defaultMerchant;

    public MerchantTest(AstraXApp game) {
        super(game);
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void updateOverride(float delta) {
        super.updateOverride(delta);
    }

    @Override
    public void renderOverride(float delta) {
        super.renderOverride(delta);
    }

    private List<Message> doFunctionalTest() {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(new Message(Message.MessageType.INFO, "Creating Merchant Generator Data... "));
        NPCFactory merchantFactory = AstraXApp.astraX.getFactoryByClass(NPCFactory.class);
        merchantFactory.setSeed(new Random().nextLong());
        messages.add(new Message(Message.MessageType.INFO, "Generate Merchant... "));
        MerchantCreationSettings creationSettings = null;
        try {
            creationSettings = merchantFactory.generate(this.defaultMerchant);
        }
        catch (Exception e) {
            e.printStackTrace();
            messages.add(new Message(Message.MessageType.EXCEPTION, "An Error occurred! See the log for details."));
            messages.add(new Message(Message.MessageType.EXCEPTION, e.getMessage()));
            messages.add(new Message(Message.MessageType.INFO, "Test aborted."));
            return messages;
        }
        messages.add(new Message(Message.MessageType.INFO, "Instancing Merchant... "));
        NPCTrader merchant = null;
        try {
            merchant = merchantFactory.create(creationSettings);
        }
        catch (Exception e) {
            e.printStackTrace();
            messages.add(new Message(Message.MessageType.EXCEPTION, "An Error occurred! See the log for details."));
            messages.add(new Message(Message.MessageType.EXCEPTION, e.getMessage()));
            messages.add(new Message(Message.MessageType.INFO, "Test aborted."));
            return messages;
        }
        messages.add(new Message(Message.MessageType.INFO, "Try to Convert JSON... "));
        try {
            JSONObject merchantJSON = new JSONObject(JSON);
            JSONToMerchantGenerationSettings merchantConverter = AstraXApp.astraX.getRepositoryFactory().getDataManager().getConverter(JSONToMerchantGenerationSettings.class);
            MerchantGenerationSettings merchantGenerationSettings = merchantConverter.convert(merchantJSON.toMap());
        }
        catch (Exception e) {
            e.printStackTrace();
            messages.add(new Message(Message.MessageType.EXCEPTION, "An Error occurred! See the log for details."));
            messages.add(new Message(Message.MessageType.EXCEPTION, e.getMessage()));
            messages.add(new Message(Message.MessageType.INFO, "Test aborted."));
            return messages;
        }
        messages.add(new Message(Message.MessageType.SUCCESS, "Test Passed!"));
        return messages;
    }

    private SimplePanel createFunctionalTestGUI() {
        SimplePanel devPanel = new SimplePanel(this.componentFactory);
        devPanel.addLabel("This is a functional test of Merchant Factory conversions.\nOutput is shown below. Press the button to start.", 2);
        devPanel.row();
        AstraXTextButton startButton = new AstraXTextButton(this.componentFactory, "primary");
        startButton.setText("Start");
        startButton.setCanCheck(false);
        startButton.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                List messages = MerchantTest.this.doFunctionalTest();
                MerchantTest.this.messageLog.addMessages(messages);
                MerchantTest.this.messageLog.update();
                MerchantTest.this.messageLog.pack();
                MerchantTest.this.mainTab.getContentStack().pack();
            }
        }));
        devPanel.addValue(startButton);
        AstraXTextButton clearButton = new AstraXTextButton(this.componentFactory, "primary");
        clearButton.setText("Clear Log");
        clearButton.setCanCheck(false);
        clearButton.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                MerchantTest.this.messageLog.clearMessages();
                MerchantTest.this.messageLog.update();
                MerchantTest.this.messageLog.pack();
                MerchantTest.this.mainTab.getContentStack().pack();
            }
        }));
        devPanel.addValue(clearButton);
        devPanel.row();
        this.messageLog = new MessageLog(this.componentFactory, null, 10);
        this.messageLog.setShowTimestamps(true);
        this.messageLog.construct();
        devPanel.addValue(this.messageLog, 2);
        devPanel.pack();
        return devPanel;
    }

    private Group createBuyGUI(Trader player, NPCTrader merchant) {
        BuyForm buyForm = new BuyForm(this.componentFactory);
        GenericFormContainer<BuyForm> buyFormContainer = GenericFormContainer.createFormContainer(this.componentFactory, buyForm, null, "form_reset", "form_submit");
        buyFormContainer.getForm().setMerchant(merchant);
        buyFormContainer.getForm().setPlayer(player);
        buyFormContainer.getForm().update();
        return buyFormContainer;
    }

    private Group createSellGUI(Trader player, NPCTrader merchant) {
        SellForm sellForm = new SellForm(this.componentFactory);
        GenericFormContainer<SellForm> sellFormContainer = GenericFormContainer.createFormContainer(this.componentFactory, sellForm, null, "form_reset", "form_submit");
        sellFormContainer.getForm().setMerchant(merchant);
        sellFormContainer.getForm().setPlayer(player);
        sellFormContainer.getForm().update();
        return sellFormContainer;
    }

    @Override
    public void create() {
        super.create();
        this.defaultMerchant = new MerchantGenerationSettings();
        this.defaultMerchant.nameGenPattern.add("size-large trader-names");
        this.defaultMerchant.nameGenPattern.add("size-small trader-names");
        this.defaultMerchant.nameGenPattern.add("trader-prefix spacecraft-names");
        this.defaultMerchant.nameGenPattern.add("trader-prefix trader-names");
        this.defaultMerchant.nameGenPattern.add("metal trader-names");
        this.defaultMerchant.maxBuyPriceModifier = 1.1f;
        this.defaultMerchant.minBuyPriceModifier = 0.8f;
        this.defaultMerchant.maxSellPriceModifier = 1.3f;
        this.defaultMerchant.minSellPriceModifier = 0.95f;
        this.defaultMerchant.maxStarterMoney = 6000.0f;
        this.defaultMerchant.minStarterMoney = 2000.0f;
        this.defaultMerchant.traderTypeName = "Ore Trader";
        this.defaultMerchant.buyItems = new ProbabilitySet();
        this.defaultMerchant.buyItems.addProbability("resource_oxygen", 100.0f);
        this.defaultMerchant.buyItems.addProbability("resource_rocketFuel", 100.0f);
        this.defaultMerchant.buyItems.addProbability("magnetite", 80.0f);
        this.defaultMerchant.buyItems.addProbability("hematite", 80.0f);
        this.defaultMerchant.buyItems.addProbability("scrapMetal", 50.0f);
        this.defaultMerchant.buyItems.addProbability("tetrahedrite", 15.0f);
        this.defaultMerchant.buyItems.addProbability("chalcopyrite", 15.0f);
        this.defaultMerchant.buyItems.addProbability("gold", 10.0f);
        this.defaultMerchant.buyItems.addProbability("silver", 10.0f);
        this.defaultMerchant.buyItems.addProbability("basalt", 5.0f);
        this.defaultMerchant.buyItems.addProbability("granite", 5.0f);
        this.defaultMerchant.sellItems = new ProbabilitySet();
        this.defaultMerchant.sellItems.addProbability(new ItemGenerationSettings("resource_oxygen", 1500.0f, 500.0f), 100.0f);
        this.defaultMerchant.sellItems.addProbability(new ItemGenerationSettings("resource_rocketFuel", 1500.0f, 500.0f), 100.0f);
        this.defaultMerchant.sellItems.addProbability(new ItemGenerationSettings("scrapMetal", 200.0f, 50.0f), 30.0f);
        this.defaultMerchant.sellItems.addProbability(new ItemGenerationSettings("magnetite", 100.0f, 10.0f), 10.0f);
        this.defaultMerchant.sellItems.addProbability(new ItemGenerationSettings("hematite", 100.0f, 10.0f), 10.0f);
        this.defaultMerchant.sellItems.addProbability(new ItemGenerationSettings("tetrahedrite", 100.0f, 10.0f), 10.0f);
        this.defaultMerchant.sellItems.addProbability(new ItemGenerationSettings("chalcopyrite", 100.0f, 10.0f), 10.0f);
        this.defaultMerchant.sellItems.addProbability(new ItemGenerationSettings("silver", 100.0f, 50.0f), 6.0f);
        ResourceRepository repository = AstraXApp.astraX.getRepository(ResourceRepository.class);
        MultiStackInventory<Resource> playerInventory = new MultiStackInventory<Resource>(2.0f);
        playerInventory.add(InventoryUtils.resourceToItem((Resource)repository.find("scrapMetal"), 3.0f));
        playerInventory.add(InventoryUtils.resourceToItem((Resource)repository.find("magnetite"), 7.0f));
        playerInventory.add(InventoryUtils.resourceToItem((Resource)repository.find("hematite"), 10.0f));
        playerInventory.add(InventoryUtils.resourceToItem((Resource)repository.find("tetrahedrite"), 30.0f));
        playerInventory.add(InventoryUtils.resourceToItem((Resource)repository.find("chalcopyrite"), 26.0f));
        playerInventory.add(InventoryUtils.resourceToItem((Resource)repository.find("silver"), 6.0f));
        playerInventory.add(InventoryUtils.resourceToItem((Resource)repository.find("tellurite"), 2.0f));
        playerInventory.add(InventoryUtils.resourceToItem((Resource)repository.find("calaverite"), 7.6f));
        playerInventory.add(InventoryUtils.resourceToItem((Resource)repository.find("arsenopyrite"), 3.2f));
        playerInventory.addWithRemainder(InventoryUtils.resourceToItem((Resource)repository.find("gold"), 10.0f));
        NPCFactory merchantFactory = AstraXApp.astraX.getFactoryByClass(NPCFactory.class);
        merchantFactory.setSeed(new Random().nextLong());
        MerchantCreationSettings creationSettings = merchantFactory.generate(this.defaultMerchant);
        NPCTrader merchant = merchantFactory.create(creationSettings);
        DummyTrader playerTrader = new DummyTrader("Player", 2000.0f, 100.0f);
        playerTrader.setInventory(playerInventory);
        this.componentFactory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
        this.mainTab = new FlexTab(this.componentFactory);
        this.mainTab.addTabWithTextButton("Functional Test", "secondary", this.createFunctionalTestGUI());
        this.mainTab.addTabWithTextButton("Sell GUI Test", "secondary", this.createSellGUI(playerTrader, merchant));
        this.mainTab.addTabWithTextButton("Buy GUI Test", "secondary", this.createBuyGUI(playerTrader, merchant));
        this.mainTab.pack();
        this.mainTab.getStackController().setHideActionProducer(new StackController.ActionProducer(){

            @Override
            public Action createAction() {
                return Tweening.getDefaultFadeOut(0.5f);
            }
        });
        this.mainTab.getStackController().setShowActionProducer(new StackController.ActionProducer(){

            @Override
            public Action createAction() {
                return Tweening.getDefaultFadeIn(1.0f);
            }
        });
        HorizontalGroup buttonGroup = new HorizontalGroup();
        buttonGroup.space(10.0f);
        for (Button button : this.mainTab.getTabButtons()) {
            buttonGroup.addActor((Actor)((Object)button));
        }
        buttonGroup.pack();
        buttonGroup.setPosition(10.0f, (float)Gdx.graphics.getHeight() - buttonGroup.getHeight() - 70.0f);
        Container<Stack> stackContainer = new Container<Stack>(this.mainTab.getContentStack());
        stackContainer.size(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        stackContainer.center();
        stackContainer.setPosition((float)Gdx.graphics.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f);
        this.hudStage.addActor(stackContainer);
        this.hudStage.addActor(buttonGroup);
    }
}

