/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.RepositoryFactory;
import com.neutronio.astrax.app.datapack.DataPackFactory;
import com.neutronio.astrax.app.repository.AnimatedParticleEmitterRepository;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.gfx.AnimatedParticleEmitterSettings;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.widgets.RepositoryCRUDComponent;
import com.neutronio.astrax.ui.test.ParticleSelectPanel;

public class ParticleTest
extends DevScreenBase {
    RepositoryFactory io;
    ParticleSelectPanel particleSelectPanel;
    RepositoryCRUDComponent crudComponent;

    public ParticleTest(AstraXApp game) {
        super(game);
    }

    @Override
    public void renderOverride(float delta) {
        super.renderOverride(delta);
    }

    @Override
    public void updateOverride(float delta) {
        super.updateOverride(delta);
        if (Gdx.input.isKeyJustPressed(32)) {
            this.getClass();
        }
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void create() {
        DataPackFactory dataPackFactory = AstraXApp.astraX.getAppFactoryByClass(DataPackFactory.class);
        AnimatedParticleEmitterRepository repository = AstraXApp.astraX.getRepository(AnimatedParticleEmitterRepository.class);
        ComponentFactory componentFactory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
        this.io = AstraXApp.astraX.getRepositoryFactory();
        this.particleSelectPanel = new ParticleSelectPanel(componentFactory);
        this.hudStage.addActor(this.particleSelectPanel);
        this.crudComponent = new RepositoryCRUDComponent(componentFactory);
        this.crudComponent.setRepository(repository);
        this.crudComponent.setProducer(new RepositoryCRUDComponent.RepositoryProducer<AnimatedParticleEmitterSettings>(){

            @Override
            public AnimatedParticleEmitterSettings create() {
                AnimatedParticleEmitterSettings settings = new AnimatedParticleEmitterSettings();
                settings.id = "new";
                return settings;
            }

            @Override
            public void onEdit(AnimatedParticleEmitterSettings object) {
                ParticleTest.this.particleSelectPanel.setEmitterSettings(object);
            }

            @Override
            public void saveAs() {
                AnimatedParticleEmitterRepository repository = AstraXApp.astraX.getRepository(AnimatedParticleEmitterRepository.class);
                ParticleTest.this.io.save(repository, "", "particleTest", true);
            }
        });
        this.crudComponent.setPosition((float)Gdx.graphics.getWidth() - this.crudComponent.getWidth(), (float)Gdx.graphics.getHeight() / 2.0f - this.crudComponent.getHeight() / 2.0f);
        this.hudStage.addActor(this.crudComponent);
        super.create();
    }
}

