/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Box2DDebugRenderer;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.World;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.PhysicsFactory;
import com.neutronio.astrax.app.datapack.game.world.PhysicsSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.EllipsoidOrbit;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.util.MathUtil;

public class PhysicsTest
extends DevScreenBase {
    World physicsWorld;
    PhysicsFactory physicsFactory;
    Box2DDebugRenderer debugRenderer = new Box2DDebugRenderer();
    private float accumulator = 0.0f;
    private float systemTime = 0.0f;
    private float TIME_STEP = 0.016666668f;
    private int VELOCITY_ITERATIONS = 2;
    private int POSITION_ITERATIONS = 2;
    EllipsoidOrbit ellipsoidOrbit;
    EllipsoidOrbit starOrbit;
    Body starBody;
    Body planetBody;
    Body playerBody;

    private void doPhysicsStep(float deltaTime) {
        float frameTime = Math.min(deltaTime, 0.25f);
        this.accumulator += frameTime;
        this.systemTime += frameTime;
        while (this.accumulator >= this.TIME_STEP) {
            this.physicsWorld.step(this.TIME_STEP, this.VELOCITY_ITERATIONS, this.POSITION_ITERATIONS);
            this.accumulator -= this.TIME_STEP;
        }
    }

    public PhysicsTest(AstraXApp game) {
        super(game);
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void renderOverride(float delta) {
        this.doPhysicsStep(delta);
        super.renderOverride(delta);
        this.debugRenderer.render(this.physicsWorld, this.worldStage.getCamera().combined);
    }

    @Override
    public void updateOverride(float delta) {
        Vector2 linearImpulse;
        super.updateOverride(delta);
        this.starOrbit.update(delta);
        this.starBody.setTransform(this.starOrbit.getCurrentX(this.systemTime), this.starOrbit.getCurrentY(this.systemTime), 0.0f);
        this.ellipsoidOrbit.update(delta);
        this.planetBody.setTransform(this.ellipsoidOrbit.getCurrentX(this.systemTime), this.ellipsoidOrbit.getCurrentY(this.systemTime), 0.0f);
        Vector2 pos = this.playerBody.getPosition();
        if (Gdx.input.isKeyPressed(29)) {
            this.playerBody.applyAngularImpulse(40.0f, true);
        }
        if (Gdx.input.isKeyPressed(32)) {
            this.playerBody.applyAngularImpulse(-40.0f, true);
        }
        if (Gdx.input.isKeyPressed(51)) {
            linearImpulse = MathUtil.rotate(new Vector2(40.0f, 0.0f), this.playerBody.getAngle());
            this.playerBody.applyLinearImpulse(linearImpulse, pos, true);
        }
        if (Gdx.input.isKeyPressed(47)) {
            linearImpulse = MathUtil.rotate(new Vector2(-40.0f, 0.0f), this.playerBody.getAngle());
            this.playerBody.applyLinearImpulse(linearImpulse, pos, true);
        }
        if (Gdx.input.isKeyPressed(62)) {
            this.playerBody.linVelLoc.scl(0.9f);
            this.playerBody.linVelWorld.scl(0.9f);
        }
    }

    @Override
    public void create() {
        this.physicsWorld = new World(new Vector2(0.0f, 0.0f), true);
        this.physicsFactory = new PhysicsFactory(this.physicsWorld);
        this.starOrbit = new EllipsoidOrbit(300.0f, 200.0f);
        this.starOrbit.setVelocity(0.3f);
        this.starOrbit.setOffset((float)Gdx.graphics.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f);
        this.ellipsoidOrbit = new EllipsoidOrbit(100.0f, 100.0f);
        this.ellipsoidOrbit.setVelocity(0.3f);
        this.ellipsoidOrbit.setParent(this.starOrbit);
        PhysicsSettings physicsSettings = new PhysicsSettings();
        physicsSettings.bodyDef.type = BodyDef.BodyType.DynamicBody;
        physicsSettings.bodyDef.position.set(100.0f, 100.0f);
        physicsSettings.bodyDef.userData = "Asteroid Body";
        physicsSettings.bodyDef.linearDamping = 0.1f;
        physicsSettings.bodyDef.angularDamping = 0.1f;
        PhysicsSettings.PhysicsFixtureSettings baseFixture = new PhysicsSettings.PhysicsFixtureSettings();
        baseFixture.restitution = 0.1f;
        PolygonShape boxShape = new PolygonShape();
        boxShape.setAsBox(10.0f, 10.0f);
        baseFixture.shape = boxShape;
        baseFixture.density = 0.4f;
        baseFixture.userData = "Asteroid Fixture";
        physicsSettings.fixtures.add(baseFixture);
        this.physicsFactory.create(physicsSettings);
        physicsSettings = new PhysicsSettings();
        physicsSettings.bodyDef.type = BodyDef.BodyType.DynamicBody;
        physicsSettings.bodyDef.position.set(0.0f, 100.0f);
        physicsSettings.bodyDef.userData = "Player Body";
        physicsSettings.bodyDef.linearDamping = 0.01f;
        physicsSettings.bodyDef.angularDamping = 0.1f;
        baseFixture = new PhysicsSettings.PhysicsFixtureSettings();
        baseFixture.restitution = 0.1f;
        boxShape = new PolygonShape();
        boxShape.setAsBox(25.0f, 5.0f);
        baseFixture.shape = boxShape;
        baseFixture.density = 0.2f;
        baseFixture.userData = "Player Fixture";
        PhysicsSettings.PhysicsFixtureSettings headFixture = new PhysicsSettings.PhysicsFixtureSettings();
        PolygonShape triShape = new PolygonShape();
        triShape.setAsBox(5.0f, 5.0f, new Vector2(25.0f, 0.0f), 0.0f);
        headFixture.restitution = 0.5f;
        headFixture.shape = triShape;
        headFixture.density = 0.2f;
        headFixture.userData = "Player Head Fixture";
        physicsSettings.fixtures.add(baseFixture);
        physicsSettings.fixtures.add(headFixture);
        this.playerBody = this.physicsFactory.create(physicsSettings);
        physicsSettings = new PhysicsSettings();
        physicsSettings.bodyDef.type = BodyDef.BodyType.StaticBody;
        physicsSettings.bodyDef.position.set(100.0f, 100.0f);
        physicsSettings.bodyDef.userData = "Planet Body";
        physicsSettings.bodyDef.fixedRotation = true;
        baseFixture = new PhysicsSettings.PhysicsFixtureSettings();
        baseFixture.restitution = 0.1f;
        CircleShape circleShape = new CircleShape();
        circleShape.setRadius(25.6f);
        baseFixture.shape = circleShape;
        baseFixture.isSensor = true;
        baseFixture.userData = "Planet Fixture";
        physicsSettings.fixtures.add(baseFixture);
        this.planetBody = this.physicsFactory.create(physicsSettings);
        physicsSettings = new PhysicsSettings();
        physicsSettings.bodyDef.type = BodyDef.BodyType.StaticBody;
        physicsSettings.bodyDef.userData = "Star Body";
        physicsSettings.bodyDef.fixedRotation = true;
        baseFixture = new PhysicsSettings.PhysicsFixtureSettings();
        baseFixture.restitution = 0.1f;
        circleShape = new CircleShape();
        circleShape.setRadius(256.0f);
        baseFixture.shape = circleShape;
        baseFixture.isSensor = true;
        baseFixture.userData = "Star Fixture";
        physicsSettings.fixtures.add(baseFixture);
        this.starBody = this.physicsFactory.create(physicsSettings);
    }
}

