/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.CelestialTarget;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystemSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystemSettingsRepository;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetCreationSettingsRepository;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetGenerationSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetGenerationSettingsRepository;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.Planet;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.PlanetCreationSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.PlanetFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.StarSystemFactory;
import com.neutronio.astrax.app.repository.Tagged;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.gfx.AstraXRenderContext;
import com.neutronio.astrax.gfx.bg.StarSystemBackgroundSettings;
import com.neutronio.astrax.gfx.entities.PlanetGraphics;
import com.neutronio.astrax.gfx.factories.PlanetGraphicsFactory;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.TextButtonPalette;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.tab.FlexTab;
import com.neutronio.astrax.ui.commons.widgets.BubblePaginator;
import com.neutronio.astrax.ui.commons.widgets.PlayerControlWidget;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;
import com.neutronio.astrax.ui.editor.Palette;
import com.neutronio.astrax.ui.game.menu.map.starmap.detail.CelestialPanel;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class PlanetGeneratorTest
extends DevScreenBase {
    private ComponentFactory factory;
    private PlanetFactory planetFactory;
    private CelestialTarget targetPreview = null;
    private AstraXRenderContext renderContext;
    private CelestialPanel detailPanel;
    private FlexTab tab;
    private StarSystem starSystem = null;
    private float starSystemSpeed = 1.0f;
    private PlayerControlWidget playerControlWidget;
    private StarSystemFactory starSystemFactory;
    private SelectBox<SelectBoxWrapper<StarSystemSettings>> starSystemSelector;
    private TextButtonPalette<Tagged> planetList;
    private BubblePaginator planetListPaginator;
    private TextField tagTextField;
    private TextField tagExcludeTextField;
    private SelectBox<SelectBoxWrapper<Class>> settingsSelector;
    private Array<SelectBoxWrapper<Object>> generationList = new Array();
    private Array<SelectBoxWrapper<Object>> creationList = new Array();
    private SelectBox<SelectBoxWrapper<Object>> planetSelector;

    public PlanetGeneratorTest(AstraXApp game) {
        super(game);
    }

    @Override
    public void updateOverride(float delta) {
        OrthographicCamera camera;
        super.updateOverride(delta);
        if (Gdx.input.isKeyPressed(8)) {
            camera = (OrthographicCamera)this.worldStage.getCamera();
            camera.zoom += 0.1f;
        }
        if (Gdx.input.isKeyPressed(9)) {
            camera = (OrthographicCamera)this.worldStage.getCamera();
            camera.zoom -= 0.1f;
        }
        if (Gdx.input.isKeyJustPressed(10)) {
            camera = (OrthographicCamera)this.worldStage.getCamera();
            camera.zoom = 1.0f;
        }
        if (this.starSystem != null) {
            this.starSystem.update(delta * this.starSystemSpeed);
        }
    }

    private void fetchByTags(String input, String exclude) {
        this.planetFactory.setSeed(System.currentTimeMillis());
        List<String> tagList = Arrays.asList(input.split(Pattern.quote(" ")));
        if (exclude != null) {
            List<String> excludeList = Arrays.asList(exclude.split(Pattern.quote(" ")));
            List<Tagged> taggedData = AstraXApp.astraX.getRepositoryFactory().getDataManager().findDataByTags(tagList, excludeList);
            this.logger.finest("Found items: " + taggedData.size());
            this.planetList.setItems(taggedData);
            this.planetListPaginator.updateChange();
        } else {
            List<Tagged> taggedData = AstraXApp.astraX.getRepositoryFactory().getDataManager().findDataByTags(tagList);
            this.logger.finest("Found items: " + taggedData.size());
            this.planetList.setItems(taggedData);
            this.planetListPaginator.updateChange();
        }
    }

    private void generateStarSystem(StarSystemSettings settings) {
        if (this.targetPreview != null) {
            ((PlanetGraphics)this.targetPreview.getGraphics()).remove();
        }
        if (this.starSystem != null) {
            this.starSystem.getGraphics().remove();
        }
        this.starSystem = this.starSystemFactory.generateStarSystem(settings, new StarSystemBackgroundSettings());
        float scale = 0.001f;
        this.starSystem.update(1.4f);
        this.starSystem.getGraphics().scaleBy(scale);
        this.starSystem.getGraphics().setPosition((float)Gdx.graphics.getWidth() / 2.0f - this.starSystem.getGraphics().getWidth() / 2.0f * scale, (float)Gdx.graphics.getHeight() / 2.0f - this.starSystem.getGraphics().getHeight() / 2.0f * scale);
        this.worldStage.addActor(this.starSystem.getGraphics());
        this.starSystem.getGraphics().toBack();
    }

    private void generatePreview(PlanetFactory.CelestialSettings celestialSettings) {
        if (this.targetPreview != null) {
            ((PlanetGraphics)this.targetPreview.getGraphics()).remove();
        }
        if (this.starSystem != null) {
            this.starSystem.getGraphics().remove();
        }
        this.planetFactory.setSeed(System.currentTimeMillis());
        this.targetPreview = this.planetFactory.createTarget(celestialSettings);
        ((PlanetGraphics)this.targetPreview.getGraphics()).setPosition((float)Gdx.graphics.getWidth() / 2.0f - ((PlanetGraphics)this.targetPreview.getGraphics()).getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f - ((PlanetGraphics)this.targetPreview.getGraphics()).getHeight() / 2.0f);
        this.worldStage.addActor((Actor)this.targetPreview.getGraphics());
        ((PlanetGraphics)this.targetPreview.getGraphics()).toBack();
        this.detailPanel.setPlanet((Planet)this.targetPreview.getModel(), 100.0f);
    }

    private SimplePanel getSystemGeneratorPanel() {
        SimplePanel panel = new SimplePanel(this.factory, "default", "outset");
        panel.align(2);
        this.playerControlWidget = new PlayerControlWidget(this.factory);
        this.playerControlWidget.setListener(new PlayerControlWidget.UserPlayerListener(){

            @Override
            public void onPlay() {
                PlanetGeneratorTest.this.starSystemSpeed = 1.0f;
            }

            @Override
            public void onStop() {
                PlanetGeneratorTest.this.starSystemSpeed = 0.0f;
                if (PlanetGeneratorTest.this.starSystem != null) {
                    PlanetGeneratorTest.this.starSystem.setSystemTime(0.0f);
                }
            }

            @Override
            public void onPause() {
                PlanetGeneratorTest.this.starSystemSpeed = 0.0f;
            }

            @Override
            public void onNext() {
                PlanetGeneratorTest.this.starSystemSpeed = 10.0f;
            }

            @Override
            public void onPrevious() {
                PlanetGeneratorTest.this.starSystemSpeed = -10.0f;
            }
        });
        StarSystemSettingsRepository starSystemSettingsRepository = AstraXApp.astraX.getRepository(StarSystemSettingsRepository.class);
        List systems = starSystemSettingsRepository.all();
        Array<SelectBoxWrapper<StarSystemSettings>> starSystemsWrapper = new Array<SelectBoxWrapper<StarSystemSettings>>();
        for (StarSystemSettings starSystem : systems) {
            starSystemsWrapper.add(new SelectBoxWrapper<StarSystemSettings>(starSystem.name, starSystem));
        }
        this.starSystemSelector = new SelectBox(this.factory.getSkin());
        this.starSystemSelector.setItems(starSystemsWrapper);
        AstraXTextButton generateButton = new AstraXTextButton(this.factory, "primary");
        generateButton.setCanCheck(false);
        generateButton.setText("Generate");
        generateButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                PlanetGeneratorTest.this.generateStarSystem((StarSystemSettings)((SelectBoxWrapper)PlanetGeneratorTest.this.starSystemSelector.getSelected()).getPayload());
                super.clicked(event, x, y);
            }
        });
        panel.addRow("Systems", this.starSystemSelector);
        panel.row();
        panel.add();
        panel.addValue(generateButton).center();
        panel.row();
        panel.addValue(this.playerControlWidget, 2).center();
        return panel;
    }

    private SimplePanel getListGeneratorPanel() {
        SimplePanel panel = new SimplePanel(this.factory, "default", "outset");
        this.planetList = new TextButtonPalette(this.factory);
        this.planetList.setColumns(2);
        this.planetList.setIconCount(10);
        this.planetList.setButtonProducer(new Palette.ButtonUpdater<AstraXTextButton, Tagged>(){

            @Override
            public AstraXTextButton createButton(ComponentFactory componentFactory, String style) {
                AstraXTextButton textButton = new AstraXTextButton(componentFactory, "secondary");
                textButton.setCanCheck(false);
                textButton.setDisabled(true);
                return textButton;
            }

            @Override
            public void updateButton(AstraXTextButton button, Tagged settings) {
                button.setUserObject(settings);
                button.setDisabled(false);
                if (settings instanceof PlanetGenerationSettings) {
                    button.setText(((PlanetGenerationSettings)settings).name);
                } else if (settings instanceof PlanetCreationSettings) {
                    button.setText(((PlanetCreationSettings)settings).name);
                } else {
                    button.setText(settings.getClass().getSimpleName());
                }
            }

            @Override
            public void resetButton(AstraXTextButton button) {
                button.setText("");
                button.setUserObject(null);
                button.setDisabled(true);
            }
        });
        this.planetList.fillWithButtons(null);
        this.planetList.pack();
        this.tagTextField = new TextField("", this.factory.getSkin());
        this.tagExcludeTextField = new TextField("", this.factory.getSkin());
        AstraXTextButton findTagButton = new AstraXTextButton(this.factory, "primary");
        findTagButton.setCanCheck(false);
        findTagButton.setText("Find by Tag");
        findTagButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                PlanetGeneratorTest.this.fetchByTags(PlanetGeneratorTest.this.tagTextField.getText(), PlanetGeneratorTest.this.tagExcludeTextField.getText().isEmpty() ? null : PlanetGeneratorTest.this.tagExcludeTextField.getText());
                super.clicked(event, x, y);
            }
        });
        this.planetListPaginator = new BubblePaginator(this.factory);
        this.planetListPaginator.setPaginator(this.planetList);
        panel.addRow("Tags: ", this.tagTextField);
        panel.row();
        panel.addRow("Exclude: ", this.tagExcludeTextField);
        panel.row();
        panel.add();
        panel.addValue(findTagButton).center();
        panel.row();
        panel.addLabel("Results", 2);
        panel.row();
        panel.addValue(this.planetList, 2);
        panel.row();
        panel.addValue(this.planetListPaginator, 2).center();
        return panel;
    }

    private SimplePanel getSoloGeneratorPanel() {
        SimplePanel panel = new SimplePanel(this.factory, "default", "outset");
        this.settingsSelector = new SelectBox(this.factory.getSkin());
        this.settingsSelector.setItems(new SelectBoxWrapper<Class<PlanetGenerationSettings>>(PlanetGenerationSettings.class.getSimpleName(), PlanetGenerationSettings.class), new SelectBoxWrapper<Class<PlanetCreationSettings>>(PlanetCreationSettings.class.getSimpleName(), PlanetCreationSettings.class));
        this.settingsSelector.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                if (Objects.equals(((SelectBoxWrapper)PlanetGeneratorTest.this.settingsSelector.getSelected()).getPayload(), PlanetGenerationSettings.class)) {
                    PlanetGeneratorTest.this.planetSelector.setItems(PlanetGeneratorTest.this.generationList);
                } else if (Objects.equals(((SelectBoxWrapper)PlanetGeneratorTest.this.settingsSelector.getSelected()).getPayload(), PlanetCreationSettings.class)) {
                    PlanetGeneratorTest.this.planetSelector.setItems(PlanetGeneratorTest.this.creationList);
                }
            }
        });
        this.planetSelector = new SelectBox(this.factory.getSkin());
        this.planetSelector.setItems(this.generationList);
        this.planetSelector.pack();
        this.planetSelector.setPosition((float)Gdx.graphics.getWidth() - this.planetSelector.getWidth() - 10.0f, (float)Gdx.graphics.getHeight() / 2.0f - this.planetSelector.getHeight() / 2.0f);
        this.planetSelector.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                if (Objects.equals(((SelectBoxWrapper)PlanetGeneratorTest.this.settingsSelector.getSelected()).getPayload(), PlanetGenerationSettings.class)) {
                    PlanetGeneratorTest.this.generatePreview(new PlanetFactory.CelestialSettings((PlanetGenerationSettings)((SelectBoxWrapper)PlanetGeneratorTest.this.planetSelector.getSelected()).getPayload(), null));
                } else if (Objects.equals(((SelectBoxWrapper)PlanetGeneratorTest.this.settingsSelector.getSelected()).getPayload(), PlanetCreationSettings.class)) {
                    PlanetGeneratorTest.this.generatePreview(new PlanetFactory.CelestialSettings(null, (PlanetCreationSettings)((SelectBoxWrapper)PlanetGeneratorTest.this.planetSelector.getSelected()).getPayload()));
                }
            }
        });
        AstraXTextButton generateButton = new AstraXTextButton(this.factory, "primary");
        generateButton.setCanCheck(false);
        generateButton.setText("Generate");
        generateButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (Objects.equals(((SelectBoxWrapper)PlanetGeneratorTest.this.settingsSelector.getSelected()).getPayload(), PlanetGenerationSettings.class)) {
                    PlanetGeneratorTest.this.generatePreview(new PlanetFactory.CelestialSettings((PlanetGenerationSettings)((SelectBoxWrapper)PlanetGeneratorTest.this.planetSelector.getSelected()).getPayload(), null));
                } else if (Objects.equals(((SelectBoxWrapper)PlanetGeneratorTest.this.settingsSelector.getSelected()).getPayload(), PlanetCreationSettings.class)) {
                    PlanetGeneratorTest.this.generatePreview(new PlanetFactory.CelestialSettings(null, (PlanetCreationSettings)((SelectBoxWrapper)PlanetGeneratorTest.this.planetSelector.getSelected()).getPayload()));
                }
            }
        });
        panel.addValueCentered(this.settingsSelector);
        panel.row();
        panel.addValueCentered(this.planetSelector);
        panel.row();
        panel.addValueCentered(generateButton);
        panel.row();
        return panel;
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void create() {
        super.create();
        this.header.remove();
        this.factory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
        this.starSystemFactory = AstraXApp.astraX.getFactoryByClass(StarSystemFactory.class);
        PlanetGenerationSettingsRepository generationRepository = AstraXApp.astraX.getRepository(PlanetGenerationSettingsRepository.class);
        List allGeneration = generationRepository.all();
        for (PlanetGenerationSettings planet : allGeneration) {
            this.generationList.add(new SelectBoxWrapper<PlanetGenerationSettings>(planet.name, planet));
        }
        PlanetCreationSettingsRepository creationRepository = AstraXApp.astraX.getRepository(PlanetCreationSettingsRepository.class);
        List allPlanets = creationRepository.all();
        for (PlanetCreationSettings planet : allPlanets) {
            this.creationList.add(new SelectBoxWrapper<PlanetCreationSettings>(planet.name, planet));
        }
        this.detailPanel = new CelestialPanel(this.factory);
        this.detailPanel.construct();
        this.detailPanel.setPosition(10.0f, (float)Gdx.graphics.getHeight() / 2.0f - this.detailPanel.getHeight() / 2.0f);
        PlanetGraphicsFactory graphicsFactory = AstraXApp.astraX.getFactoryByClass(PlanetGraphicsFactory.class);
        this.planetFactory = AstraXApp.astraX.getFactoryByClass(PlanetFactory.class);
        this.renderContext = new AstraXRenderContext(this.factory, this.worldStage, this.factory.getSkin().getRegion("star_1"));
        graphicsFactory.setWorldRenderContext(this.renderContext);
        SimplePanel generatePlanet = this.getSoloGeneratorPanel();
        SimplePanel listGenerate = this.getListGeneratorPanel();
        this.tab = new FlexTab(this.factory);
        AstraXTextButton singleButton = this.tab.addTabWithTextButton("Generate", "secondary-tab", generatePlanet);
        AstraXTextButton multiButton = this.tab.addTabWithTextButton("Tags", "secondary-tab", listGenerate);
        AstraXTextButton systemTabButton = this.tab.addTabWithTextButton("System", "secondary-tab", this.getSystemGeneratorPanel());
        SimplePanel tabBody = new SimplePanel(this.factory);
        tabBody.addValueCentered(singleButton);
        tabBody.addValueCentered(multiButton);
        tabBody.addValueCentered(systemTabButton);
        tabBody.row();
        tabBody.addValueCentered(this.tab.getContentStack(), 2);
        tabBody.pack();
        tabBody.setPosition(10.0f, (float)Gdx.graphics.getHeight() - tabBody.getHeight());
        this.tab.getStackController().show(0);
        this.hudStage.addActor(tabBody);
    }
}

