/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Vector2;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.PlanetCreationSettings;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.gfx.AstraXRenderContext;
import com.neutronio.astrax.gfx.entities.PlanetGraphics;
import com.neutronio.astrax.gfx.factories.PlanetGraphicsFactory;
import com.neutronio.astrax.ui.ComponentFactory;
import java.util.logging.Logger;

public class PlanetGraphicsTest
extends DevScreenBase {
    Logger logger = Logger.getLogger(PlanetGraphicsTest.class.getCanonicalName());
    PlanetGraphicsFactory graphicsFactory;
    PlanetGraphics smallPlanetGfx;
    PlanetGraphics largePlanetGfx;
    PlanetGraphics mediumPlanetGfx;
    float time = 0.0f;
    Vector2 planetPos = new Vector2();
    AstraXRenderContext astraXRenderContext;

    public PlanetGraphicsTest(AstraXApp game) {
        super(game);
    }

    @Override
    public void renderOverride(float delta) {
        super.renderOverride(delta);
    }

    @Override
    public void updateOverride(float delta) {
        OrthographicCamera camera;
        super.updateOverride(delta);
        this.time += delta;
        if (Gdx.input.isKeyJustPressed(62)) {
            this.smallPlanetGfx.toggleSelect();
            this.mediumPlanetGfx.toggleSelect();
            this.largePlanetGfx.toggleSelect();
        }
        if (Gdx.input.isKeyJustPressed(66)) {
            this.smallPlanetGfx.setPlanetSize(300, 300);
            this.smallPlanetGfx.updateSize();
        }
        if (Gdx.input.isKeyJustPressed(8)) {
            camera = (OrthographicCamera)this.worldStage.getCamera();
            camera.zoom += 0.1f;
        }
        if (Gdx.input.isKeyJustPressed(9)) {
            camera = (OrthographicCamera)this.worldStage.getCamera();
            camera.zoom -= 0.1f;
        }
        if (Gdx.input.isKeyJustPressed(51)) {
            this.smallPlanetGfx.faceTo(0.0f);
            this.mediumPlanetGfx.faceTo(0.0f);
            this.largePlanetGfx.faceTo(0.0f);
        }
        if (Gdx.input.isKeyJustPressed(32)) {
            this.smallPlanetGfx.faceTo(90.0f);
            this.mediumPlanetGfx.faceTo(90.0f);
            this.largePlanetGfx.faceTo(90.0f);
        }
        if (Gdx.input.isKeyJustPressed(47)) {
            this.smallPlanetGfx.faceTo(180.0f);
            this.mediumPlanetGfx.faceTo(180.0f);
            this.largePlanetGfx.faceTo(180.0f);
        }
        if (Gdx.input.isKeyJustPressed(29)) {
            this.smallPlanetGfx.faceTo(270.0f);
            this.mediumPlanetGfx.faceTo(270.0f);
            this.largePlanetGfx.faceTo(270.0f);
        }
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void create() {
        super.create();
        ComponentFactory factory = this.app.getAppFactoryByClass(ComponentFactory.class);
        this.graphicsFactory = AstraXApp.astraX.getFactoryByClass(PlanetGraphicsFactory.class);
        this.astraXRenderContext = new AstraXRenderContext(factory, this.uiStage, factory.getSkin().getRegion("star_1"));
        this.graphicsFactory.setWorldRenderContext(this.astraXRenderContext);
        PlanetCreationSettings earthPlanet = new PlanetCreationSettings();
        earthPlanet.scale = Float.valueOf(1.0f);
        earthPlanet.addTextureSetting(98.0f, "env/planet_rocky", Color.FOREST);
        earthPlanet.addTextureSetting(20.0f, "env/planet_ocean", Color.BLUE);
        earthPlanet.addTextureSetting(0.0f, "env/planet_mask", Color.BLACK);
        earthPlanet.useShadowMask = true;
        this.mediumPlanetGfx = this.graphicsFactory.create(earthPlanet);
        this.mediumPlanetGfx.setPosition(100.0f, 200.0f);
        this.mediumPlanetGfx.setAstraXRenderContext(this.astraXRenderContext);
        this.worldStage.addActor(this.mediumPlanetGfx);
        PlanetCreationSettings smallPlanet = new PlanetCreationSettings();
        smallPlanet.scale = Float.valueOf(0.5f);
        smallPlanet.addTextureSetting(90.0f, "env/planet_rocky", Color.BROWN);
        smallPlanet.addTextureSetting(20.0f, "env/planet_frozen", Color.WHITE);
        smallPlanet.addTextureSetting(0.0f, "env/planet_mask", Color.BLACK);
        smallPlanet.useShadowMask = true;
        this.smallPlanetGfx = this.graphicsFactory.create(smallPlanet);
        this.smallPlanetGfx.setPosition(500.0f, 200.0f);
        this.smallPlanetGfx.setAstraXRenderContext(this.astraXRenderContext);
        this.worldStage.addActor(this.smallPlanetGfx);
        PlanetCreationSettings largePlanet = new PlanetCreationSettings();
        largePlanet.scale = Float.valueOf(4.0f);
        largePlanet.addTextureSetting(0.0f, "env/planet_gaseous_base", Color.RED);
        largePlanet.addTextureSetting(45.0f, "env/planet_bands", Color.ORANGE);
        largePlanet.useShadowMask = true;
        this.largePlanetGfx = this.graphicsFactory.create(largePlanet);
        this.largePlanetGfx.setPosition(1300.0f, 200.0f);
        this.largePlanetGfx.setAstraXRenderContext(this.astraXRenderContext);
        this.worldStage.addActor(this.largePlanetGfx);
    }
}

