/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.InputProcessor;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SavedSatellite;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.io.BlueprintLoader;
import com.neutronio.astrax.io.FileHandler;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SavedSatelliteTest
extends DevScreenBase {
    public SavedSatelliteTest(AstraXApp game) {
        super(game);
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void create() {
        super.create();
        BlueprintLoader blueprintLoader = new BlueprintLoader();
        SatelliteGrid satelliteGrid = null;
        try {
            satelliteGrid = blueprintLoader.load("userdata/spacecraft/Driller.json", FileHandler.FileLocation.LOCAL);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SatelliteFactory satelliteFactory = this.app.getFactoryByClass(SatelliteFactory.class);
        Satellite satellite = satelliteFactory.create(satelliteGrid);
        SavedSatellite savedSatellite = new SavedSatellite(satellite);
        SavedSatellite loadedSatellite = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream("satellite.dat");
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(savedSatellite);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getApp().showErrorAlert("An error occured!");
            this.getApp().showErrorAlert(e.getClass().getSimpleName());
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream("satellite.dat");
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            loadedSatellite = (SavedSatellite)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            this.getApp().showErrorAlert("An error occured!");
            this.getApp().showErrorAlert(e.getClass().getSimpleName());
        }
        this.getApp().showSuccessAlert("If no error occurred, test was successful!");
    }
}

