/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.app.datapack.game.world.AsteroidTarget;
import com.neutronio.astrax.app.datapack.game.world.AstraXTargetFactory;
import com.neutronio.astrax.app.datapack.game.world.CelestialTarget;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.Asteroid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.AsteroidFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SavedSatellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.Planet;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.PlanetFactory;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.gfx.AstraXRenderContext;
import com.neutronio.astrax.gfx.entities.PlanetGraphics;
import com.neutronio.astrax.gfx.factories.PlanetGraphicsFactory;
import com.neutronio.astrax.io.BlueprintLoader;
import com.neutronio.astrax.io.FileHandler;
import com.neutronio.astrax.io.binary.game.world.galaxy.SavedAsteroidTarget;
import com.neutronio.astrax.io.binary.game.world.galaxy.SavedCelestialTarget;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.menu.Menu;
import com.neutronio.astrax.util.TargetSettings;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.opentest4j.AssertionFailedError;

public class SavingTest
extends DevScreenBase {
    private Menu actionsMenu;

    public SavingTest(AstraXApp game) {
        super(game);
    }

    private void testSatelliteTarget() {
        BlueprintLoader blueprintLoader = new BlueprintLoader();
        SatelliteGrid satelliteGrid = null;
        try {
            satelliteGrid = blueprintLoader.load("userdata/spacecraft/Driller.json", FileHandler.FileLocation.LOCAL);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SatelliteFactory satelliteFactory = this.app.getFactoryByClass(SatelliteFactory.class);
        Satellite satellite = satelliteFactory.create(satelliteGrid);
        SavedSatellite savedSatellite = new SavedSatellite(satellite);
        SavedSatellite loadedSatellite = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream("satellite.dat");
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(savedSatellite);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getApp().showErrorAlert("An error occured!");
            this.getApp().showErrorAlert(e.getClass().getSimpleName());
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream("satellite.dat");
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            loadedSatellite = (SavedSatellite)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            this.getApp().showErrorAlert("An error occured!");
            this.getApp().showErrorAlert(e.getClass().getSimpleName());
        }
        this.getApp().showSuccessAlert("If no error occurred, test was successful!");
    }

    private void testSolarSysten() {
    }

    private void testAsteroidTarget() {
        this.hudStage.clear();
        this.hudStage.addActor(this.backButton);
        this.hudStage.addActor(this.actionsMenu);
        String filename = "savedAsteroidTarget.dat";
        TargetSettings targetSettings = new TargetSettings();
        targetSettings.tags = new ArrayList<String>();
        targetSettings.tags.add("asteroid");
        AstraXTargetFactory targetFactory = AstraXApp.astraX.getFactoryByClass(AstraXTargetFactory.class);
        AsteroidTarget asteroidTarget = (AsteroidTarget)targetFactory.generate(targetSettings);
        SavedAsteroidTarget savedAsteroidTarget = new SavedAsteroidTarget(asteroidTarget);
        FileHandler.State state = AstraXApp.astraX.getJavaFileHandler().saveFileBinary(savedAsteroidTarget, filename, null);
        Message message = new Message(Message.MessageType.SUCCESS, "Saved: " + (Object)((Object)state));
        AstraXApp.astraX.showMessageAlert(message);
        AsteroidFactory asteroidFactory = AstraXApp.astraX.getFactoryByClass(AsteroidFactory.class);
        SavedAsteroidTarget loadedAsteroidTarget = (SavedAsteroidTarget)AstraXApp.astraX.getJavaFileHandler().readFileBinary(filename, null);
        AsteroidTarget deserializedTarget = asteroidFactory.deserialize(loadedAsteroidTarget);
        Assertions.assertEquals(asteroidTarget.getID(), deserializedTarget.getID());
        Assertions.assertEquals(((Asteroid)asteroidTarget.getModel()).getSettings().name, ((Asteroid)deserializedTarget.getModel()).getSettings().name);
        Assertions.assertEquals(((Asteroid)asteroidTarget.getModel()).getSettings().baseImage, ((Asteroid)deserializedTarget.getModel()).getSettings().baseImage);
        Assertions.assertEquals(((Asteroid)asteroidTarget.getModel()).getResourceDeposit().getDepositSize(), ((Asteroid)deserializedTarget.getModel()).getResourceDeposit().getDepositSize());
        Assertions.assertEquals(((Asteroid)asteroidTarget.getModel()).getResourceDeposit().getName(), ((Asteroid)deserializedTarget.getModel()).getResourceDeposit().getName());
        this.hudStage.addActor((Actor)deserializedTarget.getGraphics());
    }

    private void testCelestialTarget() {
        this.hudStage.clear();
        this.hudStage.addActor(this.backButton);
        this.hudStage.addActor(this.actionsMenu);
        String filename = "savedTarget.dat";
        TargetSettings targetSettings = new TargetSettings();
        targetSettings.tags = new ArrayList<String>();
        targetSettings.tags.add("habitable");
        AstraXTargetFactory targetFactory = AstraXApp.astraX.getFactoryByClass(AstraXTargetFactory.class);
        CelestialTarget generated = (CelestialTarget)targetFactory.generate(targetSettings);
        SavedCelestialTarget savedCelestialTarget = new SavedCelestialTarget(generated);
        FileHandler.State state = AstraXApp.astraX.getJavaFileHandler().saveFileBinary(savedCelestialTarget, filename, null);
        Message message = new Message(Message.MessageType.SUCCESS, "Saved: " + state.name());
        AstraXApp.astraX.showMessageAlert(message);
        SavedCelestialTarget loadedTarget = (SavedCelestialTarget)AstraXApp.astraX.getJavaFileHandler().readFileBinary(filename, null);
        PlanetFactory planetFactory = AstraXApp.astraX.getFactoryByClass(PlanetFactory.class);
        CelestialTarget deserializedTarget = planetFactory.deserialize(loadedTarget);
        Assertions.assertEquals(generated.getID(), deserializedTarget.getID());
        Assertions.assertEquals(generated.getWorldPositionX(), deserializedTarget.getWorldPositionX());
        Assertions.assertEquals(generated.getWorldPositionY(), deserializedTarget.getWorldPositionY());
        Assertions.assertEquals(((Planet)generated.getModel()).getPlanetScale(), ((Planet)deserializedTarget.getModel()).getPlanetScale());
        Assertions.assertEquals(((Planet)generated.getModel()).getCustomPlanetSettings().getTraits().size(), ((Planet)deserializedTarget.getModel()).getCustomPlanetSettings().getTraits().size());
        Assertions.assertEquals(((Planet)generated.getModel()).getClassIcon(), ((Planet)deserializedTarget.getModel()).getClassIcon());
        Assertions.assertEquals(((Planet)generated.getModel()).getTypeIcon(), ((Planet)deserializedTarget.getModel()).getTypeIcon());
        ((PlanetGraphics)deserializedTarget.getGraphics()).setPosition((float)(Gdx.graphics.getWidth() / 2) - ((PlanetGraphics)deserializedTarget.getGraphics()).getWidth() / 2.0f, (float)(Gdx.graphics.getHeight() / 2) - ((PlanetGraphics)deserializedTarget.getGraphics()).getHeight() / 2.0f);
        this.hudStage.addActor((Actor)deserializedTarget.getGraphics());
    }

    @Override
    public void updateOverride(float delta) {
        super.updateOverride(delta);
    }

    @Override
    public void create() {
        super.create();
        ComponentFactory componentFactory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
        PlanetGraphicsFactory graphicsFactory = AstraXApp.astraX.getFactoryByClass(PlanetGraphicsFactory.class);
        AstraXRenderContext astraXRenderContext = new AstraXRenderContext(componentFactory, this.getHudStage(), componentFactory.getSkin().getRegion("star_1"));
        graphicsFactory.setWorldRenderContext(astraXRenderContext);
        this.actionsMenu = new Menu(componentFactory, "dev");
        this.actionsMenu.addButtonForChoice(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                try {
                    SavingTest.this.testCelestialTarget();
                }
                catch (AssertionFailedError e) {
                    e.printStackTrace();
                    AstraXApp.astraX.showErrorAlert("Assertion failed: " + e.getMessage());
                }
            }
        }), "Test Celestial", this.actionsMenu.getStyle().buttonStyleName);
        this.actionsMenu.row();
        this.actionsMenu.addButtonForChoice(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                try {
                    SavingTest.this.testAsteroidTarget();
                }
                catch (AssertionFailedError e) {
                    e.printStackTrace();
                    AstraXApp.astraX.showErrorAlert("Assertion failed: " + e.getMessage());
                }
            }
        }), "Test Asteroid", this.actionsMenu.getStyle().buttonStyleName);
        this.actionsMenu.row();
        this.actionsMenu.addButtonForChoice(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                try {
                    SavingTest.this.testSolarSysten();
                }
                catch (AssertionFailedError e) {
                    e.printStackTrace();
                    AstraXApp.astraX.showErrorAlert("Assertion failed: " + e.getMessage());
                }
            }
        }), "Test Solar System", this.actionsMenu.getStyle().buttonStyleName);
        this.actionsMenu.row();
        this.actionsMenu.addButtonForChoice(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                try {
                    SavingTest.this.testSatelliteTarget();
                }
                catch (AssertionFailedError e) {
                    e.printStackTrace();
                    AstraXApp.astraX.showErrorAlert("Assertion failed: " + e.getMessage());
                }
            }
        }), "Test Satellite", this.actionsMenu.getStyle().buttonStyleName);
        this.actionsMenu.pack();
        this.actionsMenu.setPosition(100.0f, 400.0f);
        this.hudStage.addActor(this.actionsMenu);
    }
}

