/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.DataPack;
import com.neutronio.astrax.app.datapack.game.AbstractGameEventListener;
import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.app.datapack.game.Game;
import com.neutronio.astrax.app.datapack.game.GameFactory;
import com.neutronio.astrax.app.datapack.game.GameSettings;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.Player;
import com.neutronio.astrax.app.datapack.game.world.PlayerFactory;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystemSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.FunctionalSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.Module;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ResourceFlowSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Cargobay;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.Metric;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoverySystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.NavigationBookmark;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.trade.TradeSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.StarSystemFactory;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.gfx.SatelliteGraphics;
import com.neutronio.astrax.gfx.bg.StarSystemBackgroundSettings;
import org.junit.jupiter.api.Assertions;

public class SensorTest
extends DevScreenBase
implements AbstractGameEventListener {
    protected Game astraxGame;
    protected StarSystem starSystem;
    protected Player player;

    public SensorTest(AstraXApp game) {
        super(game);
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void create() {
        super.create();
        this.logger.info("TEST: Creating sensor test...");
        String playerName = "Sensor Test";
        String shipName = "Millenium Falcon";
        GameSettings gameSettings = new GameSettings();
        gameSettings.gameName = playerName;
        gameSettings.seed = 333L;
        GameFactory gameFactory = this.app.getAppFactoryByClass(GameFactory.class);
        this.astraxGame = gameFactory.createGame(AstraXApp.astraX.getActiveUserProfile(), gameSettings);
        this.logger.severe("TEST: Evaluating game...");
        Assertions.assertEquals((Object)gameSettings.gameName, (Object)playerName, "Player Name");
        Assertions.assertEquals(gameSettings.seed, this.astraxGame.getSeed(), "Seed");
        Assertions.assertEquals(1, this.astraxGame.getLoadedDataPackCount(), "# loaded Datapacks");
        this.logger.severe("Passed!");
        DataPack defaultDataPack = this.astraxGame.findDataPack(AstraXApp.DEFAULT_DATAPACK);
        SatelliteSettings playerSettings = new SatelliteSettings();
        playerSettings.name = shipName;
        playerSettings.id = "player";
        playerSettings.fileLocation.path = "ship/ship";
        PlayerFactory playerFactory = AstraXApp.astraX.getFactoryByClass(PlayerFactory.class);
        this.player = playerFactory.createPlayer(playerName, playerSettings, this);
        this.logger.severe("TEST: Evaluating player...");
        Assertions.assertEquals(playerName, this.player.getName());
        Assertions.assertEquals(shipName, this.player.getPlayerTarget().getName());
        this.logger.severe("Passed!");
        StarSystemSettings testSystem = (StarSystemSettings)AstraXApp.astraX.findResource("solarsystem_test");
        this.starSystem = AstraXApp.astraX.getFactoryByClass(StarSystemFactory.class).generateStarSystem(testSystem, new StarSystemBackgroundSettings());
        this.starSystem.registerTarget(this.player.getPlayerTarget());
        this.logger.severe("TEST: Evaluating star system...");
        this.logger.severe("Passed!");
        this.worldStage.addActor(this.starSystem.getGraphics());
        this.worldStage.addActor((Actor)this.player.getPlayerTarget().getGraphics());
        ((SatelliteGraphics)this.player.getPlayerTarget().getGraphics()).toFront();
        DiscoverySystem discoverySystem = ((Satellite)this.player.getPlayerTarget().getModel()).getSystem(DiscoverySystem.class);
        discoverySystem.getProximitySensor().calculateTargetInformation();
        discoverySystem.getDatabank().clearSystemTargets();
        for (Targetable systemMember : this.starSystem.getSystemMembersCopy()) {
            discoverySystem.getDatabank().addDiscovery(new DiscoveryTarget<Targetable>(systemMember));
        }
        this.logger.severe("TEST: Evaluating spacecraft sensors...");
        int targetCount = discoverySystem.getDatabank().getDiscoveries().size();
        Assertions.assertEquals(this.starSystem.getPlanetCount(), targetCount, "Targets in DiscoverySystem not properly initialized");
        this.logger.severe("Passed!");
    }

    @Override
    public void updateOverride(float delta) {
        super.updateOverride(delta);
        if (this.starSystem != null) {
            this.starSystem.update(delta);
        }
    }

    @Override
    public void onDocked(Satellite child, Satellite parent) {
    }

    @Override
    public void onUndocked(Satellite child, Satellite parent) {
    }

    @Override
    public void onMetricDetected(String systemName, float percentage, Metric.MetricState state) {
    }

    @Override
    public void onSystemHealthChanged(FunctionalSystem system, FunctionalSystem.SystemHealth oldState, FunctionalSystem.SystemHealth newState) {
    }

    @Override
    public void onEmpty(ResourceFlowSystem resourceFlowSystem) {
    }

    @Override
    public void onAddToTotalTargets(Targetable target) {
    }

    @Override
    public void onRemoveFromTotalTargets(Targetable target) {
    }

    @Override
    public void onResourceMined(Module drillModule, float damage) {
    }

    @Override
    public void onDrillStart(Module drillModule) {
    }

    @Override
    public void onDrillStop(Module drillModule) {
    }

    @Override
    public void onCameraResetButtonClicked() {
    }

    @Override
    public void onUndockButtonClicked() {
    }

    @Override
    public void onBookmarkButtonClicked() {
    }

    @Override
    public void onBookmarkRemoved(NavigationBookmark bookmark) {
    }

    @Override
    public void onBookmarkModified(NavigationBookmark bookmark) {
    }

    @Override
    public void onBookmarkTracked(NavigationBookmark bookmark) {
    }

    @Override
    public void onBookmarkAdded(NavigationBookmark navigationBookmark) {
    }

    @Override
    public void onTargetClicked(DiscoveryTarget targetable, boolean isBookmark) {
    }

    @Override
    public void onTargetBookmarked(DiscoveryTarget targetable) {
    }

    @Override
    public void onBuyTransactionInitiated(TradeSystem merchant, TradeSystem player, Cargobay<Resource> itemsBoughtFromMerchant) {
    }

    @Override
    public void onSellTransactionInitiated(TradeSystem merchant, TradeSystem player, Cargobay<Resource> itemsSoldToMerchant) {
    }
}

