/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.PlanetCreationSettings;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.gfx.entities.GraphicsContainer;
import com.neutronio.astrax.gfx.entities.PlanetGraphics;
import com.neutronio.astrax.gfx.factories.PlanetGraphicsFactory;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.hud.ShapeTargetor;

public class ShapeTargetorTest
extends DevScreenBase {
    Actor selected = null;
    Stack planetStack;
    ShapeTargetor targetor;
    GraphicsContainer<PlanetGraphics> graphicsContainer;

    protected ShapeTargetorTest(AstraXApp game) {
        super(game);
    }

    private Image createImage(TextureAtlas.AtlasRegion region, Color color) {
        Image image = new Image(region);
        image.setColor(color);
        image.setSize(256.0f, 256.0f);
        image.setScale(1.4f);
        image.setOrigin(1);
        return image;
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void updateOverride(float delta) {
        super.updateOverride(delta);
        if (Gdx.input.isKeyJustPressed(29)) {
            this.targetor.setShapeType(ShapeTargetor.ShapeType.CIRCLE);
        }
        if (Gdx.input.isKeyJustPressed(47)) {
            this.targetor.setShapeType(ShapeTargetor.ShapeType.RECTANGLE);
        }
        if (Gdx.input.isKeyJustPressed(32)) {
            this.selected = this.planetStack;
        }
        if (Gdx.input.isKeyJustPressed(34)) {
            this.selected = this.graphicsContainer;
        }
    }

    @Override
    public void renderOverride(float delta) {
        super.renderOverride(delta);
        this.targetor.render(null, 0.0f, 0.0f, 0.0f, 0.0f, delta);
    }

    @Override
    public void create() {
        super.create();
        ComponentFactory componentFactory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
        this.targetor = new ShapeTargetor(componentFactory.getSkin());
        PlanetCreationSettings planetGraphicsSettings = new PlanetCreationSettings();
        planetGraphicsSettings.addTextureSetting(0.0f, "env/star_base", Color.RED);
        planetGraphicsSettings.addTextureSetting(20.0f, "env/planet_rocky", Color.GOLD);
        PlanetGraphicsFactory planetGraphicsFactory = AstraXApp.astraX.getFactoryByClass(PlanetGraphicsFactory.class);
        PlanetGraphics planetGraphics = planetGraphicsFactory.create(planetGraphicsSettings);
        this.graphicsContainer = new GraphicsContainer();
        this.graphicsContainer.setGraphics(planetGraphics);
        this.graphicsContainer.setPosition(100.0f, 200.0f);
        this.graphicsContainer.setSize(200.0f, 200.0f);
        TextureAtlas atlas = AstraXApp.astraX.getCoreDataPack().getTextureAtlas();
        TextureAtlas.AtlasRegion region1 = atlas.findRegion("env/star_base");
        TextureAtlas.AtlasRegion region2 = atlas.findRegion("env/planet_ao");
        this.planetStack = new Stack();
        this.planetStack.add(this.createImage(region1, Color.RED));
        this.planetStack.add(this.createImage(region2, Color.WHITE));
        this.planetStack.setOrigin(1);
        this.planetStack.pack();
        this.planetStack.setScale(1.0f);
        this.planetStack.setPosition(100.0f, 300.0f);
        this.selected = this.planetStack;
        this.hudStage.addActor(this.planetStack);
        this.hudStage.addActor(this.graphicsContainer);
    }
}

