/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.sfx.SpatialSoundManager;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;

public class SpatialSoundTest
extends DevScreenBase {
    SpatialSoundManager spatialSoundManager;
    SpatialSoundManager.LoopedSpatialSound spatialSound;
    AstraXButton icon;
    AstraXLabel volumeLabel;
    AstraXLabel panLabel;
    AstraXLabel distanceLabel;

    public SpatialSoundTest(AstraXApp game) {
        super(game);
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void updateOverride(float delta) {
        super.updateOverride(delta);
        this.spatialSound.update(delta, this.icon.getX(), this.icon.getY());
        this.volumeLabel.setText(this.spatialSound.getVolume() + "");
        this.panLabel.setText(this.spatialSound.getPanning() + "");
        this.distanceLabel.setText(this.spatialSound.getDistance() + "");
        if (Gdx.input.isKeyPressed(29)) {
            this.icon.addAction(Actions.moveBy(-100.0f, 0.0f, 1.0f));
        }
        if (Gdx.input.isKeyPressed(32)) {
            this.icon.addAction(Actions.moveBy(100.0f, 0.0f, 1.0f));
        }
        if (Gdx.input.isKeyPressed(51)) {
            this.icon.addAction(Actions.moveBy(0.0f, 100.0f, 1.0f));
        }
        if (Gdx.input.isKeyPressed(47)) {
            this.icon.addAction(Actions.moveBy(0.0f, -100.0f, 1.0f));
        }
        if (Gdx.input.isKeyJustPressed(67)) {
            this.spatialSound.play();
        }
        if (Gdx.input.isKeyJustPressed(66)) {
            this.spatialSound.loop();
        }
        if (Gdx.input.isKeyJustPressed(62)) {
            this.spatialSound.stop();
        }
    }

    @Override
    public void create() {
        this.spatialSoundManager = new SpatialSoundManager("test");
        this.spatialSoundManager.setCamera((OrthographicCamera)this.hudStage.getCamera());
        this.spatialSoundManager.addSound("engine", Gdx.audio.newSound(Gdx.files.local("mods/astrax-core/sfx/actor/thruster1_mono.ogg")));
        this.spatialSound = this.spatialSoundManager.createSpatialSound("engine");
        ComponentFactory componentFactory = this.app.getAppFactoryByClass(ComponentFactory.class);
        SimplePanel soundPanel = new SimplePanel(componentFactory);
        soundPanel.addLabel("Vol");
        this.volumeLabel = soundPanel.addLabel("");
        soundPanel.row();
        soundPanel.addLabel("Pan");
        this.panLabel = soundPanel.addLabel("");
        soundPanel.row();
        soundPanel.addLabel("Distance");
        this.distanceLabel = soundPanel.addLabel("");
        soundPanel.pack();
        this.hudStage.addActor(soundPanel);
        soundPanel.setPosition(100.0f, 100.0f);
        this.icon = new AstraXButton(componentFactory, "editor-function");
        this.icon.setPosition((float)Gdx.graphics.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f);
        this.hudStage.addActor(this.icon);
    }

    @Override
    public void dispose() {
    }
}

