/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.app.datapack.game.world.NavTarget;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.gfx.AstraXRenderContext;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.game.menu.StarMap;
import com.neutronio.astrax.util.Tree;

public class StarMapTest
extends DevScreenBase {
    AstraXRenderContext hudRenderContext;
    private StarMap starMap;
    NavTarget staticTarget;
    NavTarget orbitTarget1;
    NavTarget orbitTarget2;
    NavTarget orbitTarget3;
    NavTarget orbitTarget4;
    NavTarget orbitTarget5;
    NavTarget invisibleTarget;
    float timer = 0.0f;

    public StarMapTest(AstraXApp game) {
        super(game);
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void updateOverride(float delta) {
        super.updateOverride(delta);
        this.timer += delta;
        this.staticTarget.update(delta, this.timer);
        this.orbitTarget1.update(delta, this.timer);
        this.orbitTarget2.update(delta, this.timer);
        this.orbitTarget3.update(delta, this.timer);
        this.orbitTarget4.update(delta, this.timer);
        this.orbitTarget5.update(delta, this.timer);
        this.invisibleTarget.update(delta, this.timer);
        if (Gdx.input.isKeyJustPressed(139)) {
            this.hudStage.setDebugAll(!this.hudStage.isDebugAll());
        }
        if (Gdx.input.isKeyJustPressed(32)) {
            this.starMap.getStarMap().addTarget(new DiscoveryTarget<NavTarget>(this.invisibleTarget));
        }
    }

    @Override
    public void create() {
        super.create();
        ComponentFactory componentFactory = this.app.getAppFactoryByClass(ComponentFactory.class);
        this.hudRenderContext = new AstraXRenderContext(componentFactory, this.hudStage, componentFactory.getSkin().getRegion("star_1"));
        componentFactory.setUiRenderContext(this.hudRenderContext);
        this.staticTarget = NavTarget.getDummyStaticTarget(new EntityID("star1"), 0.0f, 0.0f);
        this.orbitTarget1 = NavTarget.getDummyOrbitTarget(new EntityID("planet1"), 10000.0f, 10000.0f, 0.0f, 0.0f);
        this.orbitTarget2 = NavTarget.getDummyOrbitTarget(new EntityID("planet2"), 20000.0f, 5000.0f, 0.0f, 0.0f);
        this.orbitTarget3 = NavTarget.getDummyOrbitTarget(new EntityID("planet3"), 20000.0f, 5000.0f, 3000.0f, -1000.0f);
        this.orbitTarget4 = NavTarget.getDummyOrbitTarget(new EntityID("planet4"), 2000.0f, 5000.0f, 0.0f, 0.0f);
        this.orbitTarget5 = NavTarget.getDummyOrbitTarget(new EntityID("planet5"), 1400.0f, 1800.0f, 0.0f, 0.0f);
        this.invisibleTarget = NavTarget.getDummyOrbitTarget(new EntityID("invisible_planet"), 1200.0f, 1400.0f, 0.0f, 0.0f);
        Tree<NavTarget> system = new Tree<NavTarget>();
        system.getRoot().setObject(this.staticTarget);
        system.add(new Tree.Node<NavTarget>(this.orbitTarget1));
        system.add(new Tree.Node<NavTarget>(this.orbitTarget2));
        system.add(new Tree.Node<NavTarget>(this.orbitTarget3));
        system.add(new Tree.Node<NavTarget>(this.invisibleTarget));
        Tree.Node<NavTarget> node = new Tree.Node<NavTarget>(this.orbitTarget4);
        node.addChild(new Tree.Node<NavTarget>(this.orbitTarget5));
        system.add(node);
        this.starMap = new StarMap(componentFactory);
        this.starMap.setPosition((float)Gdx.graphics.getWidth() / 2.0f - this.starMap.getWidth() / 2.0f, 50.0f);
        this.starMap.getStarMap().addTarget(new DiscoveryTarget<NavTarget>(this.staticTarget));
        this.starMap.getStarMap().addTarget(new DiscoveryTarget<NavTarget>(this.orbitTarget1));
        this.starMap.getStarMap().addTarget(new DiscoveryTarget<NavTarget>(this.orbitTarget2));
        this.starMap.getStarMap().addTarget(new DiscoveryTarget<NavTarget>(this.orbitTarget3));
        this.starMap.getStarMap().addTarget(new DiscoveryTarget<NavTarget>(this.orbitTarget4));
        this.starMap.getStarMap().addTarget(new DiscoveryTarget<NavTarget>(this.orbitTarget5));
        this.hudStage.addActor(this.starMap);
    }
}

