/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.screen.test;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Color;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.concurrent.Worker;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.tanks.TankManager;
import com.neutronio.astrax.app.repository.ColorRepository;
import com.neutronio.astrax.app.screen.test.DevScreenBase;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.ui.commons.ProgressBar;
import com.neutronio.astrax.ui.commons.SelectBox;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.buttons.Checkbox;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.tab.Tab;
import com.neutronio.astrax.ui.commons.text.TextProgressbar;
import com.neutronio.astrax.ui.commons.text.TextSelector;
import com.neutronio.astrax.ui.commons.text.TextSlider;
import com.neutronio.astrax.ui.commons.widgets.AstraXSlider;
import com.neutronio.astrax.ui.commons.widgets.BubblePaginator;
import com.neutronio.astrax.ui.commons.widgets.ColorPaletteEditor;
import com.neutronio.astrax.ui.commons.widgets.ColorSelectBox;
import com.neutronio.astrax.ui.commons.widgets.ColorSwatches;
import com.neutronio.astrax.ui.commons.widgets.DefaultPaginator;
import com.neutronio.astrax.ui.commons.widgets.IconPicker;
import com.neutronio.astrax.ui.commons.widgets.PaginatorComponent;
import com.neutronio.astrax.ui.commons.widgets.PlayerControlWidget;
import com.neutronio.astrax.ui.commons.widgets.RGBSlider;
import com.neutronio.astrax.ui.commons.widgets.RepositoryCRUDComponent;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;
import com.neutronio.astrax.ui.commons.widgets.ZoomButtons;
import com.neutronio.astrax.ui.commons.widgets.Zoomer;
import com.neutronio.astrax.ui.game.TraitIconArray;
import com.neutronio.astrax.ui.game.spacecraft.CompartmentPanel;
import com.neutronio.astrax.util.StandardFormats;
import com.neutronio.astrax.util.Vector2i;
import java.util.ArrayList;
import java.util.Map;

public class UIComponentsTest
extends DevScreenBase {
    ComponentFactory componentFactory;
    Tab componentTab;
    Worker worker;
    long currentTaskId;

    public UIComponentsTest(AstraXApp game) {
        super(game);
    }

    @Override
    public InputProcessor getActiveInputProcessor() {
        return this.hudStage;
    }

    @Override
    public void updateOverride(float delta) {
        super.updateOverride(delta);
    }

    @Override
    public void renderOverride(float delta) {
        super.renderOverride(delta);
        if (Gdx.input.isKeyJustPressed(62)) {
            this.currentTaskId = this.worker.scheduleTask(new Worker.WorkerTask(){

                @Override
                public Object execute() {
                    return new Vector2i(0, 0);
                }
            });
        }
        if (Gdx.input.isKeyJustPressed(66)) {
            Object taskResult = this.worker.getTaskResult(this.currentTaskId);
            System.out.println(taskResult);
        }
    }

    private SimplePanel createButtonsTab() {
        SimplePanel buttonTab = new SimplePanel(this.componentFactory, "detailpanel", "tab-inner");
        buttonTab.top();
        buttonTab.addLabel("Button");
        buttonTab.addValue(new AstraXButton(this.componentFactory, "primary"));
        buttonTab.row();
        AstraXTextButton textButton = new AstraXTextButton(this.componentFactory, "primary");
        textButton.setText("Button Text");
        buttonTab.addLabel("TextButton");
        buttonTab.addValue(textButton);
        buttonTab.row();
        Checkbox checkbox = new Checkbox(this.componentFactory, "checkbox");
        buttonTab.addLabel("Checkbox");
        buttonTab.addValue(checkbox);
        buttonTab.row();
        DefaultPaginator defaultPaginator = new DefaultPaginator();
        defaultPaginator.setMaxPages(4);
        defaultPaginator.setCurrentPage(0);
        BubblePaginator bubblePaginator = new BubblePaginator(this.componentFactory);
        bubblePaginator.setPaginator(defaultPaginator);
        buttonTab.addLabel(bubblePaginator.getClass().getSimpleName());
        buttonTab.addValue(bubblePaginator);
        buttonTab.row();
        DefaultPaginator defaultPaginator2 = new DefaultPaginator();
        defaultPaginator2.setMaxPages(6);
        defaultPaginator2.setCurrentPage(2);
        PaginatorComponent paginatorComponent = new PaginatorComponent(this.componentFactory);
        paginatorComponent.setPaginator(defaultPaginator2);
        paginatorComponent.update();
        buttonTab.addLabel(paginatorComponent.getClass().getSimpleName());
        buttonTab.addValue(paginatorComponent);
        buttonTab.pack();
        return buttonTab;
    }

    private SimplePanel createTextTab() {
        SimplePanel textTab = new SimplePanel(this.componentFactory, "detailpanel", "tab-inner");
        textTab.top();
        IconLabel iconLabel = new IconLabel(this.componentFactory, "default", "inset");
        iconLabel.set("icon_function_quarters", "Quarters");
        textTab.addLabel("IconLabel");
        textTab.addValue(iconLabel);
        textTab.row();
        TextSelector<String> textSelector = new TextSelector<String>(this.componentFactory);
        textSelector.addItem(new SelectBoxWrapper<String>("Item 1", "Item 1"));
        textSelector.addItem(new SelectBoxWrapper<String>("Item 2", "Item 2"));
        textSelector.addItem(new SelectBoxWrapper<String>("Item 3", "Item 3"));
        textSelector.addItem(new SelectBoxWrapper<String>("Item 4", "Item 4"));
        textSelector.setTextSpace(20.0f);
        textSelector.setSelectedIndex(2, false);
        textTab.addLabel("TextSelector");
        textTab.addValue(textSelector);
        textTab.row();
        TextProgressbar textProgressbar = new TextProgressbar(this.componentFactory);
        textProgressbar.setBaseValue(100.0f);
        textProgressbar.setFormat(StandardFormats.PERCENT);
        textProgressbar.setValue(0.4412f);
        textTab.addLabel("TextProgressbar");
        textTab.addValue(textProgressbar);
        textTab.row();
        TextSlider textSlider = new TextSlider(this.componentFactory);
        textSlider.setFormat(StandardFormats.FLOAT_COUNT);
        textSlider.setBaseValue(3.0f);
        textSlider.setValue(0.3f);
        textTab.addLabel("TextSlider");
        textTab.addValue(textSlider);
        textTab.row();
        return textTab;
    }

    private SimplePanel createWidgetTab() {
        SimplePanel widgetTab = new SimplePanel(this.componentFactory, "detailpanel", "tab-inner");
        widgetTab.top();
        widgetTab.addHeader("Icons", 2);
        widgetTab.row();
        ArrayList<String> icons = new ArrayList<String>();
        icons.add("icon_resource_ingot_large");
        icons.add("icon_resource_ingot_large-1");
        icons.add("icon_resource_ingot_large-4");
        TraitIconArray iconArray = new TraitIconArray(this.componentFactory.getSkin());
        iconArray.updateWith(icons);
        widgetTab.addLabel("IconArray");
        widgetTab.addValue(iconArray);
        widgetTab.row();
        IconPicker iconPicker = new IconPicker(this.componentFactory);
        iconArray.setIconSize(32);
        iconPicker.setIcons("icon_inline_fuel", "icon_inline_home", "icon_inline_pickaxe", "icon_inline_research");
        iconPicker.setIconColor(Color.MAGENTA);
        iconPicker.setSelectedIcon("icon_inline_home");
        widgetTab.addLabel("IconPicker");
        widgetTab.addValue(iconPicker);
        widgetTab.row();
        widgetTab.addHeader("Sliders / Progressbars", 2);
        widgetTab.row();
        AstraXSlider slider = new AstraXSlider(this.componentFactory);
        slider.setPosition(400.0f, 300.0f);
        widgetTab.addLabel("Slider");
        widgetTab.addValue(slider);
        widgetTab.row();
        ProgressBar progressBar = new ProgressBar(this.componentFactory);
        progressBar.setValue(0.5f);
        widgetTab.addLabel("Progressbar");
        widgetTab.addValue(progressBar);
        widgetTab.row();
        widgetTab.addHeader("Colors & More", 2);
        widgetTab.row();
        Color[] colors = new Color[]{Color.valueOf("ffffff"), Color.valueOf("ffe2c5"), Color.valueOf("ffba76"), Color.valueOf("2a9b97"), Color.valueOf("74cfc8"), Color.valueOf("91944f"), Color.valueOf("fee169"), Color.valueOf("8ad4e4"), Color.valueOf("d75aff"), Color.valueOf("8f542a"), Color.valueOf("5c9376"), Color.valueOf("7e8055"), Color.valueOf("566f74"), Color.valueOf("abbec2")};
        ColorSelectBox colorSelectBox = new ColorSelectBox(this.componentFactory);
        colorSelectBox.setColors(colors);
        widgetTab.addLabel("ColorSelectBox");
        widgetTab.addValue(colorSelectBox);
        widgetTab.row();
        RGBSlider RGBSlider2 = new RGBSlider(this.componentFactory);
        RGBSlider2.setPickedColor(Color.GOLD.cpy());
        widgetTab.addLabel("ColorPicker");
        widgetTab.addValue(RGBSlider2);
        widgetTab.row();
        Map colorPalette = (Map)AstraXApp.astraX.getRepository(ColorRepository.class).find("palette-ui-velvet");
        ColorSwatches colorSwatches = new ColorSwatches(this.componentFactory);
        colorSwatches.setIconsPerRow(6);
        colorSwatches.setColorPalette(colorPalette);
        widgetTab.addLabel("ColorSwatches");
        widgetTab.addValue(colorSwatches);
        widgetTab.row();
        ColorPaletteEditor colorPaletteEditor = new ColorPaletteEditor(this.componentFactory);
        colorPaletteEditor.setColorPalette(colorPalette);
        widgetTab.addLabel("ColorPaletteEditor");
        widgetTab.addValue(colorPaletteEditor);
        widgetTab.row();
        return widgetTab;
    }

    private SimplePanel createWidgetGroupTab() {
        SimplePanel widgetGroupTab = new SimplePanel(this.componentFactory, "detailpanel", "tab-inner");
        widgetGroupTab.top();
        SelectBox<String> selectBox = new SelectBox<String>(this.componentFactory);
        selectBox.addToContent(new SelectBoxWrapper<String>("Selection 1", "S1"));
        selectBox.addToContent(new SelectBoxWrapper<String>("Selection 2", "S2"));
        selectBox.addToContent(new SelectBoxWrapper<String>("Selection 3", "S3"));
        selectBox.updateToContent();
        widgetGroupTab.addLabel("SelectBox");
        widgetGroupTab.addValue(selectBox);
        widgetGroupTab.row();
        ZoomButtons zoomButtons = new ZoomButtons(this.componentFactory);
        zoomButtons.setZoomable(new Zoomer());
        zoomButtons.construct();
        widgetGroupTab.addLabel("ZoomButtons");
        widgetGroupTab.addValue(zoomButtons);
        widgetGroupTab.row();
        PlayerControlWidget musicPlayer = new PlayerControlWidget(this.componentFactory);
        widgetGroupTab.addLabel("PlayerControlWidget");
        widgetGroupTab.addValue(musicPlayer);
        widgetGroupTab.row();
        RepositoryCRUDComponent repositoryCRUDComponent = new RepositoryCRUDComponent(this.componentFactory);
        repositoryCRUDComponent.construct();
        widgetGroupTab.addLabel("RepositoryCRUD");
        widgetGroupTab.addValue(repositoryCRUDComponent);
        widgetGroupTab.row();
        TankManager tankSystem = new TankManager();
        tankSystem.createCompartment("oxygen");
        tankSystem.addToCompartment("oxygen", new TankManager.DummyTank(100.0f, 100.0f));
        tankSystem.addToCompartment("oxygen", new TankManager.DummyTank(100.0f, 100.0f));
        tankSystem.addToCompartment("oxygen", TankManager.getConsumer(0.2f, 5));
        tankSystem.addToCompartment("oxygen", TankManager.getConsumer(0.3f, 5));
        tankSystem.addToCompartment("oxygen", TankManager.getConsumer(1.5f, 5));
        tankSystem.addToCompartment("oxygen", TankManager.getProducer(0.2f));
        tankSystem.addToCompartment("oxygen", TankManager.getProducer(0.3f));
        tankSystem.addToCompartment("oxygen", TankManager.getProducer(1.45f));
        tankSystem.createCompartment("fuel");
        tankSystem.addToCompartment("fuel", new TankManager.DummyTank(200.0f, 200.0f));
        tankSystem.addToCompartment("fuel", new TankManager.DummyTank(100.0f, 100.0f));
        tankSystem.addToCompartment("fuel", TankManager.getConsumer(0.2f, 5));
        tankSystem.addToCompartment("fuel", TankManager.getConsumer(0.3f, 5));
        tankSystem.addToCompartment("fuel", TankManager.getConsumer(1.5f, 5));
        tankSystem.update(1.0f);
        CompartmentPanel compartmentPanel = new CompartmentPanel(this.componentFactory);
        compartmentPanel.updateValues(tankSystem.getCompartment("oxygen"));
        CompartmentPanel compartmentPanel2 = new CompartmentPanel(this.componentFactory);
        compartmentPanel2.updateValues(tankSystem.getCompartment("fuel"));
        widgetGroupTab.addLabel("CompartmentPanel");
        widgetGroupTab.addValue(compartmentPanel);
        widgetGroupTab.row();
        widgetGroupTab.add();
        widgetGroupTab.addValue(compartmentPanel2);
        return widgetGroupTab;
    }

    @Override
    public void create() {
        super.create();
        this.worker = new Worker("DatabaseStream");
        this.worker.start();
        this.componentFactory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
        this.componentTab = new Tab(this.componentFactory, "default", "outset");
        this.componentTab.addTab("Buttons", this.createButtonsTab());
        this.componentTab.addTab("Text", this.createTextTab());
        this.componentTab.addTab("Widgets", this.createWidgetTab());
        this.componentTab.addTab("Widget Groups", this.createWidgetGroupTab());
        this.componentTab.construct();
        this.componentTab.pack();
        this.componentTab.setPosition((float)(Gdx.graphics.getWidth() / 2) - this.componentTab.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f - this.componentTab.getHeight() / 2.0f);
        this.hudStage.addActor(this.componentTab);
    }
}

