/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.editor;

import com.badlogic.gdx.graphics.Color;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteRole;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.VesselSize;
import com.neutronio.astrax.editor.NewSatelliteSettings;
import com.neutronio.astrax.editor.checklist.SatelliteValidator;
import com.neutronio.astrax.editor.checklist.SpaceshipValidator;
import com.neutronio.astrax.editor.checklist.StationValidator;
import com.neutronio.astrax.editor.overlays.GradientOverlay;
import com.neutronio.astrax.editor.overlays.IconOverlay;
import com.neutronio.astrax.editor.overlays.Overlay;
import com.neutronio.astrax.editor.overlays.OverlayCreator;
import com.neutronio.astrax.editor.placement.Orientation;
import com.neutronio.astrax.editor.toolbox.EditTool;
import com.neutronio.astrax.editor.toolbox.EditorTool;
import com.neutronio.astrax.editor.toolbox.EditorToolBase;
import com.neutronio.astrax.editor.toolbox.InspectionTool;
import com.neutronio.astrax.editor.toolbox.PaintTool;
import com.neutronio.astrax.editor.toolbox.SelectionTool;
import com.neutronio.astrax.ui.editor.DataLayer;
import com.neutronio.astrax.util.Vector2i;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Editor
implements PaintTool.PaintTooLListener,
EditTool.EditToolListener {
    private Map<Class<? extends EditorToolBase>, EditorToolBase> tools = new HashMap<Class<? extends EditorToolBase>, EditorToolBase>();
    private Class<? extends EditorToolBase> selectedTool;
    private SatelliteGrid spacecraft;
    private SatelliteValidator satelliteValidator;
    private Map<String, Overlay> overlays = new LinkedHashMap<String, Overlay>();
    private DataLayer dataLayer = new DataLayer();
    private Overlay activeOverlay;
    private String activeOverlayName;

    public Editor() {
        SelectionTool selectionTool = new SelectionTool();
        this.tools.put(SelectionTool.class, selectionTool);
        EditTool editTool = new EditTool();
        editTool.addListener(this);
        this.tools.put(EditTool.class, editTool);
        InspectionTool inspectionTool = new InspectionTool();
        this.tools.put(InspectionTool.class, inspectionTool);
        PaintTool paintTool = new PaintTool();
        paintTool.setPaintTooLListener(this);
        this.tools.put(PaintTool.class, paintTool);
        this.spacecraft = new SatelliteGrid(SatelliteRole.LIFEBOAT, VesselSize.SMALL);
        this.initOverlays();
    }

    private void initOverlays() {
        this.overlays.put("None", null);
        this.overlays.put("Hitpoints", OverlayCreator.getHullpointsOverlay(this.spacecraft));
        this.overlays.put("Value", OverlayCreator.getValueOverlay(this.spacecraft));
        this.overlays.put("Weight", OverlayCreator.getWeightOverlay(this.spacecraft));
        this.setActiveOverlay("Normal");
    }

    public Map<String, Overlay> getOverlays() {
        return this.overlays;
    }

    public DataLayer getDataLayer() {
        return this.dataLayer;
    }

    public <T> T getToolByClass(Class<T> type) {
        return (T)this.tools.get(type);
    }

    public EditorToolBase getSelectedTool() {
        return this.tools.get(this.selectedTool);
    }

    public Class<? extends EditorTool> getSelectedToolClass() {
        return this.selectedTool;
    }

    public void selectTool(Class<? extends EditorToolBase> type) {
        if (type == null) {
            AstraXApp.astraX.getReactiveCursor().resetCursor();
            return;
        }
        this.selectedTool = type;
        if (this.selectedTool != null) {
            AstraXApp.astraX.getReactiveCursor().setActiveCursor(this.getSelectedTool().getActiveCursorName());
        }
    }

    public void onNewSpacecraft() {
    }

    public void clearSpacecraft() {
        this.spacecraft = new SatelliteGrid(SatelliteRole.LIFEBOAT, VesselSize.SMALL);
        this.dataLayer.clear();
        this.initOverlays();
        this.selectTool(EditTool.class);
    }

    public void onLoadSpacecraft(SatelliteGrid satelliteGrid) {
        this.getToolByClass(SelectionTool.class).deselectAll();
        this.spacecraft = satelliteGrid;
        switch (satelliteGrid.vesselRole) {
            case STATION: {
                this.satelliteValidator = new StationValidator();
                break;
            }
            case CAPITAL_SHIP: {
                this.satelliteValidator = new SpaceshipValidator();
                break;
            }
            case LIFEBOAT: {
                this.satelliteValidator = new SpaceshipValidator();
            }
        }
        this.satelliteValidator.validateAll(this.spacecraft);
        this.initOverlays();
        this.setActiveOverlay(this.activeOverlayName);
    }

    @Override
    public void onPainted(int xTile, int yTile, Color color) {
        if (!this.spacecraft.getData().isEmpty(xTile, yTile)) {
            this.spacecraft.getData().get((int)xTile, (int)yTile).tint = color;
        }
    }

    @Override
    public void onPaintAll(List<Vector2i> selected, Color color) {
        for (Vector2i coordinates : selected) {
            if (this.spacecraft.getData().isEmpty(coordinates.x, coordinates.y)) continue;
            this.spacecraft.getData().get((int)coordinates.x, (int)coordinates.y).tint = color;
        }
    }

    @Override
    public void onResetPaint(List<Vector2i> cells) {
        for (Vector2i coordinates : cells) {
            SatelliteGrid.SatelliteGridSettings settings = this.spacecraft.getData().get(coordinates.x, coordinates.y);
            if (settings == null) continue;
            settings.tint = settings.moduleSettings.color.cpy();
        }
    }

    @Override
    public void onErase(int xTile, int yTile) {
        this.dataLayer.erase(xTile, yTile);
        SatelliteGrid.SatelliteGridSettings settings = this.spacecraft.eraseData(xTile, yTile);
        if (settings != null) {
            this.satelliteValidator.validate(this.spacecraft);
            this.satelliteValidator.validateTile(settings.moduleSettings, settings.orientation, false);
            this.satelliteValidator.processValidation();
        }
    }

    @Override
    public void onPlace(int xTile, int yTile, ModuleSettings settings, Orientation orientation, Color color) {
        this.dataLayer.update(xTile, yTile, this.activeOverlay);
        this.spacecraft.placeData(xTile, yTile, new SatelliteGrid.SatelliteGridSettings(settings, orientation, color));
        this.satelliteValidator.validate(this.spacecraft);
        this.satelliteValidator.validateTile(settings, orientation, true);
        this.satelliteValidator.processValidation();
    }

    public void setActiveOverlay(String overlay) {
        this.activeOverlayName = overlay;
        this.activeOverlay = this.overlays.get(overlay);
        if (this.activeOverlay instanceof GradientOverlay) {
            OverlayCreator.createDataLayer(this.dataLayer, (GradientOverlay)this.activeOverlay, this.spacecraft);
        } else if (this.activeOverlay instanceof IconOverlay) {
            OverlayCreator.createDataLayer(this.dataLayer, (IconOverlay)this.activeOverlay, this.spacecraft);
        } else {
            this.dataLayer.clear();
        }
    }

    public void onNew(NewSatelliteSettings newSpacecraftSettings) {
        switch (newSpacecraftSettings.vesselRole) {
            case STATION: {
                this.satelliteValidator = new StationValidator();
                break;
            }
            case CAPITAL_SHIP: {
                this.satelliteValidator = new SpaceshipValidator();
                break;
            }
            case LIFEBOAT: {
                this.satelliteValidator = new SpaceshipValidator();
            }
        }
        this.spacecraft = new SatelliteGrid(newSpacecraftSettings.vesselRole, newSpacecraftSettings.vesselSize);
        this.spacecraft.name = newSpacecraftSettings.name;
        this.satelliteValidator.validate(this.spacecraft);
        this.satelliteValidator.processValidation();
        this.initOverlays();
        this.setActiveOverlay(this.activeOverlayName);
    }

    public SatelliteGrid getSpacecraft() {
        return this.spacecraft;
    }

    public SatelliteValidator getSatelliteValidator() {
        return this.satelliteValidator;
    }
}

