/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.editor.checklist;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;

public class SatelliteBaseValidator {
    public Message validateNetProduction(SatelliteGrid grid, String resourceID) {
        float net;
        Resource resource = (Resource)AstraXApp.astraX.findResource(resourceID);
        if (grid.tankSettings.containsKey(resourceID) && (net = grid.tankSettings.get((Object)resourceID).production - grid.tankSettings.get((Object)resourceID).consumption) < 0.0f) {
            return new Message(Message.MessageType.WARNING, String.format("Has negative %s production & will run empty.", resource.getName()));
        }
        return null;
    }

    public Message validateTank(SatelliteGrid grid, String resourceID) {
        Resource resource = (Resource)AstraXApp.astraX.findResource(resourceID);
        if (grid.tankSettings.containsKey(resourceID)) {
            if (grid.tankSettings.get((Object)resourceID).capacity <= 0.0f) {
                return new Message(Message.MessageType.ALERT, String.format("Needs tanks for %s.", resource.getName()));
            }
            if (grid.tankSettings.get((Object)resourceID).capacity < 10.0f) {
                return new Message(Message.MessageType.WARNING, String.format("Has only little %s capacity.", new Object[0]));
            }
        } else {
            return new Message(Message.MessageType.ALERT, String.format("Needs tanks for %s.", resource.getName()));
        }
        return null;
    }
}

