/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.editor.checklist;

import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.ThrusterSettings;
import com.neutronio.astrax.editor.checklist.SatelliteBaseValidator;
import com.neutronio.astrax.editor.checklist.SatelliteValidator;
import com.neutronio.astrax.editor.placement.Orientation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SpaceshipValidator
implements SatelliteValidator {
    private List<Message> messages = new ArrayList<Message>();
    private Message validationMessage = new Message();
    private Message.MessageType validationState;
    private int westThrusters = 0;
    private int eastThrusters = 0;
    private int lateralThrusters = 0;
    private SatelliteBaseValidator satelliteBaseValidator = new SatelliteBaseValidator();

    @Override
    public void validateAll(SatelliteGrid satelliteGrid) {
        this.messages.clear();
        this.westThrusters = 0;
        this.eastThrusters = 0;
        this.lateralThrusters = 0;
        this.validate(satelliteGrid);
        for (int x = 0; x < satelliteGrid.getData().getWidth(); ++x) {
            for (int y = 0; y < satelliteGrid.getData().getHeight(); ++y) {
                SatelliteGrid.SatelliteGridSettings settings = satelliteGrid.getData().get(x, y);
                if (settings == null) continue;
                this.validateTile(settings.moduleSettings, settings.orientation, true);
            }
        }
        this.processValidation();
    }

    @Override
    public void validate(SatelliteGrid grid) {
        this.validationState = Message.MessageType.SUCCESS;
        this.messages.clear();
        if (grid.thrusterSettings.isEmpty()) {
            this.messages.add(new Message(Message.MessageType.ALERT, "Needs thrusters for mobility."));
        }
        if (grid.tankSettings.isEmpty()) {
            this.messages.add(new Message(Message.MessageType.ALERT, "Needs tanks for fuel or oxygen supply. "));
        } else {
            Message energyNetMessage;
            Message energyMessage;
            Message fuelMessage;
            Message oxygenMessage = this.satelliteBaseValidator.validateTank(grid, "resource_oxygen");
            if (oxygenMessage != null) {
                this.messages.add(oxygenMessage);
            }
            if ((fuelMessage = this.satelliteBaseValidator.validateTank(grid, "resource_rocketFuel")) != null) {
                this.messages.add(fuelMessage);
            }
            if ((energyMessage = this.satelliteBaseValidator.validateTank(grid, "resource_energy")) != null) {
                this.messages.add(energyMessage);
            }
            if ((energyNetMessage = this.satelliteBaseValidator.validateNetProduction(grid, "resource_energy")) != null) {
                this.messages.add(energyNetMessage);
            }
        }
        if (grid.quarterSettings.beds == 0) {
            this.messages.add(new Message(Message.MessageType.ALERT, "Needs at least one bed."));
        }
        if (grid.cargoSettings.maxWeight == 0.0f) {
            this.messages.add(new Message(Message.MessageType.WARNING, "Has no cargo hold & will not be able to hold items."));
        } else if (grid.cargoSettings.maxWeight <= 1.0f) {
            this.messages.add(new Message(Message.MessageType.WARNING, "Has only little cargo space (< 1 t)."));
        }
        if (grid.dockingSettings.isEmpty()) {
            this.messages.add(new Message(Message.MessageType.ALERT, "Needs a docker module in order to connect to stations."));
        }
        if (grid.cockpitSettings.sensorRange == 0.0f) {
            this.messages.add(new Message(Message.MessageType.ALERT, "Needs a cockpit. "));
        }
    }

    @Override
    public void validateTile(ModuleSettings settings, Orientation orientation, boolean add) {
        if (settings.thrusterSettings != null) {
            if (Objects.equals("REAS", orientation.getControlGroup()) && Objects.equals((Object)settings.thrusterSettings.operationMode, (Object)ThrusterSettings.OperationMode.HOLD)) {
                this.eastThrusters = add ? ++this.eastThrusters : --this.eastThrusters;
            }
            if (Objects.equals("RWES", orientation.getControlGroup()) && Objects.equals((Object)settings.thrusterSettings.operationMode, (Object)ThrusterSettings.OperationMode.HOLD)) {
                this.westThrusters = add ? ++this.westThrusters : --this.westThrusters;
            }
            if (Objects.equals("FLAT", orientation.getControlGroup()) && Objects.equals((Object)settings.thrusterSettings.operationMode, (Object)ThrusterSettings.OperationMode.THROTTLE)) {
                this.lateralThrusters = add ? ++this.lateralThrusters : --this.lateralThrusters;
            }
        }
    }

    @Override
    public void processValidation() {
        if (this.westThrusters <= 0) {
            this.messages.add(new Message(Message.MessageType.ALERT, "Needs thruster in operation mode 'Hold' facing west for rotation."));
        }
        if (this.eastThrusters <= 0) {
            this.messages.add(new Message(Message.MessageType.ALERT, "Needs thrusters in operation mode 'Hold' facing east for rotation."));
        }
        if (this.lateralThrusters <= 0) {
            this.messages.add(new Message(Message.MessageType.ALERT, "Needs thrusters in operation mode 'Throttle' facing back for speed."));
        }
        for (Message message : this.messages) {
            this.validationState = this.validationState.ordinal() < message.getType().ordinal() ? message.getType() : this.validationState;
        }
        switch (this.validationState) {
            case SUCCESS: {
                this.validationMessage = new Message(Message.MessageType.SUCCESS, "No issues could be detected.");
                break;
            }
            case INFO: 
            case WARNING: {
                this.validationMessage = new Message(Message.MessageType.WARNING, "Spacecraft functional, minor issues are present.");
                break;
            }
            case ALERT: 
            case EXCEPTION: {
                this.validationMessage = new Message(Message.MessageType.WARNING, "Spacecraft is non-functional.");
            }
        }
    }

    @Override
    public List<Message> getMessages() {
        return this.messages;
    }

    @Override
    public Message getSummary() {
        return this.validationMessage;
    }

    @Override
    public Message.MessageType getValidationState() {
        return this.validationState;
    }
}

