/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.editor.overlays;

import com.badlogic.gdx.graphics.Color;
import com.neutronio.astrax.editor.overlays.Overlay;
import com.neutronio.astrax.util.ColorBlend;

public class GradientOverlay
implements Overlay {
    protected GradientOverlaySource source;
    protected Color colorMin;
    protected Color colorMax;

    public GradientOverlay(Color colorMin, Color colorMax) {
        this.colorMin = colorMin;
        this.colorMax = colorMax;
    }

    public void setSource(GradientOverlaySource source) {
        this.source = source;
    }

    public Color apply(int x, int y) {
        float alpha = this.source.getCurrent(x, y) / this.source.getMax();
        Color color = ColorBlend.INTERPOLATE.mix(this.colorMax, this.colorMin, alpha);
        color.a = 0.5f;
        return color;
    }

    public Color[] getGradient(int count) {
        Color[] legend = new Color[count];
        for (int i2 = 0; i2 < legend.length; ++i2) {
            float alpha = (float)i2 / (float)(count - 1);
            legend[i2] = ColorBlend.INTERPOLATE.mix(this.colorMax, this.colorMin, alpha);
        }
        return legend;
    }

    public static interface GradientOverlaySource {
        public float getMax();

        public float getCurrent(int var1, int var2);
    }
}

