/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.editor.overlays;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.neutronio.astrax.editor.overlays.GradientOverlay;
import com.neutronio.astrax.editor.overlays.Overlay;
import com.neutronio.astrax.util.ColorBlend;

public class IconOverlay
implements Overlay {
    protected Skin skin;
    protected IconOverlaySource source;
    protected Color colorMin;
    protected Color colorMax;

    public IconOverlay(Skin skin, Color colorMin, Color colorMax) {
        this.skin = skin;
        this.colorMin = colorMin;
        this.colorMax = colorMax;
    }

    public void setSource(IconOverlaySource source) {
        this.source = source;
    }

    public IconColor apply(int x, int y) {
        float alpha = this.source.getCurrent(x, y) / this.source.getMax();
        Color color = ColorBlend.INTERPOLATE.mix(this.colorMax, this.colorMin, alpha);
        color.a = 0.5f;
        String iconName = this.source.getIcon(x, y);
        return new IconColor(color, iconName != null ? this.skin.getRegion(this.source.getIcon(x, y)) : null);
    }

    public static interface IconOverlaySource
    extends GradientOverlay.GradientOverlaySource {
        public String getIcon(int var1, int var2);
    }

    public static class IconColor {
        public Color color;
        public TextureRegion drawable;

        public IconColor(Color color, TextureRegion drawable) {
            this.color = color;
            this.drawable = drawable;
        }
    }
}

