/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.editor.overlays;

import com.badlogic.gdx.graphics.Color;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.editor.overlays.GradientOverlay;
import com.neutronio.astrax.editor.overlays.IconOverlay;
import com.neutronio.astrax.editor.overlays.SatelliteGradientOverlaySource;
import com.neutronio.astrax.editor.overlays.SatelliteIconOverlaySource;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.editor.DataLayer;
import java.util.Objects;

public class OverlayCreator {
    public static DataLayer createDataLayer(DataLayer dataLayer, GradientOverlay gradientOverlay, SatelliteGrid satelliteGrid) {
        int width = satelliteGrid.getData().getWidth();
        int height = satelliteGrid.getData().getHeight();
        dataLayer.resize(width, satelliteGrid.getData().getHeight());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                SatelliteGrid.SatelliteGridSettings settings = satelliteGrid.getData().get(x, y);
                if (settings == null) continue;
                if (gradientOverlay == null) {
                    dataLayer.getCell((int)x, (int)y).color = null;
                    dataLayer.getCell((int)x, (int)y).region = null;
                    continue;
                }
                dataLayer.getCell((int)x, (int)y).color = gradientOverlay.apply(x, y);
            }
        }
        return dataLayer;
    }

    public static DataLayer createDataLayer(DataLayer dataLayer, IconOverlay iconOverlay, SatelliteGrid satelliteGrid) {
        int width = satelliteGrid.getData().getWidth();
        int height = satelliteGrid.getData().getHeight();
        dataLayer.resize(width, satelliteGrid.getData().getHeight());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                SatelliteGrid.SatelliteGridSettings settings = satelliteGrid.getData().get(x, y);
                if (settings == null) continue;
                if (iconOverlay == null) {
                    dataLayer.getCell((int)x, (int)y).color = null;
                    dataLayer.getCell((int)x, (int)y).region = null;
                    continue;
                }
                IconOverlay.IconColor icon = iconOverlay.apply(x, y);
                dataLayer.getCell((int)x, (int)y).color = icon.color;
                dataLayer.getCell((int)x, (int)y).region = icon.drawable;
            }
        }
        return dataLayer;
    }

    public static IconOverlay getOxygenOverlay(SatelliteGrid satelliteGrid) {
        SatelliteIconOverlaySource source = new SatelliteIconOverlaySource(satelliteGrid){

            @Override
            public float getMax() {
                if (!this.satelliteGrid.tankSettings.containsKey("resource_oxygen")) {
                    return 1.0f;
                }
                return this.satelliteGrid.tankSettings.get((Object)"resource_oxygen").capacity;
            }

            @Override
            public float getCurrent(int x, int y) {
                SatelliteGrid.SatelliteGridSettings settings = this.satelliteGrid.getData().get(x, y);
                if (settings == null) {
                    return 0.0f;
                }
                if (settings.moduleSettings.tankSettings == null) {
                    return 0.0f;
                }
                if (Objects.equals("resource_oxygen", settings.moduleSettings.tankSettings.fuelType)) {
                    return settings.moduleSettings.tankSettings.capacity;
                }
                return 0.0f;
            }

            @Override
            public String getIcon(int x, int y) {
                SatelliteGrid.SatelliteGridSettings settings = this.satelliteGrid.getData().get(x, y);
                if (settings == null) {
                    return null;
                }
                if (settings.moduleSettings.tankSettings == null) {
                    return null;
                }
                if (Objects.equals("resource_oxygen", settings.moduleSettings.tankSettings.fuelType)) {
                    return "icon_inline_oxygen";
                }
                return null;
            }
        };
        ComponentFactory componentFactory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
        IconOverlay iconOverlay = new IconOverlay(componentFactory.getSkin(), Color.WHITE, Color.CYAN);
        iconOverlay.source = source;
        return iconOverlay;
    }

    public static GradientOverlay getWeightOverlay(SatelliteGrid satelliteGrid) {
        SatelliteGradientOverlaySource source = new SatelliteGradientOverlaySource(satelliteGrid){

            @Override
            public float getMax() {
                return this.satelliteGrid.statistics.maxWeight.floatValue();
            }

            @Override
            public float getCurrent(int x, int y) {
                SatelliteGrid.SatelliteGridSettings settings = this.satelliteGrid.getData().get(x, y);
                if (settings == null) {
                    return 0.0f;
                }
                return settings.moduleSettings.weight;
            }
        };
        GradientOverlay gradientOverlay = new GradientOverlay(Color.YELLOW, Color.MAGENTA);
        gradientOverlay.source = source;
        return gradientOverlay;
    }

    public static GradientOverlay getValueOverlay(SatelliteGrid satelliteGrid) {
        SatelliteGradientOverlaySource source = new SatelliteGradientOverlaySource(satelliteGrid){

            @Override
            public float getMax() {
                return this.satelliteGrid.statistics.maxValue.floatValue();
            }

            @Override
            public float getCurrent(int x, int y) {
                SatelliteGrid.SatelliteGridSettings settings = this.satelliteGrid.getData().get(x, y);
                if (settings == null) {
                    return 0.0f;
                }
                return settings.moduleSettings.value;
            }
        };
        GradientOverlay gradientOverlay = new GradientOverlay(Color.CYAN, Color.YELLOW);
        gradientOverlay.source = source;
        return gradientOverlay;
    }

    public static GradientOverlay getHullpointsOverlay(SatelliteGrid satelliteGrid) {
        SatelliteGradientOverlaySource source = new SatelliteGradientOverlaySource(satelliteGrid){

            @Override
            public float getMax() {
                return this.satelliteGrid.statistics.maxHullpoints.intValue();
            }

            @Override
            public float getCurrent(int x, int y) {
                SatelliteGrid.SatelliteGridSettings settings = this.satelliteGrid.getData().get(x, y);
                if (settings == null) {
                    return 0.0f;
                }
                return settings.moduleSettings.hullpoints;
            }
        };
        GradientOverlay gradientOverlay = new GradientOverlay(new Color(0.5f, 0.0f, 0.0f, 1.0f), Color.PINK);
        gradientOverlay.source = source;
        return gradientOverlay;
    }
}

