/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.editor.placement;

import com.neutronio.astrax.editor.placement.Orientation;
import java.util.Arrays;

public class Connector {
    public static final int TYPE_PHYSICAL = 1;
    public static final int TYPE_DOCKING = 2;
    public static final int TYPE_THRUSTER = 3;
    private boolean[] faces = new boolean[4];
    private int[] facesType = new int[4];

    public Connector(boolean north, boolean east, boolean south, boolean west) {
        this.faces[0] = north;
        this.faces[1] = east;
        this.faces[2] = south;
        this.faces[3] = west;
    }

    public void setTypes(int northType, int eastType, int southType, int westType) {
        this.facesType[0] = northType;
        this.facesType[1] = eastType;
        this.facesType[2] = southType;
        this.facesType[3] = westType;
    }

    public Connector copy() {
        Connector connector = new Connector(this.faces[0], this.faces[1], this.faces[2], this.faces[3]);
        connector.setTypes(this.facesType[0], this.facesType[1], this.facesType[2], this.facesType[3]);
        return connector;
    }

    public void rotate(int degrees) {
        int i2;
        int times = degrees / 90;
        boolean[] temp = new boolean[this.faces.length];
        for (i2 = 0; i2 < this.faces.length; ++i2) {
            int newIndex = (times + i2) % this.faces.length;
            temp[newIndex] = this.faces[i2];
        }
        for (i2 = 0; i2 < this.faces.length; ++i2) {
            this.faces[i2] = temp[i2];
        }
    }

    boolean connectsTo(Connector other, Orientation otherPosition) {
        switch (otherPosition) {
            case NORTH: {
                return this.faces[0] && other.faces[2] && this.facesType[0] == other.facesType[2];
            }
            case SOUTH: {
                return this.faces[2] && other.faces[0] && this.facesType[2] == other.facesType[0];
            }
            case EAST: {
                return this.faces[1] && other.faces[3] && this.facesType[1] == other.facesType[3];
            }
            case WEST: {
                return this.faces[3] && other.faces[1] && this.facesType[3] == other.facesType[1];
            }
        }
        return false;
    }

    public boolean isNorth() {
        return this.faces[0];
    }

    public boolean isEast() {
        return this.faces[1];
    }

    public boolean isSouth() {
        return this.faces[2];
    }

    public boolean isWest() {
        return this.faces[3];
    }

    public String toString() {
        return "Connector{faces=" + Arrays.toString(this.faces) + '}';
    }
}

