/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.editor.toolbox;

import com.badlogic.gdx.graphics.Color;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleSettings;
import com.neutronio.astrax.editor.placement.Connector;
import com.neutronio.astrax.editor.placement.Orientation;
import com.neutronio.astrax.editor.toolbox.EditorToolBase;
import com.neutronio.astrax.editor.toolbox.SpacecraftCell;
import com.neutronio.astrax.ui.editor.EditorCell;
import com.neutronio.astrax.ui.editor.EditorGrid;
import com.neutronio.astrax.ui.editor.tools.EditCanvasTile;
import com.neutronio.astrax.util.collections.Grid;
import java.util.ArrayList;
import java.util.List;

public class EditTool
extends EditorToolBase {
    public String placeSound = "editor_place_1";
    public String deleteSound = "retract";
    public String errorSound = "retract";
    public boolean erase = false;
    private List<EditToolListener> listeners = new ArrayList<EditToolListener>();
    private SpacecraftCell cellOptions = new SpacecraftCell();

    public EditTool() {
        super("edit", "icon_inline_edit");
        this.canvasTile = new EditCanvasTile(null);
    }

    @Override
    public String getActiveCursorName() {
        if (this.erase) {
            return "erase";
        }
        return this.cursor;
    }

    public void setEditorGrid(EditorGrid editorGrid) {
        this.getCanvasTile().setParent(editorGrid);
    }

    public void addListener(EditToolListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public ModuleSettings getSelected() {
        return this.cellOptions.module;
    }

    public SpacecraftCell getCellOptions() {
        return this.cellOptions;
    }

    public Orientation getCurrentOrientation() {
        return this.cellOptions.orientation;
    }

    public ModuleSettings getCurrentModuleSettings() {
        return this.cellOptions.module;
    }

    public void circleOrientation(int dir, Orientation orientation) {
        int index = (orientation.ordinal() + (int)Math.signum(dir)) % Orientation.values().length;
        if (index < 0) {
            index = Orientation.values().length - 1;
        }
        this.cellOptions.orientation = Orientation.values()[index];
        this.updateCell();
    }

    @Deprecated
    public void setCurrentModule(ModuleSettings selected) {
        this.cellOptions.module = selected;
        if (selected != null) {
            this.cellOptions.color = selected.color != null ? selected.color.cpy() : null;
        }
        this.updateCell();
    }

    public void changeOrientation(Orientation orientation) {
        this.cellOptions.orientation = orientation;
        this.updateCell();
    }

    public void changeModuleSettings(ModuleSettings settings) {
        this.cellOptions.module = settings;
        this.updateCell();
    }

    private void updateCell() {
        if (this.cellOptions.module != null) {
            this.cellOptions.connector = this.cellOptions.module.connector.copy();
            this.cellOptions.connector.rotate(this.cellOptions.orientation.getRotationDegrees());
            this.cellOptions.region = AstraXApp.astraX.getCoreDataPack().getTexture(this.cellOptions.module.textureRegion);
        } else {
            this.cellOptions.region = null;
            this.cellOptions.orientation = Orientation.NORTH;
            this.cellOptions.color = Color.WHITE;
            this.cellOptions.connector = new Connector(false, false, false, false);
        }
    }

    public void toggleMode() {
        if (this.erase) {
            this.setModePlace();
        } else {
            this.setModeErase();
        }
    }

    public void setModeErase() {
        this.erase = true;
        AstraXApp.astraX.getReactiveCursor().setActiveCursor("erase");
        AstraXApp.astraX.getUiSoundManager().playSoundOnce(this.deleteSound);
        EditCanvasTile editCanvasTile = (EditCanvasTile)this.getCanvasTile();
        editCanvasTile.apply(this.getCellOptions());
    }

    public void setModePlace() {
        this.erase = false;
        AstraXApp.astraX.getReactiveCursor().setActiveCursor("edit");
        AstraXApp.astraX.getUiSoundManager().playSoundOnce(this.placeSound);
        EditCanvasTile editCanvasTile = (EditCanvasTile)this.getCanvasTile();
        editCanvasTile.apply(this.getCellOptions());
    }

    private void erase(EditorCell cell) {
        cell.alphaTweening = 1.0f;
        cell.targetAlphaTweening = 0.0f;
        cell.module = null;
        cell.connector = null;
        cell.orientation = Orientation.NORTH;
        cell.color = Color.WHITE;
        for (EditToolListener listener : this.listeners) {
            listener.onErase(cell.x, cell.y);
        }
    }

    private void place(EditorCell cell) {
        if (cell != null && this.cellOptions.module != null) {
            cell.region = this.cellOptions.region;
            cell.module = this.cellOptions.module;
            cell.color = this.cellOptions.color;
            cell.connector = this.cellOptions.connector.copy();
            cell.orientation = this.cellOptions.orientation;
            cell.scaleTweening = 3.0f;
            cell.targetScaleTweening = 1.0f;
            cell.alphaTweening = 0.2f;
            cell.targetAlphaTweening = 1.0f;
            for (EditToolListener listener : this.listeners) {
                listener.onPlace(cell.x, cell.y, this.cellOptions.module, this.cellOptions.orientation, this.cellOptions.color);
            }
        }
    }

    @Override
    public void doAction(Grid<EditorCell> data) {
        EditorCell cell = data.get(this.getCanvasTile().location.x, this.getCanvasTile().location.y);
        if (this.erase) {
            if (cell.module != null) {
                this.erase(cell);
                AstraXApp.astraX.getUiSoundManager().playSoundOnce(this.deleteSound);
            }
        } else {
            if (this.getSelected() == null) {
                return;
            }
            if (this.getCanvasTile().canPaint) {
                this.place(cell);
                AstraXApp.astraX.getUiSoundManager().playSoundOnce(this.placeSound);
            }
        }
    }

    public static interface EditToolListener {
        public void onErase(int var1, int var2);

        public void onPlace(int var1, int var2, ModuleSettings var3, Orientation var4, Color var5);
    }
}

